/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ApplicationWebContextInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationWebContextInspector.class);
    private static final String COL_WARFILE = localStrings.getLocalString("ui.applicationwebcontextinspector.war_file", "WAR File");
    private static final String COL_CTXROOT = localStrings.getLocalString("ui.applicationwebcontextinspector.context_root", "Context Root");
    private static final String DUPLICATE_CONTEXT_ROOT = localStrings.getLocalString("at.applicationwebcontextinspector.duplicate_ctxroot", "Context Root must be unique.");
    private static final String WEBCONTEXT_ACC_DESC = localStrings.getLocalString("at.applicationwebcontextinspector.acc_desc", "List of the Context Roots and Associated War files in the Application");
    private static final String TABNAME = localStrings.getLocalString("ui.applicationwebcontextinspector.tabname", "Web Context");
    private static String wizardHelpID = "WebContext";
    private static String deployHelpID = "WebContext";
    private Application descriptor = null;
    public static final String ID_WEB_CONTEXT_TABLE = UITitledTable.SCRIPT_ID("table.web_context");
    private UITitledTable contextTablePanel = null;
    private WebContextTable webContextTable = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new ApplicationWebContextInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return Application.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (desc != this.descriptor) {
            this.descriptor = desc instanceof Application ? (Application)desc : null;
            this.webContextTable.clearTableData();
        }
    }

    private ApplicationWebContextInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.getAccessibleContext().setAccessibleName(TABNAME);
        this.getAccessibleContext().setAccessibleDescription(WEBCONTEXT_ACC_DESC);
        this.contextTablePanel = new UITitledTable(null, false);
        this.contextTablePanel.getAccessibleContext().setAccessibleName(TABNAME);
        this.contextTablePanel.getAccessibleContext().setAccessibleDescription(WEBCONTEXT_ACC_DESC);
        this.contextTablePanel.setScriptId(ID_WEB_CONTEXT_TABLE);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.contextTablePanel, c);
        this.webContextTable = new WebContextTable(new WebContextTableModel());
        this.contextTablePanel.setTableView(this.webContextTable);
    }

    public void refresh() {
        if (this.descriptor != null) {
            this.webContextTable.updateTableData(this.descriptor.getWebBundleDescriptors());
        } else {
            this.webContextTable.clearTableData();
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.contextTablePanel.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        Set wbds = this.descriptor.getWebBundleDescriptors();
        HashSet<String> ctxName = new HashSet<String>();
        Iterator itr = wbds.iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            String nm = wbd.getContextRoot();
            if (nm == null || nm.equals("")) continue;
            if (ctxName.contains(nm)) {
                if (showErrors) {
                    UIOptionPane.showErrorDialog(this, DUPLICATE_CONTEXT_ROOT);
                }
                return false;
            }
            ctxName.add(nm);
        }
        return true;
    }

    private class WebContextTableModel
    extends InspectorTableModel {
        public WebContextTableModel() {
            super(new String[]{COL_WARFILE, COL_CTXROOT});
        }

        public boolean isCellEditable(int row, int col) {
            return !this.isReadOnly() && col == 1;
        }

        public Object getObjectValue(Object obj, int col) {
            WebBundleDescriptor ref = (WebBundleDescriptor)obj;
            String value = "<???>";
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getContextRoot();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            WebBundleDescriptor ref = (WebBundleDescriptor)obj;
            String vs = value.toString();
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    if (vs.equals(ref.getContextRoot())) break;
                    if (!vs.equals("") && this.getRowWithValue(1, vs) != null) {
                        UIOptionPane.showErrorDialog(null, DUPLICATE_CONTEXT_ROOT);
                        break;
                    }
                    ref.setContextRoot(vs);
                }
            }
        }
    }

    private class WebContextTable
    extends InspectorTable {
        public WebContextTable(WebContextTableModel model) {
            super(model);
        }
    }
}

