/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.common.dd.application.SunApplication;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.shared.JndiNameInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.RoleMapInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunONESettingsDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTree;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Random;
import javax.swing.JFileChooser;

public class ApplicationGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationGeneralInspector.class);
    private static String CONTENTS = localStrings.getLocalString("ui.applicationgeneralinspector.contents_label", "Contents:");
    private static String CONTENTS_TOOLTIP = localStrings.getLocalString("at.applicationgeneralinspector.contents_label.tooltip", "Display of contents of the Application");
    private static String ADD_LIB_JAR = localStrings.getLocalString("ui.applicationgeneralinspector.add_library_jar_button", "Add Library JAR...");
    private static String ADD_LIB_JAR_ACC_DSC = localStrings.getLocalString("at.applicationgeneralinspector.add_library_jar_button.acc_dsc", "Add Library JAR to the Application");
    private static char ADD_LIB_JAR_MNEMONIC = localStrings.getLocalString("ui.applicationgeneralinspector.add_library_jar_button_mnemonic", "A").charAt(0);
    private static String REMOVE_LIB_JAR = localStrings.getLocalString("ui.applicationgeneralinspector.remove_library_jar_button", "Remove Library JAR...");
    private static String REMOVE_LIB_JAR_ACC_DSC = localStrings.getLocalString("at.applicationgeneralinspector.remove_library_jar_button.acc_dsc", "Remove Library JAR from the Application");
    private static char REMOVE_LIB_JAR_MNEMONIC = localStrings.getLocalString("ui.applicationgeneralinspector.remove_library_jar_button_mnemonic", "R").charAt(0);
    private static String UNIQUE_ID = localStrings.getLocalString("at.applicationgeneralinspector.unique_id", "Unique Id");
    private static String UNIQUE_ID_TOOLTIP = localStrings.getLocalString("at.applicationgeneralinspector.unique_id.tooltip", "Automatically generated Unique Id for Application");
    private static String PASS_BY_REFERENCE = localStrings.getLocalString("at.applicationgeneralinspector.pass_by_reference", "Pass By Reference");
    private static String PASS_BY_REFERENCE_TOOLTIP = localStrings.getLocalString("at.applicationgeneralinspector.pass_by_reference.tooltil", "Pass By Reference attribute value for Application");
    private static String DESCRIPTION_ACC_DSC = localStrings.getLocalString("at.applicationgeneralinspector.description.acc_dsc", "Enter Description for Application");
    private static String ICONS_ACC_DSC = localStrings.getLocalString("at.applicationgeneralinspector.icons.acc_dsc", "Add Icons for Application");
    private static String SUN_SETTINGS_BTN_LABEL = localStrings.getLocalString("at.applicationgeneralinspector.sun_settings_btn.label", "Sun-specific Settings...");
    private static String SUN_SETTINGS_BTN_MNEMONIC = localStrings.getLocalString("at.applicationgeneralinpsector.sun_settings_btn.mnemonic", "S");
    private static String TABNAME = localStrings.getLocalString("ui.applicationgeneralinspector.tabname", "General");
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    private Application descriptor = null;
    private SunApplication sunApplication = null;
    private static boolean IncludeJustJars = false;
    private static boolean ShowContentsAsTree = true;
    private UITitledTextField uniqueIdText = null;
    private UITitledComboBox passByReferenceCombo = null;
    private UIButton addLibJarButton = null;
    private UIButton removeLibJarButton = null;
    private UIDisplayNameBox fileDisplayBox = null;
    private UIControlButtonBox contentsList = null;
    private IconInspector.DialogDisplayButton iconInspector = null;
    private DescriptionInspector.DialogDisplayButton descInspector = null;
    private UIButton sunSettingsBtn = null;
    private static Random generateId = new Random();
    private String[] referenceValues = new String[]{"false", "true"};
    private SunONESettingsDialog sunSettingsDialog = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new ApplicationGeneralInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return Application.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof Application) {
            this.descriptor = (Application)obj;
            this.sunApplication = (SunApplication)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ApplicationGeneralInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this.fileDisplayBox = new UIDisplayNameBox(99, false);
        this.fileDisplayBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ApplicationGeneralInspector.this.descriptor.setDisplayName(ApplicationGeneralInspector.this.fileDisplayBox.getDisplayName());
                ApplicationGeneralInspector.this.invokeRefresh();
            }
        });
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)this.fileDisplayBox, c);
        UIPanel extraAttributesPanel = new UIPanel(new GridBagLayout());
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.uniqueIdText = new UITitledTextField(UNIQUE_ID, false);
        this.uniqueIdText.setToolTipText(UNIQUE_ID_TOOLTIP);
        this.uniqueIdText.setReadOnly(true);
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.passByReferenceCombo = new UITitledComboBox(PASS_BY_REFERENCE, false);
        this.passByReferenceCombo.setToolTipText(PASS_BY_REFERENCE_TOOLTIP);
        this.passByReferenceCombo.setModel(this.referenceValues);
        this.passByReferenceCombo.setSelectedIndex(0);
        this.passByReferenceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ApplicationGeneralInspector.this.sunApplication.setPassByReference(ApplicationGeneralInspector.this.passByReferenceCombo.getSelectedItem().toString());
                ApplicationGeneralInspector.this.descriptor.changed();
                ApplicationGeneralInspector.this.invokeRefresh();
            }
        });
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 7);
        if (ShowContentsAsTree) {
            UITitledTree treeContents = new UITitledTree(CONTENTS, true);
            treeContents.setRootVisible(false);
            treeContents.setShowsRootHandles(true);
            this.contentsList = treeContents;
        } else {
            this.contentsList = new UITitledList(CONTENTS, true);
        }
        this.contentsList.setToolTipText(CONTENTS_TOOLTIP);
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)this.contentsList, c);
        this.addLibJarButton = new UIButton(ADD_LIB_JAR, ADD_LIB_JAR_MNEMONIC);
        this.addLibJarButton.getAccessibleContext().setAccessibleName(ADD_LIB_JAR);
        this.addLibJarButton.getAccessibleContext().setAccessibleDescription(ADD_LIB_JAR_ACC_DSC);
        this.addLibJarButton.setMinimumSize(new Dimension(100, 25));
        this.addLibJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ApplicationGeneralInspector.this.addLibJarAction();
            }
        });
        this.contentsList.addControlButton(this.addLibJarButton);
        this.removeLibJarButton = new UIButton(REMOVE_LIB_JAR, REMOVE_LIB_JAR_MNEMONIC);
        this.removeLibJarButton.getAccessibleContext().setAccessibleName(REMOVE_LIB_JAR);
        this.removeLibJarButton.getAccessibleContext().setAccessibleDescription(REMOVE_LIB_JAR_ACC_DSC);
        this.removeLibJarButton.setMinimumSize(new Dimension(100, 25));
        this.removeLibJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ApplicationGeneralInspector.this.removeLibJarAction();
            }
        });
        this.contentsList.addControlButton(this.removeLibJarButton);
        UIControlButtonBox buttonBox = new UIControlButtonBox(null, false);
        buttonBox.setControlButtonLocation(15, true);
        this.sunSettingsBtn = new UIButton(SUN_SETTINGS_BTN_LABEL, SUN_SETTINGS_BTN_MNEMONIC.charAt(0));
        this.sunSettingsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ApplicationGeneralInspector.this.sunSettingsDialog();
            }
        });
        buttonBox.addControlButton(this.sunSettingsBtn);
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        this.descInspector.getAccessibleContext().setAccessibleDescription(DESCRIPTION_ACC_DSC);
        buttonBox.addControlButton(this.descInspector);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        this.iconInspector.getAccessibleContext().setAccessibleDescription(ICONS_ACC_DSC);
        buttonBox.addControlButton(this.iconInspector);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)buttonBox, c);
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        this._addDeploymentIcon("large", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
    }

    public void addSmallIcon(File iconFile) {
        this._addDeploymentIcon("small", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
    }

    private void addLibJarAction() {
        UIFileChooser jfc = UIFileChooser.getFileChooser(null, "JarFiles");
        int returnValue = ((JFileChooser)jfc).showDialog(this, localStrings.getLocalString("ui.applicationgeneralinspector.add_library_jar", "Add Library JAR"));
        if (returnValue == 0) {
            File libJarFile = ((JFileChooser)jfc).getSelectedFile();
            UIOptionPane.showKeyInfoDialog(this, "App.addLibJar", localStrings.getLocalString("ui.applicationgeneralinspector.add_library_jar_note", "Note: This library JAR will be added to the manifest classpath of all components in this application"));
            ModuleArchive.getModuleArchive((Descriptor)this.descriptor).addLibraryJar(libJarFile);
        }
        this.invokeRefresh();
    }

    private void removeLibJarAction() {
        Object[] libraryJars = null;
        try {
            libraryJars = ModuleArchive.getModuleArchive((Descriptor)this.descriptor).getLibraryJarEntries().toArray();
        }
        catch (Throwable ioe) {
            Print.printStackTrace((String)"Error getting library jars", (Throwable)ioe);
        }
        if (Array.getLength(libraryJars) > 0) {
            Object selValue = UIOptionPane.showListInputDialog(this, localStrings.getLocalString("ui.applicationgeneralinspector.select_library_jar", "Select the library .jar to be removed:"), libraryJars);
            if (selValue != null) {
                try {
                    ModuleArchive.getModuleArchive((Descriptor)this.descriptor).removeLibraryJarEntry((String)selValue);
                }
                catch (Throwable ioe) {
                    Print.printStackTrace((String)("Error removing library jar: " + selValue), (Throwable)ioe);
                }
                this.invokeRefresh();
            }
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.applicationgeneralinspector.no_library_jars", "There are no library .jar files in this application"));
        }
    }

    public void refresh() {
        ModuleArchive modArch = ModuleArchive.getModuleArchive((Descriptor)this.descriptor);
        this.fileDisplayBox.setFileLocation(modArch.getArchiveUri());
        this.fileDisplayBox.setDisplayName(this.descriptor.getDisplayName());
        if (this.sunApplication != null) {
            if (this.sunApplication.getPassByReference() == null) {
                this.passByReferenceCombo.setSelectedIndex(0);
                this.sunApplication.setPassByReference(this.passByReferenceCombo.getSelectedItem().toString());
            } else {
                String PF = this.sunApplication.getPassByReference();
                if ("true".equals(PF)) {
                    this.passByReferenceCombo.setSelectedIndex(1);
                } else if ("false".equals(PF)) {
                    this.passByReferenceCombo.setSelectedIndex(0);
                } else {
                    Print.dprintln((String)("PassByReference=" + PF));
                    this.passByReferenceCombo.setSelectedIndex(0);
                }
            }
        }
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getDisplayName(), this, this.descriptor);
        try {
            List libJars;
            List list = libJars = IncludeJustJars ? modArch.getLibraryJarEntries() : modArch.getEntryNames();
            if (this.contentsList instanceof UITitledTree) {
                ((UITitledTree)this.contentsList).setArchiveData("<root>", libJars);
            } else {
                ListTools.sortList(libJars, true);
                ((UITitledList)this.contentsList).setListData(libJars);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.fileDisplayBox.setReadOnly(state);
        this.contentsList.setReadOnly(state);
        this.descInspector.setReadOnly(state);
        this.iconInspector.setEnabled(!state);
    }

    private void sunSettingsDialog() {
        if (this.sunSettingsDialog == null) {
            Frame frame = DT.getApplicationFrame();
            this.sunSettingsDialog = new SunONESettingsDialog(frame);
            String mode = "DeploymentMode";
            this.sunSettingsDialog.addPanel(this, JndiNameInspector.newInspectorPane(mode));
            this.sunSettingsDialog.addPanel(this, RoleMapInspector.newInspectorPane(mode));
        }
        this.sunSettingsDialog.setAllPanelsEnabled();
        this.sunSettingsDialog.show((Descriptor)this.descriptor, null);
    }
}

