/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.tools.deployment.ui.app.UsersDialog;
import com.sun.enterprise.tools.deployment.ui.shared.DTRoleMapper;
import com.sun.enterprise.tools.deployment.ui.shared.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AppSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AppSecurityInspector.class);
    private static String PANEL_NAME = localStrings.getLocalString("ui.appsecurityinspector.table.panel_name", "Client Inspector Panel");
    private static String PANEL_DESC = localStrings.getLocalString("ui.appsecurityinspector.table.panel_desc", "This panel is for the application client security inspector window");
    private static String ROLES_REFERENCED = localStrings.getLocalString("ui.appsecurityinspector.table.roles_title", "Role names referenced:");
    private static String ROLES_USERS = localStrings.getLocalString("ui.appsecurityinspector.table.users_title", "Users in role:");
    private static String TABNAME = localStrings.getLocalString("ui.appsecurityinspector.tabname", "Security");
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    private Application application = null;
    private RoleNamesTableModel roleNamesTableModel = null;
    private RoleNamesTable roleNamesTable = null;
    private RoleUsersTableModel usersTableModel = null;
    private RoleUsersTable usersTable = null;
    private RoleUsersTableModel userGroupsTableModel = null;
    private RoleUsersTable userGroupsTable = null;
    private UsersDialog usersDialog = null;
    private JButton addSecConstPB = null;
    private JButton delSecConstPB = null;
    private JButton editSecConstPB = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new AppSecurityInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return Application.class;
    }

    public Descriptor getDescriptor() {
        return this.application;
    }

    public void setDescriptor(Descriptor object) {
        if (object instanceof Application) {
            this.application = (Application)object;
            this.invokeRefresh();
        } else {
            this.application = null;
        }
    }

    private AppSecurityInspector() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        UIControlButtonBox tablesBox = new UIControlButtonBox(null, false);
        tablesBox.setControlButtonLocation(15);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)tablesBox, c);
        UIPanel tabledPanel = new UIPanel(PANEL_NAME, PANEL_DESC);
        GridBagLayout tgb = new GridBagLayout();
        tabledPanel.setLayout(tgb);
        tablesBox.setView(tabledPanel, false);
        UITitledTable roleNamesView = new UITitledTable(ROLES_REFERENCED, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(2, 0, 0, 5);
        c.fill = 1;
        tabledPanel.add((Component)roleNamesView, c);
        this.roleNamesTableModel = new RoleNamesTableModel();
        this.roleNamesTable = new RoleNamesTable(this.roleNamesTableModel);
        roleNamesView.setTableView(this.roleNamesTable);
        this.roleNamesTable.setSelectionMode(0);
        this.roleNamesTable.setAutoResizeMode(4);
        this.roleNamesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e.getSource();
                if (sm.isSelectionEmpty()) {
                    AppSecurityInspector.this.usersTable.clearSelection();
                    AppSecurityInspector.this.userGroupsTable.clearSelection();
                } else {
                    AppSecurityInspector.this.showUsersInSelectedRole();
                }
            }
        });
        UITitledTable roleUsersView = new UITitledTable(ROLES_USERS, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(2, 0, 0, 0);
        c.fill = 1;
        tabledPanel.add((Component)roleUsersView, c);
        this.usersTableModel = new RoleUsersTableModel(true);
        this.usersTable = new RoleUsersTable(this.usersTableModel);
        roleUsersView.setTableView(this.usersTable);
        this.usersTable.setSelectionMode(0);
        this.usersTable.setAutoResizeMode(4);
        ListSelectionModel usersSelectionModel = this.usersTable.getSelectionModel();
        usersSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e.getSource();
                if (!sm.isSelectionEmpty()) {
                    AppSecurityInspector.this.userGroupsTable.clearSelection();
                    AppSecurityInspector.this.delSecConstPB.setEnabled(true);
                } else if (AppSecurityInspector.this.userGroupsTable.getSelectedRow() < 0) {
                    AppSecurityInspector.this.delSecConstPB.setEnabled(false);
                }
            }
        });
        UITitledTable userGroupsView = new UITitledTable(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 2, 0);
        c.fill = 1;
        tabledPanel.add((Component)userGroupsView, c);
        this.userGroupsTableModel = new RoleUsersTableModel(false);
        this.userGroupsTable = new RoleUsersTable(this.userGroupsTableModel);
        userGroupsView.setTableView(this.userGroupsTable);
        this.userGroupsTable.setSelectionMode(0);
        this.userGroupsTable.setAutoResizeMode(4);
        ListSelectionModel userGroupsSelectionModel = this.userGroupsTable.getSelectionModel();
        userGroupsSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e.getSource();
                if (!sm.isSelectionEmpty()) {
                    AppSecurityInspector.this.usersTable.clearSelection();
                    AppSecurityInspector.this.delSecConstPB.setEnabled(true);
                } else if (AppSecurityInspector.this.usersTable.getSelectedRow() < 0) {
                    AppSecurityInspector.this.delSecConstPB.setEnabled(false);
                }
            }
        });
        this.addSecConstPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppSecurityInspector.this.addUserAction();
            }
        });
        tablesBox.addControlButton(this.addSecConstPB);
        this.delSecConstPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppSecurityInspector.this.deleteUserAction();
            }
        });
        tablesBox.addControlButton(this.delSecConstPB);
        this.delSecConstPB.setEnabled(false);
        this.editSecConstPB = RolesDialog.getEditRolesButton(this);
        tablesBox.addControlButton(this.editSecConstPB);
    }

    private void showUsersInSelectedRole() {
        this.usersTable.clearTableData();
        this.userGroupsTable.clearTableData();
        if (this.application == null) {
            return;
        }
        String role = this.roleNamesTable.getSelectedRole();
        if (role == null) {
            return;
        }
        SecurityRoleMapper roleMapper = this.application.getRoleMapper();
        ArrayList associatedPrincipals = new ArrayList();
        Enumeration e = null;
        e = roleMapper.getUsersAssignedTo(new Role(role));
        while (e.hasMoreElements()) {
            associatedPrincipals.add(e.nextElement());
        }
        ArrayList associatedGroups = new ArrayList();
        e = roleMapper.getGroupsAssignedTo(new Role(role));
        while (e.hasMoreElements()) {
            associatedGroups.add(e.nextElement());
        }
        Vector<StringBuffer> userNames = new Vector<StringBuffer>();
        Iterator iter = associatedPrincipals.iterator();
        while (iter.hasNext()) {
            PrincipalImpl principal = (PrincipalImpl)iter.next();
            String n = principal.getName();
            userNames.add(new StringBuffer(n));
        }
        this.usersTable.updateTableData(userNames);
        Vector<StringBuffer> groupNames = new Vector<StringBuffer>();
        iter = associatedGroups.iterator();
        while (iter.hasNext()) {
            PrincipalImpl principal = (PrincipalImpl)iter.next();
            String n = principal.getName();
            groupNames.add(new StringBuffer(n));
        }
        this.userGroupsTable.updateTableData(groupNames);
    }

    private void addUserToRoleMapper(String selectedUser) {
        Role role = new Role(this.roleNamesTable.getSelectedRole());
        SecurityRoleMapper roleMapper = this.application.getRoleMapper();
        roleMapper.assignRole((Principal)new PrincipalImpl(selectedUser), role);
    }

    private void addGroupToRoleMapper(String selectedUser) {
        Role role = new Role(this.roleNamesTable.getSelectedRole());
        SecurityRoleMapper roleMapper = this.application.getRoleMapper();
        roleMapper.assignRole((Principal)new Group(selectedUser), role);
    }

    private void addUserAction() {
        if (this.roleNamesTable.getSelectedRow() < 0) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.appsecurityinspector.please_select_role", "You must select a role before attempting to add users."));
            return;
        }
        if (this.usersDialog == null) {
            Frame frame = this.getMyParentFrame();
            this.usersDialog = new UsersDialog(frame, true);
            CSH.setHelpIDString((Component)this.usersDialog, (String)"AIAddUser");
            this.usersDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent we) {
                    if (AppSecurityInspector.this.usersDialog.isFinished()) {
                        String selectedGroup;
                        String selectedUser = AppSecurityInspector.this.usersDialog.getSelectedUser();
                        if (selectedUser != null) {
                            AppSecurityInspector.this.addUserToRoleMapper(selectedUser);
                        }
                        if ((selectedGroup = AppSecurityInspector.this.usersDialog.getSelectedGroup()) != null) {
                            AppSecurityInspector.this.addGroupToRoleMapper(selectedGroup);
                        }
                        AppSecurityInspector.this.showUsersInSelectedRole();
                    }
                }
            });
            this.usersDialog.pack();
        }
        this.usersDialog.setLocationRelativeTo(this.usersDialog.getOwner());
        this.usersDialog.show();
    }

    private void deleteUserAction() {
        Frame frame = WinTools.getAncestorFrame(this);
        SecurityRoleMapper roleMapper = this.application.getRoleMapper();
        Role role = new Role(this.roleNamesTable.getSelectedRole());
        String selUserName = this.usersTable.getSelectedUser();
        String selGroupName = this.userGroupsTable.getSelectedUser();
        if (selUserName != null) {
            boolean n = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.appsecurityinspector.confirm_delete_user", "Are you sure you want to delete selected user?"));
            if (n) {
                if (roleMapper instanceof DTRoleMapper) {
                    ((DTRoleMapper)roleMapper).unassignRole((Principal)new PrincipalImpl(selUserName), role);
                }
                this.showUsersInSelectedRole();
            }
        } else if (selGroupName != null) {
            boolean n = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.appsecurityinspector.confirm_delete_group", "Are you sure you want to delete selected group?"));
            if (n) {
                if (roleMapper instanceof DTRoleMapper) {
                    ((DTRoleMapper)roleMapper).unassignRole((Principal)new Group(selGroupName), role);
                }
                this.showUsersInSelectedRole();
            }
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.appsecurityinspector.please_select_user_or_group", "You must first select a user or group from the list"));
        }
    }

    public void refresh() {
        if (this.application == null) {
            return;
        }
        Vector<StringBuffer> roleNames = new Vector<StringBuffer>();
        Iterator itr = this.application.getRoles().iterator();
        while (itr.hasNext()) {
            Role nextRole = (Role)itr.next();
            String n = nextRole.getName();
            roleNames.add(new StringBuffer(n));
        }
        this.roleNamesTable.updateTableData(roleNames);
        this.showUsersInSelectedRole();
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.addSecConstPB.setEnabled(!state);
        this.delSecConstPB.setEnabled(!state);
        this.editSecConstPB.setEnabled(!state);
    }

    public class RoleUsersTableModel
    extends InspectorTableModel {
        public RoleUsersTableModel(boolean isUserTable) {
            super(new String[]{isUserTable ? localStrings.getLocalString("ui.appsecurityinspector.table.user_name", "User name") : localStrings.getLocalString("ui.appsecurityinspector.table.group_name", "Group name")});
            this.columnNames = this.columnNames;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            return obj.toString();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            StringBuffer sb = (StringBuffer)obj;
            sb.setLength(0);
            sb.append(value.toString());
        }
    }

    private class RoleUsersTable
    extends InspectorTable {
        public RoleUsersTable(RoleUsersTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }

        public String getSelectedUser() {
            Object ref = this.getSelectedRowObject();
            return ref != null ? ref.toString() : null;
        }
    }

    private class RoleNamesTableModel
    extends InspectorTableModel {
        public RoleNamesTableModel() {
            super(new String[]{localStrings.getLocalString("ui.appsecurityinspector.table.roles_name", "Role Name")});
        }

        public Object getObjectValue(Object obj, int col) {
            return obj.toString();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            StringBuffer sb = (StringBuffer)obj;
            sb.setLength(0);
            sb.append(value.toString());
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class RoleNamesTable
    extends InspectorTable {
        public RoleNamesTable(RoleNamesTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }

        public String getSelectedRole() {
            Object ref = this.getSelectedRowObject();
            return ref != null ? ref.toString() : null;
        }
    }
}

