/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.dtv.NodeDescriptors;
import com.sun.enterprise.tools.deployment.ui.dtv.UIDescriptorTree;
import com.sun.enterprise.tools.deployment.ui.server.DeployedObjectDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTabbedPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JRootPane;
import javax.swing.text.JTextComponent;

public class DTClipboard {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DTClipboard.class);
    private static final String APP_CLIPBOARD = "APP_ClipBoard.ear";
    private static final String EJB_CLIPBOARD = "EJB_ClipBoard.jar";
    private static final String WAR_CLIPBOARD = "WAR_ClipBoard.war";
    private static final String RAR_CLIPBOARD = "RAR_ClipBoard.rar";
    private static final String APC_CLIPBOARD = "APPC_ClipBoard.jar";
    private Component focusPanel = null;
    private File clipboardFile = null;
    private String clipboardDisplayName = null;
    private String clipboardModuleType = null;

    private static String OKTODELETE_SELECTION(String v0) {
        return localStrings.getLocalString("ui.dtclipboard.confirm_delete_selection", "Are you sure you want to delete selection?\n ''{0}''", new Object[]{v0});
    }

    protected static String UNABLE_TO_DELETE_REFERENCED_EJB(String v0) {
        return localStrings.getLocalString("ui.dtclipboard.ejb_currently_referenced", "Unable to delete selection.\nThis EJB/Module is referenced by the following components:\n{0}", new Object[]{v0});
    }

    protected static String DELETE_FAILED(String v0) {
        return localStrings.getLocalString("ui.dtclipboard.delete_failed", "Delete failed: {0}", new Object[]{v0});
    }

    public DTClipboard(Component focusPanel) {
        this.focusPanel = focusPanel != null ? focusPanel : DT.getApplicationFrame();
    }

    protected File createClipboardFile(String cbName, String displayName) {
        if (this.clipboardFile != null && this.clipboardFile.exists()) {
            this.clipboardFile.delete();
            this.clipboardFile = null;
            this.clipboardDisplayName = null;
        }
        if (cbName != null) {
            this.clipboardFile = UIConfig.makeTempFile(cbName);
            if (this.clipboardFile.exists()) {
                this.clipboardFile.delete();
            }
            this.clipboardDisplayName = displayName;
        }
        return this.clipboardFile;
    }

    protected File getClipboardFile() {
        return this.clipboardFile != null && this.clipboardFile.exists() ? this.clipboardFile : null;
    }

    protected String getClipboardDisplayName() {
        return this.clipboardFile != null && this.clipboardFile.exists() ? this.clipboardDisplayName : null;
    }

    protected Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    protected Descriptor getFocusSelection(String oper) {
        Component c = this.getFocusOwner();
        if (c == null) {
            Print.dprintln((String)("'" + oper + "': null focusOwner"));
        } else if (c instanceof InspectorTabbedPane) {
            InspectorTabbedPane ied = (InspectorTabbedPane)c;
            if (DT.getInspectorManager().isValidInspector(ied)) {
                return ied.getDescriptor();
            }
        } else {
            if (c instanceof UIDescriptorTree) {
                return DT.getSelectedDescriptor();
            }
            if (c instanceof JRootPane) {
                return DT.getSelectedDescriptor();
            }
            Print.dprintln((String)("'" + oper + "': component - " + c.getClass().getName()));
        }
        return null;
    }

    public void cutAction() {
        if (this.copyAction(true)) {
            this.deleteAction();
        }
    }

    public void copyAction() {
        this.copyAction(false);
    }

    protected boolean copyAction(boolean isCutAction) {
        Component c = this.getFocusOwner();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).grabFocus();
            ((JTextComponent)c).copy();
            return true;
        }
        Descriptor selCopy = this.getFocusSelection(isCutAction ? "Cut" : "Copy");
        if (selCopy == null) {
            String msg = isCutAction ? localStrings.getLocalString("ui.dtclipboard.nothing_to_cut", "Nothing to cut") : localStrings.getLocalString("ui.dtclipboard.nothing_to_copy", "Nothing to copy");
            UIOptionPane.showWarningDialog(this.focusPanel, msg);
            return false;
        }
        if (isCutAction && selCopy instanceof DeployedObjectDescriptor) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.please_use_undeploy", "Please use 'Undeploy' to remove deployed objects"));
            return false;
        }
        if (selCopy instanceof EjbDescriptor || selCopy instanceof WebComponentDescriptor) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.cant_copy_components", "Individual components cannot be cut/copied."));
            return false;
        }
        try {
            if (selCopy instanceof Application) {
                File cbFile = this.createClipboardFile(APP_CLIPBOARD, selCopy.getDisplayName());
                ModuleArchive.getModuleArchive(selCopy).saveAs(cbFile);
                return true;
            }
            if (selCopy instanceof EjbBundleDescriptor) {
                File cbFile = this.createClipboardFile(EJB_CLIPBOARD, selCopy.getDisplayName());
                ModuleArchive.getModuleArchive(selCopy).saveAs(cbFile);
                return true;
            }
            if (selCopy instanceof WebBundleDescriptor) {
                File cbFile = this.createClipboardFile(WAR_CLIPBOARD, selCopy.getDisplayName());
                ModuleArchive.getModuleArchive(selCopy).saveAs(cbFile);
                return true;
            }
            if (selCopy instanceof ConnectorDescriptor) {
                File cbFile = this.createClipboardFile(RAR_CLIPBOARD, selCopy.getDisplayName());
                ModuleArchive.getModuleArchive(selCopy).saveAs(cbFile);
                return true;
            }
            if (selCopy instanceof ApplicationClientDescriptor) {
                File cbFile = this.createClipboardFile(APC_CLIPBOARD, selCopy.getDisplayName());
                ModuleArchive.getModuleArchive(selCopy).saveAs(cbFile);
                return true;
            }
            if (selCopy instanceof ServerDescriptor) {
                File cbFile = this.createClipboardFile(null, null);
                return false;
            }
            File cbFile = this.createClipboardFile(null, null);
            return false;
        }
        catch (Throwable t) {
            Print.dprintln((String)("Error copying: " + t.toString()));
            UIOptionPane.showErrorDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.error_while_copying", "Error while copying"));
            return false;
        }
    }

    public void pasteAction() {
        Application targetApp;
        Component c = this.getFocusOwner();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).grabFocus();
            ((JTextComponent)c).paste();
            return;
        }
        Descriptor selPaste = this.getFocusSelection("Paste");
        if (selPaste instanceof ServerDescriptor) {
            return;
        }
        if (selPaste instanceof DeployedObjectDescriptor) {
            return;
        }
        File cbFile = this.getClipboardFile();
        if (cbFile == null) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.nothing_to_paste", "Nothing to paste"));
            return;
        }
        if (selPaste == null || selPaste instanceof NodeDescriptors.TreeRootDescriptor) {
            File saveFile;
            String cbExt = FileTools.GetFileExtension(cbFile);
            if (!cbExt.startsWith(".")) {
                cbExt = "." + cbExt;
            }
            if ((saveFile = UIOptionPane.showFileInputDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.enter_clipboard_save_file", "Please enter the file name to which the clipboard module ({0}) will be saved.", new Object[]{cbExt}), UIConfig.getHomeDirectory(), UIFileChooser.getFilterNameForExtension(cbExt))) != null && !FileTools.StrFileHasExtension(saveFile.toString(), cbExt)) {
                saveFile = new File(saveFile + cbExt);
            }
            if (FileTools.checkFileOverwrite(this.focusPanel, saveFile)) {
                try {
                    FileTools.copyFiles(cbFile, saveFile);
                    DT.getModuleManager().openModule(saveFile);
                }
                catch (Throwable t) {
                    Print.printStackTrace((String)"Open", (Throwable)t);
                    UIOptionPane.showErrorDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.error_while_opening", "Error while opening\n{0}", new Object[]{t.toString()}));
                }
            }
            return;
        }
        Descriptor actvDesc = DT.getActiveModule();
        Application application = targetApp = actvDesc instanceof Application ? (Application)actvDesc : null;
        if (targetApp == null) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.choose_an_application", "Choose an application onto which to paste"));
            return;
        }
        String cbDisplayName = this.getClipboardDisplayName();
        if (cbDisplayName != null) {
            Set bundleDescSet = null;
            String cbFileName = cbFile.getName();
            if (!cbFileName.equals(APP_CLIPBOARD)) {
                if (cbFileName.equals(EJB_CLIPBOARD)) {
                    bundleDescSet = targetApp.getEjbBundleDescriptors();
                } else if (cbFileName.equals(WAR_CLIPBOARD)) {
                    bundleDescSet = targetApp.getWebBundleDescriptors();
                } else if (cbFileName.equals(RAR_CLIPBOARD)) {
                    bundleDescSet = targetApp.getRarDescriptors();
                } else if (cbFileName.equals(APC_CLIPBOARD)) {
                    bundleDescSet = targetApp.getApplicationClientDescriptors();
                }
            }
            if (bundleDescSet != null) {
                Iterator i = bundleDescSet.iterator();
                while (i.hasNext()) {
                    BundleDescriptor bd = (BundleDescriptor)i.next();
                    if (!bd.getDisplayName().equals(cbDisplayName)) continue;
                    UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.name_already_exists", "A bundle with this name already exists.\n{0}", new Object[]{cbDisplayName}));
                    return;
                }
            }
        }
        try {
            ModuleArchive.getModuleArchive((Descriptor)targetApp).addArchive(cbFile);
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Paste", (Throwable)t);
            UIOptionPane.showErrorDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.error_while_pasting", "Error while pasting"));
        }
    }

    public void deleteAction() {
        Component c = this.getFocusOwner();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).cut();
            return;
        }
        Descriptor selDelete = this.getFocusSelection("Delete");
        if (selDelete == null) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.no_object_selected", "No object was selected"));
            return;
        }
        if (selDelete instanceof ServerDescriptor) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.please_use_remove_server", "Please use 'Remove Server' to remove this server uri"));
            return;
        }
        if (DescriptorTools.isModuleDescriptor(selDelete)) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.please_use_close_module", "Please use 'Close' to close this module"));
            return;
        }
        if (selDelete instanceof DeployedObjectDescriptor) {
            UIOptionPane.showWarningDialog(this.focusPanel, localStrings.getLocalString("ui.dtclipboard.please_use_undeploy", "Please use 'Undeploy' to remove deployed objects"));
            return;
        }
        if (!UIOptionPane.showConfirmDialog(this.focusPanel, DTClipboard.OKTODELETE_SELECTION(selDelete.getName()))) {
            return;
        }
        if (selDelete instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)selDelete;
            Application app = bd.getApplication();
            Set referants = DescriptorTools.getEjbReferants((Descriptor)bd, (Descriptor)app);
            if (referants != null) {
                StringBuffer sb = new StringBuffer();
                Iterator i = referants.iterator();
                while (i.hasNext()) {
                    Descriptor d = (Descriptor)i.next();
                    sb.append("    ").append(d.getName()).append("\n");
                }
                UIOptionPane.showErrorDialog(this.focusPanel, DTClipboard.UNABLE_TO_DELETE_REFERENCED_EJB(sb.toString()));
                return;
            }
            try {
                UIProject.removeProject((Descriptor)bd);
                ModuleArchive.getModuleArchive((Descriptor)bd).removeFromApplication();
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)"Delete failed", (Throwable)t);
                UIOptionPane.showErrorDialog(this.focusPanel, DTClipboard.DELETE_FAILED(t.toString()));
            }
            return;
        }
        if (selDelete instanceof EjbDescriptor) {
            EjbDescriptor ejb;
            EjbBundleDescriptor ebd = (ejb = (EjbDescriptor)selDelete).getEjbBundleDescriptor();
            Application app = ebd.getApplication();
            Set referants = DescriptorTools.getEjbReferants((Descriptor)ejb, (Descriptor)(app != null ? app : ebd));
            if (referants != null) {
                StringBuffer sb = new StringBuffer();
                Iterator i = referants.iterator();
                while (i.hasNext()) {
                    Descriptor d = (Descriptor)i.next();
                    sb.append("    ").append(d.getName()).append("\n");
                }
                UIOptionPane.showErrorDialog(this.focusPanel, DTClipboard.UNABLE_TO_DELETE_REFERENCED_EJB(sb.toString()));
                return;
            }
            try {
                DescriptorTools.removeWebServiceEndpoints((Descriptor)ejb);
                ebd.removeEjb(ejb);
                SunOneUtils.removeSunEjb(ebd, ejb);
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)"Delete failed", (Throwable)t);
                UIOptionPane.showErrorDialog(this.focusPanel, DTClipboard.DELETE_FAILED(t.toString()));
            }
            return;
        }
        if (selDelete instanceof WebComponentDescriptor) {
            WebComponentDescriptor web = (WebComponentDescriptor)selDelete;
            WebBundleDescriptor wbd = web.getWebBundleDescriptor();
            try {
                DescriptorTools.removeWebServiceEndpoints((Descriptor)web);
                wbd.removeWebComponentDescriptor(web);
                SunOneUtils.removeSunServlet(wbd, web);
            }
            catch (Throwable t) {
                Print.printStackTrace((String)"Delete failed", (Throwable)t);
                UIOptionPane.showErrorDialog(this.focusPanel, DTClipboard.DELETE_FAILED(t.toString()));
            }
            return;
        }
        Print.dprintStackTrace((String)("Unknown delete target: " + UIUtils.debugClassName(selDelete)));
    }
}

