/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.stats;

import com.sun.enterprise.admin.monitor.stats.AverageRangeStatistic;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.ee.admin.monitor.stats.EEWebModuleStats;
import com.sun.enterprise.ee.web.sessmgmt.HAManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.HAStore;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.web.stats.WebModuleStatsImpl;
import javax.management.j2ee.statistics.CountStatistic;

public class EEWebModuleStatsImpl
extends WebModuleStatsImpl
implements EEWebModuleStats {
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.ee.admin.monitor.stats.EEWebModuleStats";
    private MutableCountStatistic sessionSizeLow;
    private MutableCountStatistic sessionSizeHigh;
    private MutableCountStatistic sessionSizeAvg;
    private MutableCountStatistic containerLatencyLow;
    private MutableCountStatistic containerLatencyHigh;
    private MutableCountStatistic containerLatencyAvg;
    private MutableCountStatistic sessionPersistTimeLow;
    private MutableCountStatistic sessionPersistTimeHigh;
    private MutableCountStatistic sessionPersistTimeAvg;
    private MutableCountStatistic cachedSessionsCurrent;
    private MutableCountStatistic passivatedSessionsCurrent;
    private WebModuleStatistics webModuleStatistics;

    public EEWebModuleStatsImpl() {
        super(STATS_INTERFACE_NAME);
        this.initializeEEStatistics();
    }

    private WebModuleStatistics getWebModuleStatistics() {
        if (this.webModuleStatistics == null) {
            if (this.sessionManager == null || !(this.sessionManager instanceof HAManagerBase)) {
                return null;
            }
            this.webModuleStatistics = ((HAManagerBase)this.sessionManager).getWebModuleStatistics();
        }
        return this.webModuleStatistics;
    }

    private HAManagerBase getSessionManager() {
        if (this.sessionManager == null || !(this.sessionManager instanceof HAManagerBase)) {
            return null;
        }
        return (HAManagerBase)this.sessionManager;
    }

    public AverageRangeStatistic getSessionSize() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            return stats.getSessionSizeStat();
        }
        return WebModuleStatistics.createDefaultStat("SessionSize", "byte", "Low/High/Average Session");
    }

    public CountStatistic getSessionSizeLow() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.sessionSizeLow.setCount(stats.getSessionSizeLow());
        } else {
            this.sessionSizeLow.setCount(-1L);
        }
        return (CountStatistic)this.sessionSizeLow.unmodifiableView();
    }

    public CountStatistic getSessionSizeHigh() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.sessionSizeHigh.setCount(stats.getSessionSizeHigh());
        } else {
            this.sessionSizeHigh.setCount(0L);
        }
        return (CountStatistic)this.sessionSizeHigh.unmodifiableView();
    }

    public CountStatistic getSessionSizeAvg() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.sessionSizeAvg.setCount(stats.getSessionSizeAverage());
        } else {
            this.sessionSizeAvg.setCount(-1L);
        }
        return (CountStatistic)this.sessionSizeAvg.unmodifiableView();
    }

    public AverageRangeStatistic getContainerLatency() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            return stats.getPipelineStat();
        }
        return WebModuleStatistics.createDefaultStat("ContainerLatency", "millisecond", "Low/High/Average Container Latency");
    }

    public CountStatistic getContainerLatencyLow() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.containerLatencyLow.setCount(stats.getPipelineLow());
        } else {
            this.containerLatencyLow.setCount(-1L);
        }
        return (CountStatistic)this.containerLatencyLow.unmodifiableView();
    }

    public CountStatistic getContainerLatencyHigh() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.containerLatencyHigh.setCount(stats.getPipelineHigh());
        } else {
            this.containerLatencyHigh.setCount(-1L);
        }
        return (CountStatistic)this.containerLatencyHigh.unmodifiableView();
    }

    public CountStatistic getContainerLatencyAvg() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.containerLatencyAvg.setCount(stats.getPipelineAverage());
        } else {
            this.containerLatencyAvg.setCount(-1L);
        }
        return (CountStatistic)this.containerLatencyAvg.unmodifiableView();
    }

    public AverageRangeStatistic getSessionPersistTime() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            return stats.getValveSaveStat();
        }
        return WebModuleStatistics.createDefaultStat("SessionPersistTime", "millisecond", "Low/High/Average Session Persist Time");
    }

    public CountStatistic getSessionPersistTimeLow() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.sessionPersistTimeLow.setCount(stats.getValveSaveLow());
        } else {
            this.sessionPersistTimeLow.setCount(-1L);
        }
        return (CountStatistic)this.sessionPersistTimeLow.unmodifiableView();
    }

    public CountStatistic getSessionPersistTimeHigh() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.sessionPersistTimeHigh.setCount(stats.getValveSaveHigh());
        } else {
            this.sessionPersistTimeHigh.setCount(-1L);
        }
        return (CountStatistic)this.sessionPersistTimeHigh.unmodifiableView();
    }

    public CountStatistic getSessionPersistTimeAvg() {
        WebModuleStatistics stats = null;
        stats = this.getWebModuleStatistics();
        if (stats != null) {
            this.sessionPersistTimeAvg.setCount(stats.getValveSaveAverage());
        } else {
            this.sessionPersistTimeAvg.setCount(-1L);
        }
        return (CountStatistic)this.sessionPersistTimeAvg.unmodifiableView();
    }

    public CountStatistic getActiveSessionsCurrent() {
        HAManagerBase sessMgr = this.getSessionManager();
        if (sessMgr == null) {
            return super.getActiveSessionsCurrent();
        }
        this.activeSessionsCurrent.setCount(this.getNumberActiveSessions());
        return (CountStatistic)this.activeSessionsCurrent.unmodifiableView();
    }

    public CountStatistic getCachedSessionsCurrent() {
        HAManagerBase sessMgr = this.getSessionManager();
        if (sessMgr == null) {
            this.cachedSessionsCurrent.setCount(-1L);
        } else {
            long cachedSessionsSize = sessMgr.getSessionsCacheSize();
            this.cachedSessionsCurrent.setCount(cachedSessionsSize);
        }
        return (CountStatistic)this.cachedSessionsCurrent.unmodifiableView();
    }

    public CountStatistic getPassivatedSessionsCurrent() {
        this.passivatedSessionsCurrent.setCount(this.getNumberPassivatedSessions());
        return (CountStatistic)this.passivatedSessionsCurrent.unmodifiableView();
    }

    private long getNumberCachedSessions() {
        HAManagerBase sessMgr = this.getSessionManager();
        if (sessMgr == null) {
            return -1L;
        }
        return sessMgr.getSessionsCacheSize();
    }

    private long getNumberStoredSessions() {
        HAManagerBase sessMgr = this.getSessionManager();
        if (sessMgr == null) {
            return -1L;
        }
        HAStore store = (HAStore)sessMgr.getStore();
        int numStoredSessions = -1;
        try {
            numStoredSessions = store.getSize();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return numStoredSessions;
    }

    private long getNumberActiveSessions() {
        long numCachedSessions;
        long activeSessions = 0L;
        long numStoredSessions = this.getNumberStoredSessions();
        activeSessions = numStoredSessions >= (numCachedSessions = this.getNumberCachedSessions()) ? numStoredSessions : numCachedSessions;
        return activeSessions;
    }

    private long getNumberPassivatedSessions() {
        long numCachedSessions;
        long passivatedSessions = 0L;
        long numStoredSessions = this.getNumberStoredSessions();
        if (numStoredSessions >= (numCachedSessions = this.getNumberCachedSessions())) {
            passivatedSessions = numStoredSessions - numCachedSessions;
        }
        return passivatedSessions;
    }

    private void initializeEEStatistics() {
        this.sessionSizeLow = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("SessionSizeLow"));
        this.sessionSizeHigh = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("SessionSizeHigh"));
        this.sessionSizeAvg = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("SessionSizeAvg"));
        this.containerLatencyLow = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ContainerLatencyLow"));
        this.containerLatencyHigh = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ContainerLatencyHigh"));
        this.containerLatencyAvg = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ContainerLatencyAvg"));
        this.sessionPersistTimeLow = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("SessionPersistTimeLow"));
        this.sessionPersistTimeHigh = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("SessionPersistTimeHigh"));
        this.sessionPersistTimeAvg = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("SessionPersistTimeAvg"));
        this.cachedSessionsCurrent = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("CachedSessionsCurrent"));
        this.passivatedSessionsCurrent = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("PassivatedSessionsCurrent"));
    }
}

