/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.ee.web.authenticator.HASingleSignOn;
import com.sun.enterprise.ee.web.sessmgmt.ConnectionUtil;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.IntHolder;
import com.sun.enterprise.ee.web.sessmgmt.OracleConnectionUtil;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public class OracleStore
extends StoreBase
implements HAStorePoolElement {
    private static int _maxBaseCacheSize = 4096;
    protected static float _loadFactor = 0.75f;
    protected String threadName = "HAStore";
    protected BaseCache sessions = new BaseCache();
    private static Logger _logger = null;
    protected static boolean _isMonitoringEnabled = false;
    protected String blobSessionTable = "blobsessions";
    protected String driverName = "oracle.jdbc.driver.OracleDriver";
    protected String timeoutSecs = new Long(300L).toString();
    protected Connection conn = null;
    protected ConnectionUtil connectionUtil = null;
    private PreparedStatement preparedKeysSql = null;
    private PreparedStatement preparedSizeSql = null;
    private PreparedStatement preparedLoadSql = null;
    private PreparedStatement preparedInsertSql = null;
    private PreparedStatement preparedRemoveSql = null;
    private PreparedStatement preparedClearSql = null;
    private PreparedStatement preparedUpdateSql = null;
    private PreparedStatement preparedExistsSql = null;
    private PreparedStatement preparedUpdateNoSessionSql = null;
    protected String clusterId = null;
    protected String applicationId = null;
    protected String shortApplicationId = null;

    public BaseCache getSessions() {
        return this.sessions;
    }

    public void setSessions(BaseCache sesstable) {
        this.sessions = sesstable;
    }

    protected static boolean isMonitoringEnabled() {
        return _isMonitoringEnabled;
    }

    protected static boolean checkMonitoringEnabled() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_WEB_CONTAINER");
            if (null != str && str.equalsIgnoreCase("TRUE")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected static boolean checkSessionCacheProperties() {
        boolean result = false;
        try {
            String loadFactor;
            Properties props = System.getProperties();
            String cacheSize = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_CACHE_SIZE");
            if (null != cacheSize) {
                _maxBaseCacheSize = new Integer(cacheSize);
            }
            if (null != (loadFactor = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_LOAD_FACTOR"))) {
                _loadFactor = new Float(loadFactor).floatValue();
            }
            System.out.println("_maxBaseCacheSize=" + _maxBaseCacheSize);
            System.out.println("_loadFactor=" + _loadFactor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected String getClusterIdFromConfig() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getClusterIdFromConfig();
    }

    protected String getClusterId() {
        if (this.clusterId == null) {
            this.clusterId = this.getClusterIdFromConfig();
        }
        return this.clusterId;
    }

    protected ConnectionUtil getConnectionUtil() {
        if (this.connectionUtil == null) {
            this.connectionUtil = new OracleConnectionUtil(this.getManager().getContainer(), this.getManager());
        }
        return this.connectionUtil;
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        ArrayList<String> list = new ArrayList<String>();
        for (Container container = this.manager.getContainer(); container != null; container = container.getParent()) {
            if (container.getName() == null) continue;
            list.add(":" + container.getName());
        }
        for (int i = list.size() - 1; i > -1; --i) {
            String nextString = (String)list.get(i);
            sb.append(nextString);
        }
        this.applicationId = sb.toString();
        return this.applicationId;
    }

    public String getApplicationIdPrevious() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        sb.append(":");
        for (Container container = this.manager.getContainer(); container != null; container = container.getParent()) {
            if (container.getName() == null) continue;
            sb.append(".").append(container.getName());
        }
        this.applicationId = sb.toString();
        return this.applicationId;
    }

    public String getShortApplicationId() {
        String result;
        if (this.shortApplicationId != null) {
            return this.shortApplicationId;
        }
        Container container = this.manager.getContainer();
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId()).append(":");
        if (container != null && container.getName() != null) {
            sb.append(container.getName());
        }
        container = container.getParent();
        this.shortApplicationId = result = sb.toString();
        return result;
    }

    public String extractShortApplicationIdFromApplicationId(String appid) {
        StringTokenizer st = new StringTokenizer(appid, ":");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            list.add(nextToken);
        }
        StringBuffer sb = new StringBuffer();
        if (list.size() > 2) {
            sb.append(list.get(0)).append(":").append(list.get(2));
        }
        String result = sb.toString();
        return result;
    }

    public void setTimeoutSecs(String timeoutSecs) {
        this.debug("in setTimeoutSecs");
        String oldTimeoutSecs = this.timeoutSecs;
        this.timeoutSecs = timeoutSecs;
        this.support.firePropertyChange("timeoutSecs", oldTimeoutSecs, this.timeoutSecs);
    }

    public String getTimeoutSecs() {
        this.debug("in getTimeoutSecs");
        return this.timeoutSecs;
    }

    protected void debug(String message) {
        this.log(message);
        System.out.println(message);
    }

    public OracleStore() {
        info = "S1AS OracleStore/1.0";
        this.threadName = "OracleStore";
        storeName = "OracleStore";
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.sessions = new BaseCache();
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
    }

    public int getSize() throws IOException {
        return this.getSize(this.blobSessionTable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSize(String sessionTable) throws IOException {
        int size = 0;
        String sizeSql = "SELECT COUNT(id) FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
        Connection conn = this.getConnection(false);
        ResultSet rst = null;
        try {
            try {
                if (this.preparedSizeSql == null) {
                    this.preparedSizeSql = conn.prepareStatement(sizeSql);
                }
                if ((rst = this.executeStatement(this.preparedSizeSql, true)).next()) {
                    size = rst.getInt(1);
                }
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                throw new IOException("Error from HA Store: " + e.getMessage());
            }
            Object var9_6 = null;
            this.closeResultSet(rst);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.closeResultSet(rst);
            try {
                if (this.preparedSizeSql == null) throw throwable;
                this.preparedSizeSql.close();
                this.preparedSizeSql = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (this.preparedSizeSql == null) return size;
        this.preparedSizeSql.close();
        this.preparedSizeSql = null;
        return size;
    }

    public String[] keys() throws IOException {
        return this.keys(this.blobSessionTable);
    }

    /*
     * Loose catch block
     */
    public String[] keys(String sessionTable) throws IOException {
        String[] keys;
        block18: {
            ResultSet rst;
            Connection conn;
            block16: {
                String keysSql = "SELECT id FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
                conn = this.getConnection(false);
                rst = null;
                keys = null;
                if (this.preparedKeysSql == null) {
                    this.preparedKeysSql = conn.prepareStatement(keysSql);
                }
                if ((rst = this.executeStatement(this.preparedKeysSql, true)) != null) break block16;
                this.debug("keys(): No rows returned, returning an empty array");
                String[] stringArray = new String[]{};
                Object var9_9 = null;
                this.closeResultSet(rst);
                try {
                    if (this.preparedSizeSql != null) {
                        this.preparedSizeSql.close();
                        this.preparedSizeSql = null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return stringArray;
            }
            ArrayList<String> keysArray = new ArrayList<String>();
            int i = 0;
            while (rst.next()) {
                this.debug("in keys, id is " + rst.getString(1));
                keysArray.add(rst.getString(1));
                ++i;
            }
            keys = keysArray.toArray(new String[0]);
            conn.commit();
            Object var9_10 = null;
            this.closeResultSet(rst);
            try {
                if (this.preparedSizeSql != null) {
                    this.preparedSizeSql.close();
                    this.preparedSizeSql = null;
                }
                break block18;
            }
            catch (Exception e) {}
            break block18;
            {
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.closeResultSet(rst);
                try {
                    if (this.preparedSizeSql != null) {
                        this.preparedSizeSql.close();
                        this.preparedSizeSql = null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return keys;
    }

    /*
     * Loose catch block
     */
    public synchronized Session load(String id) throws ClassNotFoundException, IOException {
        String shortAppId;
        Session session;
        block34: {
            StandardSession stdSess222;
            Connection externalConn;
            Connection conn;
            ResultSet rst;
            block31: {
                block27: {
                    StandardSession stdSess222;
                    Session session2;
                    block28: {
                        _logger.finest("IN NEW LOAD METHOD");
                        if (id == null) {
                            this.debug("in load, id is null, returning null");
                            Thread.dumpStack();
                            return null;
                        }
                        session = (Session)this.sessions.get((Object)id);
                        if (session != null) {
                            this.debug("Session " + id + " loaded from cache");
                            return session;
                        }
                        rst = null;
                        HADBConnectionGroup connGroup = this.getConnectionsFromPool();
                        conn = connGroup._internalConn;
                        externalConn = connGroup._externalConn;
                        shortAppId = null;
                        String loadSql = "SELECT id, sessdata, username , ssoid, appid FROM " + this.blobSessionTable + " WHERE id = ?";
                        this.preparedLoadSql = conn.prepareStatement(loadSql);
                        this.preparedLoadSql.setString(1, id);
                        rst = this.executeStatement(this.preparedLoadSql, true);
                        if (rst != null && rst.next()) break block27;
                        this.debug("No persisted data found for session " + id);
                        session2 = null;
                        Object var12_12 = null;
                        this.closeResultSet(rst);
                        if (this.preparedLoadSql == null) break block28;
                        try {
                            this.preparedLoadSql.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        this.preparedLoadSql = null;
                    }
                    if (externalConn != null) {
                        try {
                            externalConn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if ((stdSess222 = (StandardSession)session) != null && stdSess222.isForegroundLocked()) {
                        _logger.finest("inOracleStore>>load before unlockForeground:lock = " + stdSess222.getSessionLock());
                        stdSess222.unlockForeground();
                        _logger.finest("inOracleStore>>load after unlockForeground:lock = " + stdSess222.getSessionLock());
                    }
                    return session2;
                }
                session = this.getSession(rst);
                String appId = rst.getString(5);
                shortAppId = this.extractShortApplicationIdFromApplicationId(appId);
                conn.commit();
                this.preparedLoadSql.close();
                this.preparedLoadSql = null;
                try {
                    externalConn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                externalConn = null;
                Object var12_13 = null;
                this.closeResultSet(rst);
                if (this.preparedLoadSql == null) break block31;
                try {
                    this.preparedLoadSql.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.preparedLoadSql = null;
            }
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if ((stdSess222 = (StandardSession)session) != null && stdSess222.isForegroundLocked()) {
                _logger.finest("inOracleStore>>load before unlockForeground:lock = " + stdSess222.getSessionLock());
                stdSess222.unlockForeground();
                _logger.finest("inOracleStore>>load after unlockForeground:lock = " + stdSess222.getSessionLock());
            }
            break block34;
            {
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    _logger.log(Level.WARNING, "OracleStore.LOAD(): ", e);
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                this.closeResultSet(rst);
                if (this.preparedLoadSql != null) {
                    try {
                        this.preparedLoadSql.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.preparedLoadSql = null;
                }
                if (externalConn != null) {
                    try {
                        externalConn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if ((stdSess222 = (StandardSession)session) != null && stdSess222.isForegroundLocked()) {
                    _logger.finest("inOracleStore>>load before unlockForeground:lock = " + stdSess222.getSessionLock());
                    stdSess222.unlockForeground();
                    _logger.finest("inOracleStore>>load after unlockForeground:lock = " + stdSess222.getSessionLock());
                }
                throw throwable;
            }
        }
        if (!shortAppId.equals(this.getShortApplicationId())) {
            return null;
        }
        this.sessions.put((Object)session.getId(), (Object)session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Session getSession(ResultSet rst) throws SQLException, IOException, ClassNotFoundException {
        String ssoId;
        Principal pal;
        Session _session;
        block14: {
            _session = null;
            BufferedInputStream bis = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            Object var6_6 = null;
            Container container = this.manager.getContainer();
            pal = null;
            ssoId = null;
            try {
                void var6_9;
                String id = rst.getString(1);
                _logger.finest("loaded session from OracleStore, id = " + id);
                Blob blob = rst.getBlob(2);
                String username = rst.getString(3);
                _logger.finest("loaded session from OracleStore, username = " + username);
                ssoId = rst.getString(4);
                _logger.finest("loaded session from OracleStore, ssoid = " + ssoId);
                if (username != null && !username.equals("")) {
                    this.debug("Username retrived from DB is " + username);
                    pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
                    this.debug("principal created using username  " + pal);
                }
                _logger.finest("loaded seasion from OracleStore, length = " + blob.length());
                bis = new BufferedInputStream(blob.getBinaryStream());
                _logger.finest("loaded session from blob" + bis.toString());
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    CustomObjectInputStream customObjectInputStream = new CustomObjectInputStream((InputStream)bis, classLoader);
                } else {
                    ObjectInputStream objectInputStream = new ObjectInputStream(bis);
                }
                if (var6_9 == null) break block14;
                try {
                    _session = this.readSession(this.manager, (ObjectInputStream)var6_9);
                    Object var14_18 = null;
                    if (var6_9 == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    if (var6_9 == null) throw throwable;
                    try {
                        var6_9.close();
                        bis = null;
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                var6_9.close();
                bis = null;
            }
            catch (ClassNotFoundException e) {
                System.err.println("getSession :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        _session.setPrincipal(pal);
        if (ssoId != null && !ssoId.equals("")) {
            this.associate(ssoId, _session);
        }
        this.debug("getSession principal=" + pal + " was added to session=" + _session);
        return _session;
    }

    protected void associate(String ssoId, Session _session) {
        this.debug("Inside associate() -- OracleStore");
        Container parent = this.manager.getContainer();
        SingleSignOn sso = null;
        while (sso == null && parent != null) {
            this.debug("Inside associate()  while loop -- OracleStore");
            if (!(parent instanceof Pipeline)) {
                this.debug("Inside associate()  parent instanceof Pipeline -- OracleStore");
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)parent).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.debug("Inside associate()  valves[i] instanceof SingleSignOn -- OracleStore");
                sso = (SingleSignOn)valves[i];
                break;
            }
            if (sso != null) continue;
            parent = parent.getParent();
        }
        if (sso != null) {
            this.debug("Inside associate() sso != null");
            SingleSignOnEntry ssoEntry = ((HASingleSignOn)sso).lookupEntry(ssoId);
            _logger.finest("Inside associate() ssoEntry = " + ssoEntry);
            if (ssoEntry != null) {
                ssoEntry.addSession(sso, _session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void remove(String id) throws IOException {
        block15: {
            this.debug("in remove");
            if (id == null) {
                this.debug("In remove, got a null id");
                return;
            }
            this.sessions.remove((Object)id);
            conn = this.getConnection(false);
            removeSql = "DELETE FROM " + this.blobSessionTable + " WHERE id = ? ";
            try {
                if (this.preparedRemoveSql == null) {
                    this.preparedRemoveSql = conn.prepareStatement(removeSql);
                }
                this.preparedRemoveSql.setString(1, id);
                this.executeStatement(this.preparedRemoveSql, false);
                conn.commit();
                var7_4 = null;
                ** if (this.preparedRemoveSql == null) goto lbl-1000
            }
            catch (Throwable var6_12) {
                var7_6 = null;
                if (this.preparedRemoveSql != null) {
                    try {
                        this.preparedRemoveSql.close();
                        this.preparedRemoveSql = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var6_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.preparedRemoveSql.close();
                    this.preparedRemoveSql = null;
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (SQLException e) {
                    OracleStore._logger.log(Level.WARNING, "Exception OracleStore.remove()", e);
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        OracleStore._logger.log(Level.WARNING, "Exception OracleStore.remove()", ee);
                    }
                    var7_5 = null;
                    if (this.preparedRemoveSql != null) {
                        try {
                            this.preparedRemoveSql.close();
                            this.preparedRemoveSql = null;
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        OracleStore._logger.log(Level.WARNING, "Removed session " + id + " from HA Store");
    }

    public void clear() throws IOException {
        this.debug("in clear");
        this.sessions = new BaseCache();
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearPrevious() throws IOException {
        this.debug("in clear");
        this.sessions = new BaseCache();
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
        Connection conn = this.getConnection(false);
        String clearSql = "DELETE FROM " + this.blobSessionTable + " WHERE id NOT NULL AND appid = ?";
        try {
            try {
                if (this.preparedClearSql == null) {
                    this.preparedClearSql = conn.prepareStatement(clearSql);
                }
                this.preparedClearSql.setString(1, this.getApplicationId());
                this.executeStatement(this.preparedClearSql, false);
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                    throw new IOException("Error in HA Store: " + e.getMessage());
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                throw new IOException("Error in HA Store: " + e.getMessage());
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            try {
                if (this.preparedClearSql == null) throw throwable;
                this.preparedClearSql.close();
                this.preparedClearSql = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (this.preparedClearSql == null) return;
        this.preparedClearSql.close();
        this.preparedClearSql = null;
        return;
    }

    public void save(Session session) throws IOException {
        _logger.finest("XXXXXXX In save, id is " + session.getId());
        boolean isMonitoringEnabled = OracleStore.isMonitoringEnabled();
        long startTime = 0L;
        long endTime = 0L;
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        WebModuleStatistics stats = mgr.getWebModuleStatistics();
        if (isMonitoringEnabled) {
            startTime = System.currentTimeMillis();
        }
        HASession sess = (HASession)session;
        boolean previousDirtyFlag = sess.isDirty();
        this.debug("in save");
        Connection conn = this.getConnection(false);
        IntHolder length = new IntHolder();
        BufferedInputStream in = this.getInputStream(session, length);
        try {
            if (this.sessionInStore(session)) {
                _logger.finest("Session is in store");
                if (sess.isDirty()) {
                    _logger.finest("Session IS Dirty");
                    this.updateSessionBlob(session, in, length.value);
                } else {
                    _logger.finest("Session is NOT Dirty");
                    this.updateSessionNoDataBlob(session, in, length.value);
                }
            } else {
                this.insertSessionBlob(session, in, length.value);
            }
            sess.setDirty(false);
            if (isMonitoringEnabled) {
                endTime = System.currentTimeMillis();
                stats.processBackgroundSave(endTime - startTime);
            }
            _logger.finest("session class= " + sess.getClass().getName());
            _logger.finest("after save: session dirty= " + sess.isDirty());
        }
        catch (IOException e) {
            sess.setDirty(previousDirtyFlag);
            e.printStackTrace();
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.debug("Saved session " + session.getId() + " into HA Store");
    }

    /*
     * Loose catch block
     */
    public void valveSave(Session session) throws IOException {
        block17: {
            BufferedInputStream in;
            Connection conn;
            boolean previousDirtyFlag;
            HASession sess;
            block16: {
                _logger.finest("XXXXXXX In valveSave, id is " + session.getId());
                sess = (HASession)session;
                previousDirtyFlag = sess.isDirty();
                this.debug("in valveSave");
                HADBConnectionGroup connGroup = this.getConnectionsFromPool();
                Connection internalConn = connGroup._internalConn;
                conn = connGroup._externalConn;
                IntHolder length = new IntHolder();
                in = this.getInputStream(session, length);
                if (this.sessionInStore(session, internalConn)) {
                    if (sess.isDirty()) {
                        this.updateSessionNewBlob(session, in, length.value, internalConn);
                    } else {
                        this.updateSessionNoDataNewBlob(session, in, length.value, internalConn);
                    }
                } else {
                    this.insertSessionNewBlob(session, in, length.value, internalConn);
                }
                sess.setDirty(false);
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                conn = null;
                Object var11_11 = null;
                if (conn == null) break block16;
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (in != null) {
                in.close();
            }
            break block17;
            {
                catch (IOException e) {
                    sess.setDirty(previousDirtyFlag);
                    e.printStackTrace();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void insertSessionNewBlob(Session session, BufferedInputStream in, int buflength, Connection connection) throws IOException {
        block20: {
            _logger.finest("IN insertSessionNewBlob");
            String insertSql = "INSERT INTO " + this.blobSessionTable + " (" + "id, sessdata, valid, maxinactive, lastaccess, appid, username, ssoid) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?) ";
            String selectSql = "SELECT sessdata from blobsessions where id = '" + session.getId() + "'" + "for update nowait";
            Statement stmt = null;
            _logger.log(Level.FINEST, "IN INSERT SESSIONNEWBLOB");
            this.preparedInsertSql = connection.prepareStatement(insertSql);
            this.preparedInsertSql.setString(1, session.getId());
            BLOB b = BLOB.empty_lob();
            this.preparedInsertSql.setBlob(2, (Blob)b);
            this.preparedInsertSql.setString(3, session.isValid() ? "1" : "0");
            this.preparedInsertSql.setInt(4, session.getMaxInactiveInterval());
            this.preparedInsertSql.setLong(5, session.getLastAccessedTime());
            this.preparedInsertSql.setString(6, this.getApplicationId());
            if (session.getPrincipal() != null) {
                this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                this.preparedInsertSql.setString(7, session.getPrincipal().getName());
            } else {
                this.preparedInsertSql.setString(7, "");
                this.debug(" session.getPrincipal() =" + session.getPrincipal());
            }
            String ssoId = ((HASession)session).getSsoId();
            if (ssoId == null) {
                ssoId = "";
            }
            this.preparedInsertSql.setString(8, ssoId);
            this.executeStatement(this.preparedInsertSql, false);
            _logger.finest("inserted session, length = " + buflength);
            this.preparedInsertSql.close();
            this.preparedInsertSql = null;
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(selectSql);
            rs.next();
            _logger.log(Level.FINEST, "VJ: Resultset: " + rs.toString());
            BLOB blob = ((OracleResultSet)rs).getBLOB(1);
            OutputStream os = blob.getBinaryOutputStream();
            int size = blob.getBufferSize();
            byte[] buffer = new byte[size];
            int length = -1;
            while ((length = in.read(buffer)) != -1) {
                _logger.log(Level.FINEST, "PRINTING THE BUFFER: " + buffer.toString());
                os.write(buffer, 0, length);
            }
            os.close();
            in.close();
            stmt.close();
            connection.commit();
            Object var17_18 = null;
            try {
                if (this.preparedInsertSql != null) {
                    this.preparedInsertSql.close();
                    this.preparedInsertSql = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                break block20;
            }
            catch (Exception ex) {}
            break block20;
            {
                catch (SQLException e) {
                    _logger.log(Level.WARNING, "VJ: Exception in insertSessionNewBLob", e);
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ee) {
                        _logger.log(Level.WARNING, "VJ: Exception in insertSessionBLob", ee);
                    }
                    Object var17_19 = null;
                    try {
                        if (this.preparedInsertSql != null) {
                            this.preparedInsertSql.close();
                            this.preparedInsertSql = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        break block20;
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    if (this.preparedInsertSql != null) {
                        this.preparedInsertSql.close();
                        this.preparedInsertSql = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSessionNewBlob(Session session, BufferedInputStream in, int buflength, Connection connection) throws IOException {
        _logger.finest("IN UPDATE SESSION NEW BLOB");
        String updateSql = "UPDATE " + this.blobSessionTable + " SET  valid = ?, maxinactive = ?, lastaccess = ? , appid = ? , username = ?, ssoid=? " + "WHERE id = ?";
        String selectSql = "SELECT sessdata from blobsessions where id = '" + session.getId() + "'" + "for update nowait";
        try {
            try {
                this.preparedUpdateSql = connection.prepareStatement(updateSql);
                this.preparedUpdateSql.setString(1, session.isValid() ? "1" : "0");
                this.preparedUpdateSql.setInt(2, session.getMaxInactiveInterval());
                this.preparedUpdateSql.setLong(3, session.getLastAccessedTime());
                this.preparedUpdateSql.setString(4, this.getApplicationId());
                if (session.getPrincipal() != null) {
                    this.preparedUpdateSql.setString(5, session.getPrincipal().getName());
                } else {
                    this.preparedUpdateSql.setString(5, "");
                }
                String ssoId = ((HASession)session).getSsoId();
                if (ssoId == null) {
                    ssoId = "";
                }
                this.preparedUpdateSql.setString(6, ssoId);
                this.preparedUpdateSql.setString(7, session.getId());
                this.executeStatement(this.preparedUpdateSql, false);
                this.preparedUpdateSql = connection.prepareStatement(selectSql);
                ResultSet rs = this.preparedUpdateSql.executeQuery();
                rs.next();
                BLOB blob = ((OracleResultSet)rs).getBLOB(1);
                OutputStream os = blob.getBinaryOutputStream();
                rs.close();
                rs = null;
                int size = blob.getBufferSize();
                byte[] buffer = new byte[size];
                int length = -1;
                while ((length = in.read(buffer)) != -1) {
                    _logger.log(Level.FINEST, "PRINTING THE BUFFER: " + buffer.toString());
                    os.write(buffer, 0, length);
                }
                os.close();
                os = null;
                in.close();
                in = null;
                connection.commit();
                this.preparedUpdateSql.close();
                this.preparedUpdateSql = null;
            }
            catch (SQLException e) {
                _logger.log(Level.WARNING, "Exception in updateSessionNewBlob", e);
                try {
                    connection.rollback();
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
                catch (SQLException ee) {
                    _logger.log(Level.WARNING, "Exception in updateSessionNewBlob", e);
                }
                throw new IOException("Error from HA Store: " + e.getMessage());
            }
            Object var15_16 = null;
            if (this.preparedUpdateSql == null) return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (this.preparedUpdateSql == null) throw throwable;
            try {
                this.preparedUpdateSql.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.preparedUpdateSql.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSessionNoDataNewBlob(Session session, BufferedInputStream in, int buflength, Connection connection) throws IOException {
        String updateSql = "UPDATE " + this.blobSessionTable + " SET valid = ?, maxinactive = ?, lastaccess = ? , appid = ? ,username =?, ssoid=?" + " WHERE id = ?";
        try {
            try {
                this.preparedUpdateNoSessionSql = connection.prepareStatement(updateSql);
                this.preparedUpdateNoSessionSql.setString(1, session.isValid() ? "1" : "0");
                this.preparedUpdateNoSessionSql.setInt(2, session.getMaxInactiveInterval());
                this.preparedUpdateNoSessionSql.setLong(3, session.getLastAccessedTime());
                this.preparedUpdateNoSessionSql.setString(4, this.getApplicationId());
                if (session.getPrincipal() != null) {
                    this.preparedUpdateNoSessionSql.setString(5, session.getPrincipal().getName());
                } else {
                    this.preparedUpdateNoSessionSql.setString(5, "");
                }
                String ssoId = ((HASession)session).getSsoId();
                if (ssoId == null) {
                    ssoId = "";
                }
                this.preparedUpdateNoSessionSql.setString(6, ssoId);
                this.preparedUpdateNoSessionSql.setString(7, session.getId());
                this.executeStatement(this.preparedUpdateNoSessionSql, false);
                in.close();
                connection.commit();
                this.preparedUpdateNoSessionSql.close();
                this.preparedUpdateNoSessionSql = null;
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw new IOException("Error from HA Store: " + e.getMessage());
            }
            Object var9_8 = null;
            if (this.preparedUpdateNoSessionSql == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (this.preparedUpdateNoSessionSql == null) throw throwable;
            try {
                this.preparedUpdateNoSessionSql.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.preparedUpdateNoSessionSql.close();
        return;
    }

    public boolean sessionInStore(Session session) throws IOException {
        return this.sessionInStore(session, this.blobSessionTable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sessionInStore(Session session, String storeTable) throws IOException {
        Session sess = (Session)this.sessions.get((Object)session.getId());
        if (sess != null) {
            return true;
        }
        Connection conn = this.getConnection(false);
        String existsSql = "SELECT id FROM " + storeTable + " WHERE id = ?";
        ResultSet rs = null;
        boolean found = false;
        try {
            try {
                if (this.preparedExistsSql == null) {
                    this.preparedExistsSql = conn.prepareStatement(existsSql);
                }
                this.preparedExistsSql.setString(1, session.getId());
                rs = this.executeStatement(this.preparedExistsSql, true);
                found = rs != null && rs.next();
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                    throw new IOException("Error in HA Store: " + e.getMessage());
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                throw new IOException("Error in HA Store: " + e.getMessage());
            }
            Object var11_8 = null;
            this.closeResultSet(rs);
            if (this.preparedExistsSql == null) return found;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.closeResultSet(rs);
            if (this.preparedExistsSql == null) throw throwable;
            try {
                this.preparedExistsSql.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.preparedExistsSql.close();
        return found;
    }

    public boolean sessionInStore(Session session, Connection conn) throws IOException {
        return this.sessionInStore(session, conn, this.blobSessionTable);
    }

    /*
     * Loose catch block
     */
    public boolean sessionInStore(Session session, Connection conn, String storeTable) throws IOException {
        boolean found;
        block11: {
            HAManagerBase mgr = (HAManagerBase)this.getManager();
            OracleStore backgroundStore = (OracleStore)mgr.getStore();
            BaseCache sesstbl = backgroundStore.getSessions();
            Session sess = (Session)sesstbl.get((Object)session.getId());
            if (sess != null) {
                return true;
            }
            String existsSql = "SELECT id FROM " + storeTable + " WHERE id = ?";
            ResultSet rs = null;
            found = false;
            this.preparedExistsSql = conn.prepareStatement(existsSql);
            this.preparedExistsSql.setString(1, session.getId());
            rs = this.executeStatement(this.preparedExistsSql, true);
            found = rs != null && rs.next();
            conn.commit();
            this.preparedExistsSql.close();
            this.preparedExistsSql = null;
            Object var14_11 = null;
            this.closeResultSet(rs);
            if (this.preparedExistsSql == null) break block11;
            try {
                this.preparedExistsSql.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.preparedExistsSql = null;
            {
                break block11;
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    throw new IOException("Error in HA Store: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                this.closeResultSet(rs);
                if (this.preparedExistsSql != null) {
                    try {
                        this.preparedExistsSql.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.preparedExistsSql = null;
                }
                throw throwable;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void insertSessionBlob(Session session, BufferedInputStream in, int buflength) throws IOException {
        block26: {
            Exception e222;
            Statement stmt;
            block24: {
                String insertSql = "INSERT INTO " + this.blobSessionTable + " (" + "id, sessdata, valid, maxinactive, lastaccess, appid, username, ssoid) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?) ";
                String selectSql = "SELECT sessdata from blobsessions where id = '" + session.getId() + "'" + "for update nowait";
                stmt = null;
                if (this.preparedInsertSql == null) {
                    this.preparedInsertSql = this.conn.prepareStatement(insertSql);
                }
                this.preparedInsertSql.setString(1, session.getId());
                BLOB b = BLOB.empty_lob();
                this.preparedInsertSql.setBlob(2, (Blob)b);
                this.preparedInsertSql.setString(3, session.isValid() ? "1" : "0");
                this.preparedInsertSql.setInt(4, session.getMaxInactiveInterval());
                this.preparedInsertSql.setLong(5, session.getLastAccessedTime());
                this.preparedInsertSql.setString(6, this.getApplicationId());
                if (session.getPrincipal() != null) {
                    this.preparedInsertSql.setString(7, session.getPrincipal().getName());
                } else {
                    this.preparedInsertSql.setString(7, "");
                }
                String ssoId = ((HASession)session).getSsoId();
                if (ssoId == null) {
                    ssoId = "";
                }
                this.preparedInsertSql.setString(8, ssoId);
                this.executeStatement(this.preparedInsertSql, false);
                stmt = this.conn.createStatement();
                ResultSet rs = stmt.executeQuery(selectSql);
                rs.next();
                _logger.log(Level.FINEST, "VJ: Resultset: " + rs.toString());
                BLOB blob = ((OracleResultSet)rs).getBLOB(1);
                OutputStream os = blob.getBinaryOutputStream();
                int size = blob.getBufferSize();
                byte[] buffer = new byte[size];
                int length = -1;
                while ((length = in.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                os.close();
                in.close();
                stmt.close();
                this.conn.commit();
                stmt = null;
                _logger.finest("inserted session, length = " + buflength);
                Object var16_17 = null;
                if (this.preparedInsertSql == null) break block24;
                try {
                    this.preparedInsertSql.close();
                    this.preparedInsertSql = null;
                }
                catch (Exception e222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (Exception e222) {}
            }
            break block26;
            {
                catch (SQLException e3) {
                    Exception e222;
                    _logger.log(Level.WARNING, "VJ: Exception in insertSessionBLob", e3);
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException ee) {
                        _logger.log(Level.WARNING, "VJ: Exception in insertSessionBLob", ee);
                    }
                    Object var16_18 = null;
                    if (this.preparedInsertSql != null) {
                        try {
                            this.preparedInsertSql.close();
                            this.preparedInsertSql = null;
                        }
                        catch (Exception e222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                            stmt = null;
                        }
                        catch (Exception e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e222;
                Object var16_19 = null;
                if (this.preparedInsertSql != null) {
                    try {
                        this.preparedInsertSql.close();
                        this.preparedInsertSql = null;
                    }
                    catch (Exception e222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (Exception e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void updateSessionBlob(Session session, BufferedInputStream in, int buflength) throws IOException {
        block14: {
            String updateSql = "UPDATE " + this.blobSessionTable + " SET sessdata = ?, valid = ?, maxinactive = ?, lastaccess = ? , appid = ? , username=?, ssoid=?" + "WHERE id = ? for update nowait";
            _logger.log(Level.FINEST, "IN OracleStore.UPDATESESSIONBLOB");
            if (this.preparedUpdateSql == null) {
                this.preparedUpdateSql = this.conn.prepareStatement(updateSql);
            }
            this.preparedUpdateSql.setBinaryStream(1, (InputStream)in, buflength);
            this.preparedUpdateSql.setString(2, session.isValid() ? "1" : "0");
            this.preparedUpdateSql.setInt(3, session.getMaxInactiveInterval());
            this.preparedUpdateSql.setLong(4, session.getLastAccessedTime());
            this.preparedUpdateSql.setString(5, this.getApplicationId());
            if (session.getPrincipal() != null) {
                this.preparedUpdateSql.setString(6, session.getPrincipal().getName());
            } else {
                this.preparedUpdateSql.setString(6, "");
            }
            String ssoId = ((HASession)session).getSsoId();
            if (ssoId == null) {
                ssoId = "";
            }
            this.preparedUpdateSql.setString(7, ssoId);
            this.preparedUpdateSql.setString(8, session.getId());
            this.executeStatement(this.preparedUpdateSql, false);
            this.conn.commit();
            in.close();
            this.preparedUpdateSql.close();
            this.preparedUpdateSql = null;
            _logger.finest("updated session, length = " + buflength);
            Object var8_7 = null;
            if (this.preparedUpdateSql == null) break block14;
            try {
                this.preparedUpdateSql.close();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            this.preparedUpdateSql = null;
            {
                break block14;
                catch (SQLException e) {
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (this.preparedUpdateSql != null) {
                    try {
                        this.preparedUpdateSql.close();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    this.preparedUpdateSql = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSessionNoDataBlob(Session session, BufferedInputStream in, int buflength) throws IOException {
        _logger.finest("IN UPDATE SESSIONNODATABLOB");
        String updateSql = "UPDATE " + this.blobSessionTable + " SET valid = ?, maxinactive = ?, lastaccess = ? , appid = ? ,username= ?, ssoid=?" + "WHERE id = ?";
        try {
            try {
                if (this.preparedUpdateNoSessionSql == null) {
                    this.preparedUpdateNoSessionSql = this.conn.prepareStatement(updateSql);
                }
                this.preparedUpdateNoSessionSql.setString(1, session.isValid() ? "1" : "0");
                this.preparedUpdateNoSessionSql.setInt(2, session.getMaxInactiveInterval());
                this.preparedUpdateNoSessionSql.setLong(3, session.getLastAccessedTime());
                this.preparedUpdateNoSessionSql.setString(4, this.getApplicationId());
                if (session.getPrincipal() != null) {
                    this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                    this.preparedUpdateNoSessionSql.setString(5, session.getPrincipal().getName());
                } else {
                    this.preparedUpdateNoSessionSql.setString(5, "");
                }
                String ssoId = ((HASession)session).getSsoId();
                if (ssoId == null) {
                    ssoId = "";
                }
                this.preparedUpdateNoSessionSql.setString(6, ssoId);
                this.preparedUpdateNoSessionSql.setString(7, session.getId());
                this.executeStatement(this.preparedUpdateNoSessionSql, false);
                in.close();
                this.conn.commit();
            }
            catch (SQLException e) {
                try {
                    this.conn.rollback();
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                throw new IOException("Error from HA Store: " + e.getMessage());
            }
            Object var8_7 = null;
            if (this.preparedUpdateSql == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (this.preparedUpdateSql == null) throw throwable;
            try {
                this.preparedUpdateSql.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        this.preparedUpdateSql.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedInputStream getInputStream(Session session, IntHolder length) throws IOException {
        BufferedInputStream in;
        ByteArrayInputStream bis;
        block5: {
            ByteArrayOutputStream bos = null;
            bis = null;
            ObjectOutputStream oos = null;
            in = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
                this.writeSession(session, oos);
                oos.close();
                oos = null;
                byte[] obs = bos.toByteArray();
                _logger.finest("IN OracleStore>>getInputStream for monitoring");
                HAManagerBase mgr = (HAManagerBase)this.getManager();
                WebModuleStatistics stats = mgr.getWebModuleStatistics();
                stats.processSessionSize(obs.length);
                bis = new ByteArrayInputStream(obs, 0, obs.length);
                in = new BufferedInputStream(bis, obs.length);
                length.value = obs.length;
                Object var11_10 = null;
                if (oos == null) break block5;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (oos != null) {
                    oos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                throw throwable;
            }
            oos.close();
        }
        if (bis != null) {
            bis.close();
        }
        return in;
    }

    protected ResultSet executeStatement(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            if (isQuery) {
                rst = stmt.executeQuery();
            } else {
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.debug("Got a retryable exception from HA Store: " + e.getMessage());
        }
        return rst;
    }

    protected void closeResultSet(ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.closeStatements();
        this.closeConnection();
        this.setSessions(new BaseCache());
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
    }

    protected void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeStatements() {
        PreparedStatement[] statements = new PreparedStatement[]{this.preparedKeysSql, this.preparedSizeSql, this.preparedLoadSql, this.preparedInsertSql, this.preparedRemoveSql, this.preparedClearSql, this.preparedClearSql, this.preparedUpdateSql, this.preparedExistsSql};
        for (int i = 0; i < statements.length; ++i) {
            PreparedStatement nextStatement = statements[i];
            this.closeStatement(nextStatement);
        }
        this.preparedKeysSql = null;
        this.preparedSizeSql = null;
        this.preparedLoadSql = null;
        this.preparedInsertSql = null;
        this.preparedRemoveSql = null;
        this.preparedClearSql = null;
        this.preparedClearSql = null;
        this.preparedUpdateSql = null;
        this.preparedExistsSql = null;
    }

    protected void closeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void privateForTestSetConnection(Connection connection) {
        this.conn = connection;
    }

    public Connection privateGetConnection(boolean autocommit) throws IOException {
        return this.getConnection(autocommit);
    }

    protected HADBConnectionGroup getConnectionsFromPool() throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        return util.getConnectionsFromPool();
    }

    protected Connection getConnectionValidated(boolean autoCommit) throws IOException {
        Connection connection = null;
        boolean keepTrying = true;
        int numRetries = 3;
        int count = 1;
        while (keepTrying) {
            connection = this.getConnection(autoCommit);
            boolean connectionValid = this.validateConnection(connection);
            if (connectionValid) {
                keepTrying = false;
            } else {
                try {
                    this.cleanupConnectionCaches();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.conn = null;
            }
            if (++count != numRetries) continue;
            keepTrying = false;
        }
        if (this.conn == null) {
            throw new IOException("Could not obtain viable connection");
        }
        try {
            this.conn.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        return this.conn;
    }

    protected void cleanupConnectionCaches() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.preparedKeysSql = null;
        this.preparedSizeSql = null;
        this.preparedLoadSql = null;
        this.preparedInsertSql = null;
        this.preparedRemoveSql = null;
        this.preparedClearSql = null;
        this.preparedUpdateSql = null;
        this.preparedExistsSql = null;
        this.preparedUpdateNoSessionSql = null;
        this.conn = null;
    }

    protected boolean validateConnection(Connection connection) {
        boolean result = true;
        try {
            this.getSizeForConnValidation(connection);
        }
        catch (IOException ex) {
            result = false;
        }
        catch (NullPointerException ex1) {
            result = false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSizeForConnValidation(Connection connection) throws IOException {
        this.debug("in getSizeForConnValidation");
        int size = 0;
        String sizeSql = "SELECT COUNT(id) FROM " + this.blobSessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
        ResultSet rst = null;
        try {
            try {
                if (this.preparedSizeSql == null) {
                    this.preparedSizeSql = connection.prepareStatement(sizeSql);
                }
                if ((rst = this.executeStatement(this.preparedSizeSql, true)).next()) {
                    size = rst.getInt(1);
                }
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                    throw new IOException("Error from HA Store: " + e.getMessage());
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                throw new IOException("Error from HA Store: " + e.getMessage());
            }
            Object var8_5 = null;
            this.closeResultSet(rst);
            if (this.preparedSizeSql == null) return size;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.closeResultSet(rst);
            if (this.preparedSizeSql == null) throw throwable;
            try {
                this.preparedSizeSql.close();
                this.preparedSizeSql = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        this.preparedSizeSql.close();
        this.preparedSizeSql = null;
        return size;
    }

    protected Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    protected Connection getConnection(boolean autoCommit) throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        this.conn = util.getConnection(autoCommit);
        return this.conn;
    }

    static {
        _isMonitoringEnabled = OracleStore.checkMonitoringEnabled();
        OracleStore.checkSessionCacheProperties();
    }
}

