/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.initialization;

import com.sun.enterprise.ee.web.authenticator.HASingleSignOn;
import com.sun.enterprise.ee.web.authenticator.SSOStoreFactoryImpl;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EESSOFactory
implements SSOFactory {
    private static Logger _logger = null;

    public EESSOFactory() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public SingleSignOn createSingleSignOnValve() {
        if (EESSOFactory.getAvailabilityEnabled() && EESSOFactory.getSsoFailoverEnabled()) {
            return this.createHASingleSignOnValve();
        }
        return new SingleSignOn();
    }

    private static boolean getAvailabilityEnabled() {
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        boolean isAvailabilityEnabled = serverConfigLookup.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("EESSOFactory : AvailabilityGloballyEnabled = " + isAvailabilityEnabled);
        }
        return isAvailabilityEnabled;
    }

    private static boolean getSsoFailoverEnabled() {
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        boolean webContainerAvailabilityEnabled = serverConfigLookup.getWebContainerAvailabilityEnabledFromConfig();
        boolean isSsoFailoverEnabled = serverConfigLookup.getSsoFailoverEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("EESSOFactory : WebContainerAvailabilityEnabled = " + webContainerAvailabilityEnabled);
            _logger.finest("EESSOFactory : SSOFailoverEnabled = " + isSsoFailoverEnabled);
        }
        return isSsoFailoverEnabled && webContainerAvailabilityEnabled;
    }

    public SingleSignOn createHASingleSignOnValve() {
        HASingleSignOn haSSO = new HASingleSignOn();
        this.initializeSSOvalve(haSSO);
        return haSSO;
    }

    public void initializeSSOvalve(HASingleSignOn haSSO) {
        SSOStoreFactoryImpl ssoStoreFactory = new SSOStoreFactoryImpl();
        StorePool storePool = new StorePool(100, -1, 100, ssoStoreFactory);
        haSSO.setSSOStorePool(storePool);
    }
}

