/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import com.sun.enterprise.ee.web.authenticator.HASingleSignOnEntry;
import com.sun.enterprise.ee.web.authenticator.SSOStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.ValveContext;
import org.apache.catalina.session.StandardSession;

public class HASingleSignOn
extends SingleSignOn
implements ShutdownCleanupCapable {
    private static Logger _logger = null;
    protected StorePool _pool = null;
    private Thread thread = null;
    private boolean threadDone = false;
    private Map _connectionsMap = Collections.synchronizedMap(new WeakHashMap(50));

    public HASingleSignOn() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public void setSSOStorePool(StorePool pool) {
        this._pool = pool;
    }

    public StorePool getSSOStorePool() {
        return this._pool;
    }

    public void doCloseCachedConnection() {
    }

    public int doShutdownCleanup() {
        return this.closeAllConnections();
    }

    public int closeAllConnections() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn.closeAllConnections()");
        }
        int count = 0;
        Set connections = this._connectionsMap.keySet();
        Iterator it = connections.iterator();
        while (it.hasNext()) {
            Connection nextConn = (Connection)it.next();
            if (nextConn == null) continue;
            try {
                nextConn.close();
                ++count;
            }
            catch (SQLException ex) {}
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn closed " + count + " connections during shutdown");
        }
        return count;
    }

    public synchronized void putConnection(Connection conn) {
        this._connectionsMap.put(conn, null);
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn.invoke()");
        }
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (hreq.getUserPrincipal() != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO cookie not present");
            }
            return 1;
        }
        Realm realm = request.getContext().getRealm();
        if (realm == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        String realmName = realm.getRealmName();
        if (realmName == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookupEntry(cookie.getValue())) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Cached SingleSignOnEntry: " + entry);
            }
            if (!realmName.equals(entry.realmName)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Ignoring SSO entry which does not match application realm '" + realmName + "'");
                }
                return 1;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
            }
            if (entry.principal == null && entry.username != null) {
                entry.principal = ((RealmAdapter)request.getContext().getRealm()).createFailOveredPrincipal(entry.username);
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
            entry.lastAccessTime = System.currentTimeMillis();
            ((HASingleSignOnEntry)entry).dirty = true;
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            hres.addCookie(cookie);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response, ValveContext ctx) throws IOException, ServletException {
        try {
            this.doInvoke(request, response);
            ctx.invokeNext(request, response);
        }
        catch (Exception ex) {}
    }

    public int doInvoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn.doInvoke()");
        }
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (hreq.getUserPrincipal() != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO cookie is not present");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookupEntry(cookie.getValue())) != null) {
            Realm realm;
            if (entry.principal == null && entry.username != null) {
                entry.principal = ((RealmAdapter)request.getContext().getRealm()).createFailOveredPrincipal(entry.username);
            }
            if ((realm = request.getContext().getRealm()) != null) {
                entry.realmName = realm.getRealmName();
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Cached SingleSignOnEntry: " + entry);
        }
        if (entry != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
            entry.lastAccessTime = System.currentTimeMillis();
            ((HASingleSignOnEntry)entry).dirty = true;
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            hres.addCookie(cookie);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SingleSignOnEntry lookupEntry(String ssoId) {
        SingleSignOnEntry ssoEntry;
        block22: {
            SSOStorePoolElement store;
            long startTime;
            block21: {
                block19: {
                    SingleSignOnEntry singleSignOnEntry;
                    block20: {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("HASingleSignOn.lookupEntry(): ssoId=" + ssoId);
                        }
                        ssoEntry = null;
                        startTime = System.currentTimeMillis();
                        store = null;
                        store = (SSOStorePoolElement)this._pool.take();
                        store.setContainer(this.getContainer());
                        ssoEntry = super.lookupEntry(ssoId);
                        if (ssoEntry == null) break block19;
                        singleSignOnEntry = ssoEntry;
                        Object var8_8 = null;
                        if (store == null) break block20;
                        try {
                            this._pool.put(store);
                            if (_logger.isLoggable(Level.FINEST)) {
                                long endTime = System.currentTimeMillis();
                                _logger.finest("lookup_TIME MILLIS = " + (endTime - startTime));
                            }
                        }
                        catch (InterruptedException ex1) {
                            ex1.printStackTrace();
                        }
                    }
                    return singleSignOnEntry;
                }
                try {
                    ssoEntry = store.loadSSO(ssoId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ssoEntry == null) break block21;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("lookup before :- ssoID=" + ssoId + "   " + ssoEntry);
                    _logger.finest("container= " + this.container + " realm= " + this.container.getRealm());
                    _logger.finest("lookup after if :- ssoID=" + ssoId + "   " + ssoEntry);
                }
                this.registerInMemory(ssoId, ssoEntry);
            }
            Object var8_9 = null;
            if (store == null) break block22;
            try {
                this._pool.put(store);
                if (_logger.isLoggable(Level.FINEST)) {
                    long endTime = System.currentTimeMillis();
                    _logger.finest("lookup_TIME MILLIS = " + (endTime - startTime));
                }
                break block22;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            break block22;
            {
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    Object var8_10 = null;
                    if (store == null) break block22;
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("lookup_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block22;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (store != null) {
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("lookup_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return ssoEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerInMemory(String ssoId, SingleSignOnEntry sso) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, sso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void register(String ssoId, Principal principal, String authType, String username, String password, String realmName) {
        startTime = System.currentTimeMillis();
        store = null;
        try {
            block13: {
                store = (SSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                ssoEntry = new HASingleSignOnEntry(principal, authType, username, password, realmName);
                this.registerInMemory(ssoId, ssoEntry);
                if (authType.equals("FORM") || authType.equals("BASIC")) break block13;
                var13_11 = null;
                if (store == null) return;
                ** GOTO lbl51
            }
            try {
                if (HASingleSignOn._logger.isLoggable(Level.FINEST)) {
                    HASingleSignOn._logger.finest("HASingleSignOn.register(): About to save: ssoId=" + ssoId + " ssoEntry=" + (Object)ssoEntry);
                }
                store.save(ssoId, ssoEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ** GOTO lbl60
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
            var13_13 = null;
            if (store == null) return;
            try {
                this._pool.put(store);
                if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) return;
                endTime = System.currentTimeMillis();
                HASingleSignOn._logger.finest("register_TIME MILLIS = " + (endTime - startTime));
                return;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var12_24) {
                var13_14 = null;
                if (store == null) throw var12_24;
                ** try [egrp 3[TRYBLOCK] [7 : 178->236)] { 
lbl43:
                // 1 sources

                this._pool.put(store);
                if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) throw var12_24;
                endTime = System.currentTimeMillis();
                HASingleSignOn._logger.finest("register_TIME MILLIS = " + (endTime - startTime));
                throw var12_24;
lbl48:
                // 1 sources

                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
                throw var12_24;
            }
lbl51:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 178->236)] { 
lbl52:
            // 1 sources

            this._pool.put(store);
            if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) return;
            endTime = System.currentTimeMillis();
            HASingleSignOn._logger.finest("register_TIME MILLIS = " + (endTime - startTime));
            return;
lbl57:
            // 1 sources

            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            return;
lbl60:
            // 2 sources

            var13_12 = null;
            if (store == null) return;
            try {}
            catch (InterruptedException ex1) {}
            ex1.printStackTrace();
            return;
            this._pool.put(store);
            if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) return;
            endTime = System.currentTimeMillis();
            HASingleSignOn._logger.finest("register_TIME MILLIS = " + (endTime - startTime));
            return;
        }
    }

    protected void deregister(String ssoId) {
        this.deregister(ssoId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deregister(String ssoId, boolean bgCall) {
        if (HASingleSignOn._logger.isLoggable(Level.FINEST)) {
            if (bgCall) {
                HASingleSignOn._logger.finest("BackGround : Deregistering ssoId '" + ssoId + "'");
            } else {
                HASingleSignOn._logger.finest("ForeGround : Deregistering ssoId '" + ssoId + "'");
            }
        }
        sso = null;
        startTime = System.currentTimeMillis();
        store = null;
        try {
            block26: {
                store = (SSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                var7_6 = this.cache;
                synchronized (var7_6) {
                    sso = (SingleSignOnEntry)this.cache.remove(ssoId);
                }
                try {
                    if (!bgCall) {
                        store.remove(ssoId);
                    } else {
                        store.remove(ssoId, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (sso != null) break block26;
                var12_9 = null;
                if (store == null) return;
                ** GOTO lbl79
            }
            sessions = sso.findSessions();
            for (i = 0; i < sessions.length; ++i) {
                if (HASingleSignOn._logger.isLoggable(Level.FINEST)) {
                    HASingleSignOn._logger.finest("Invalidating session " + sessions[i]);
                }
                var9_23 = this.reverse;
                synchronized (var9_23) {
                    this.reverse.remove(sessions[i]);
                }
                sessions[i].expire();
            }
            try {
                block27: {
                    if (bgCall) break block27;
                    store.removeInActiveSessions(ssoId);
                    ** GOTO lbl88
                }
                store.removeInActiveSessions(ssoId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ** GOTO lbl88
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
            var12_11 = null;
            if (store == null) return;
            try {
                this._pool.put(store);
                if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) return;
                endTime = System.currentTimeMillis();
                HASingleSignOn._logger.finest("deregister_TIME MILLIS = " + (endTime - startTime));
                return;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var11_24) {
                var12_12 = null;
                if (store == null) throw var11_24;
                ** try [egrp 6[TRYBLOCK] [12 : 365->423)] { 
lbl71:
                // 1 sources

                this._pool.put(store);
                if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) throw var11_24;
                endTime = System.currentTimeMillis();
                HASingleSignOn._logger.finest("deregister_TIME MILLIS = " + (endTime - startTime));
                throw var11_24;
lbl76:
                // 1 sources

                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
                throw var11_24;
            }
lbl79:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [12 : 365->423)] { 
lbl80:
            // 1 sources

            this._pool.put(store);
            if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) return;
            endTime = System.currentTimeMillis();
            HASingleSignOn._logger.finest("deregister_TIME MILLIS = " + (endTime - startTime));
            return;
lbl85:
            // 1 sources

            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            return;
lbl88:
            // 3 sources

            var12_10 = null;
            if (store == null) return;
            try {}
            catch (InterruptedException ex1) {}
            ex1.printStackTrace();
            return;
            this._pool.put(store);
            if (HASingleSignOn._logger.isLoggable(Level.FINEST) == false) return;
            endTime = System.currentTimeMillis();
            HASingleSignOn._logger.finest("deregister_TIME MILLIS = " + (endTime - startTime));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void associate(String ssoId, Session session) {
        block20: {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("HASingleSignOn.associate(): Associate sso id " + ssoId + " with session " + session);
            }
            long startTime = System.currentTimeMillis();
            SSOStorePoolElement store = null;
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            SingleSignOnEntry sso = this.lookupEntry(ssoId);
            if (sso != null) {
                sso.addSession((SingleSignOn)this, session);
            }
            HashMap hashMap = this.reverse;
            synchronized (hashMap) {
                this.reverse.put(session, ssoId);
            }
            try {
                if (session != null && session instanceof HASession) {
                    ((HASession)session).setSsoId(ssoId);
                    store.associate((StandardSession)session, ssoId);
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Exception in HASingleSignOn.associate()", e);
            }
            Object var10_10 = null;
            if (store == null) break block20;
            try {
                this._pool.put(store);
                if (_logger.isLoggable(Level.FINEST)) {
                    long endTime = System.currentTimeMillis();
                    _logger.finest("associate_TIME MILLIS = " + (endTime - startTime));
                }
                break block20;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            break block20;
            {
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    Object var10_11 = null;
                    if (store == null) break block20;
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("associate_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block20;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (store != null) {
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("associate_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void stop() throws LifecycleException {
        block21: {
            if (!this.started) {
                throw new LifecycleException(sm.getString("authenticator.notStarted"));
            }
            long startTime = System.currentTimeMillis();
            SSOStorePoolElement store = null;
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                Iterator it = this.cache.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (!((HASingleSignOnEntry)sso).dirty) continue;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Stop: updating the SSO session " + key);
                    }
                    store.save(key, sso);
                    ((HASingleSignOnEntry)sso).dirty = false;
                }
            }
            Object var10_10 = null;
            if (store == null) break block21;
            try {
                this._pool.put(store);
                if (_logger.isLoggable(Level.FINEST)) {
                    long endTime = System.currentTimeMillis();
                    _logger.finest("stop_TIME MILLIS = " + (endTime - startTime));
                }
                break block21;
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
            break block21;
            {
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    Object var10_11 = null;
                    if (store == null) break block21;
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("stop_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block21;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                    break block21;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Object var10_12 = null;
                    if (store == null) break block21;
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("stop_TIME MILLIS = " + (endTime - startTime));
                        }
                        break block21;
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (store != null) {
                    try {
                        this._pool.put(store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("stop_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        this.threadStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long tooOld = System.currentTimeMillis() - (long)(this.getMaxInactive() * 1000);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(tooOld + "SSO Expiration thread started. Current entries: " + this.cache.size());
        }
        ArrayList<String> removals = new ArrayList<String>(this.cache.size() / 2);
        try {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                Iterator it = this.cache.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest(tooOld + "*******************  " + sso.lastAccessTime + "   SSO Expiration thread started. Current entries: " + this.cache.size());
                    }
                    if (sso.sessions.length != 0 || sso.lastAccessTime >= tooOld) continue;
                    removals.add(key);
                }
            }
            int removalCount = removals.size();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO cache will expire " + removalCount + " entries.");
            }
            for (int i = 0; i < removalCount; ++i) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("SSO Expiration removing entry: " + removals.get(i));
                }
                this.deregister((String)removals.get(i), true);
            }
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Exception in HASingleSignOn.processExpires()", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processUpdateLat() {
        block22: {
            long startTime = System.currentTimeMillis();
            SSOStorePoolElement store = null;
            Hashtable<String, SingleSignOnEntry> updatedLats = new Hashtable<String, SingleSignOnEntry>(this.cache.size() / 2);
            try {
                Iterator it;
                HashMap hashMap = this.cache;
                synchronized (hashMap) {
                    it = this.cache.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("====" + sso.lastAccessTime + "   SSO Expiration/Updation thread started. Current cache entries: " + this.cache.size());
                        }
                        if (!((HASingleSignOnEntry)sso).dirty) continue;
                        updatedLats.put(key, sso);
                    }
                }
                int updatedLatsCount = updatedLats.size();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("SSO table will updated " + updatedLatsCount + " entries.");
                }
                store = (SSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                it = updatedLats.keySet().iterator();
                while (it.hasNext()) {
                    String ssoId = (String)it.next();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("SSO LATupdation updating entry: " + ssoId);
                    }
                    store.updateLastAccessTime(ssoId, ((SingleSignOnEntry)updatedLats.get((Object)ssoId)).lastAccessTime);
                    ((HASingleSignOnEntry)((Object)updatedLats.get((Object)ssoId))).dirty = false;
                }
                Object var11_12 = null;
                if (store == null) break block22;
                try {
                    this._pool.put(store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                    }
                    break block22;
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
                break block22;
                {
                    catch (InterruptedException iex) {
                        iex.printStackTrace();
                        Object var11_13 = null;
                        if (store == null) break block22;
                        try {
                            this._pool.put(store);
                            if (_logger.isLoggable(Level.FINEST)) {
                                long endTime = System.currentTimeMillis();
                                _logger.finest("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                            }
                            break block22;
                        }
                        catch (InterruptedException ex1) {
                            ex1.printStackTrace();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (store != null) {
                        try {
                            this._pool.put(store);
                            if (_logger.isLoggable(Level.FINEST)) {
                                long endTime = System.currentTimeMillis();
                                _logger.finest("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                            }
                        }
                        catch (InterruptedException ex1) {
                            ex1.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                _logger.log(Level.WARNING, "Exception in HASingleSignOn.processUpdateLat()", e);
            }
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.getReapInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "HASingleSignOnExpiration";
        this.thread = new Thread((Runnable)((Object)this), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
            this.processUpdateLat();
        }
    }
}

