/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.store;

import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.enterprise.ee.web.sessmgmt.ConnectionUtil;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.util.logging.Logger;

public class SFSBStoreConnectionUtil
extends ConnectionUtil {
    private static Logger _logger = null;

    public SFSBStoreConnectionUtil(Object cont, SFSBStoreManager mgr) {
        super(cont);
        this.manager = mgr;
    }

    protected String getDataSourceNameFromConfig() {
        if (this.dataSourceString == null) {
            EJBServerConfigLookup configLookup = new EJBServerConfigLookup();
            this.dataSourceString = configLookup.getHaStorePoolJndiNameFromConfig();
        }
        return this.dataSourceString;
    }

    public Connection doSuperGetConnection(boolean autoCommit) throws IOException {
        return super.getConnection(autoCommit);
    }

    public Connection doSuperGetConnection2() throws IOException {
        return super.getConnection();
    }

    public HADBConnectionGroup doSuperGetConnectionsFromPool(boolean autoCommit) throws IOException {
        return super.getConnectionsFromPool(autoCommit);
    }

    public HADBConnectionGroup doSuperGetConnectionsFromPool2() throws IOException {
        return super.getConnectionsFromPool();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection getConnection(boolean autoCommit) throws IOException {
        Connection conn = null;
        if (System.getSecurityManager() == null) return this.doSuperGetConnection(autoCommit);
        try {
            return (Connection)AccessController.doPrivileged(new PrivilegedGetConnection(autoCommit));
        }
        catch (PrivilegedActionException ex) {
            Exception exception = ex.getException();
            if (!(exception instanceof IOException)) return conn;
            throw (IOException)exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection getConnection() throws IOException {
        Connection conn = null;
        if (System.getSecurityManager() == null) return this.doSuperGetConnection2();
        try {
            return (Connection)AccessController.doPrivileged(new PrivilegedGetConnection2());
        }
        catch (PrivilegedActionException ex) {
            Exception exception = ex.getException();
            if (!(exception instanceof IOException)) return conn;
            throw (IOException)exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HADBConnectionGroup getConnectionsFromPool(boolean autoCommit) throws IOException {
        HADBConnectionGroup connGroup = null;
        if (System.getSecurityManager() == null) return this.doSuperGetConnectionsFromPool(autoCommit);
        try {
            return (HADBConnectionGroup)AccessController.doPrivileged(new PrivilegedGetConnections(autoCommit));
        }
        catch (PrivilegedActionException ex) {
            Exception exception = ex.getException();
            if (!(exception instanceof IOException)) return connGroup;
            throw (IOException)exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HADBConnectionGroup getConnectionsFromPool() throws IOException {
        HADBConnectionGroup connGroup = null;
        if (System.getSecurityManager() == null) return this.doSuperGetConnectionsFromPool2();
        try {
            return (HADBConnectionGroup)AccessController.doPrivileged(new PrivilegedGetConnections2());
        }
        catch (PrivilegedActionException ex) {
            Exception exception = ex.getException();
            if (!(exception instanceof IOException)) return connGroup;
            throw (IOException)exception;
        }
    }

    private class PrivilegedGetConnection2
    implements PrivilegedExceptionAction {
        PrivilegedGetConnection2() {
        }

        public Object run() throws Exception {
            return SFSBStoreConnectionUtil.this.doSuperGetConnection2();
        }
    }

    private class PrivilegedGetConnection
    implements PrivilegedExceptionAction {
        private boolean autoCommit;

        PrivilegedGetConnection(boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        public Object run() throws Exception {
            return SFSBStoreConnectionUtil.this.doSuperGetConnection(this.autoCommit);
        }
    }

    private class PrivilegedGetConnections2
    implements PrivilegedExceptionAction {
        PrivilegedGetConnections2() {
        }

        public Object run() throws Exception {
            return SFSBStoreConnectionUtil.this.doSuperGetConnectionsFromPool2();
        }
    }

    private class PrivilegedGetConnections
    implements PrivilegedExceptionAction {
        private boolean autoCommit;

        PrivilegedGetConnections(boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        public Object run() throws Exception {
            return SFSBStoreConnectionUtil.this.doSuperGetConnectionsFromPool(this.autoCommit);
        }
    }
}

