/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.regexp.internal;

import com.sun.org.apache.regexp.internal.RE;
import com.sun.org.apache.regexp.internal.REDebugCompiler;
import com.sun.org.apache.regexp.internal.REProgram;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class RETest {
    RE r = new RE();
    REDebugCompiler compiler = new REDebugCompiler();
    static final boolean showSuccesses = false;
    char[] re1Instructions = new char[]{'|', '\u0000', '\u001a', '|', '\u0000', '\r', 'A', '\u0001', '\u0004', 'a', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff6', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', 'A', '\u0001', '\u0004', 'b', 'E', '\u0000', '\u0000'};
    REProgram re1 = new REProgram(this.re1Instructions);
    String expr;
    int n = 0;
    int failures = 0;

    public static void main(String[] arg) {
        try {
            RETest.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean test() throws Exception {
        RETest test = new RETest();
        test.runAutomatedTests("docs/RETest.txt");
        return test.failures == 0;
    }

    public RETest() {
    }

    public RETest(String[] arg) {
        try {
            if (arg.length == 2) {
                this.runInteractiveTests(arg[1]);
            } else if (arg.length == 1) {
                this.runAutomatedTests(arg[0]);
            } else {
                System.out.println("Usage: RETest ([-i] [regex]) ([/path/to/testfile.txt])");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void runInteractiveTests(String expr) {
        try {
            this.r.setProgram(this.compiler.compile(expr));
            this.say("\n" + expr + "\n");
            this.compiler.dumpProgram(new PrintWriter(System.out));
            while (true) {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("> ");
                System.out.flush();
                String match = br.readLine();
                if (this.r.match(match)) {
                    this.say("Match successful.");
                } else {
                    this.say("Match failed.");
                }
                this.showParens(this.r);
            }
        }
        catch (Exception e) {
            this.say("Error: " + e.toString());
            e.printStackTrace();
            return;
        }
    }

    void die(String s) {
        this.say("FATAL ERROR: " + s);
        System.exit(0);
    }

    void fail(String s) {
        ++this.failures;
        this.say("\n");
        this.say("*******************************************************");
        this.say("*********************  FAILURE!  **********************");
        this.say("*******************************************************");
        this.say("\n");
        this.say(s);
        this.say("");
        this.compiler.dumpProgram(new PrintWriter(System.out));
        this.say("\n");
    }

    void success(String s) {
    }

    void say(String s) {
        System.out.println(s);
    }

    void show() {
        this.say("\n-----------------------\n");
        this.say("Expression #" + this.n + " \"" + this.expr + "\" ");
    }

    void showParens(RE r) {
        for (int i = 0; i < r.getParenCount(); ++i) {
            this.say("$" + i + " = " + r.getParen(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAutomatedTests(String testDocument) throws Exception {
        long ms;
        block24: {
            ms = System.currentTimeMillis();
            RE r = new RE(this.re1);
            this.say("a*b");
            this.say("aaaab = " + r.match("aaab"));
            this.showParens(r);
            this.say("b = " + r.match("b"));
            this.showParens(r);
            this.say("c = " + r.match("c"));
            this.showParens(r);
            this.say("ccccaaaaab = " + r.match("ccccaaaaab"));
            this.showParens(r);
            r = new RE("a*b");
            Object[] s = r.split("xxxxaabxxxxbyyyyaaabzzz");
            r = new RE("x+");
            s = r.grep(s);
            for (int i = 0; i < s.length; ++i) {
                System.out.println("s[" + i + "] = " + (String)s[i]);
            }
            r = new RE("a*b");
            String s1 = r.subst("aaaabfooaaabgarplyaaabwackyb", "-");
            System.out.println("s = " + s1);
            File testInput = new File(testDocument);
            if (!testInput.exists()) {
                throw new Exception("Could not find: " + testDocument);
            }
            BufferedReader br = new BufferedReader(new FileReader(testInput));
            block10: while (true) {
                while (br.ready()) {
                    String yesno;
                    String number = "";
                    while (br.ready() && (number = br.readLine()) != null && !(number = number.trim()).startsWith("#")) {
                        if (number.equals("")) continue;
                        System.out.println("Script error.  Line = " + number);
                        System.exit(0);
                    }
                    if (!br.ready()) {
                        break block24;
                    }
                    this.expr = br.readLine();
                    ++this.n;
                    this.say("");
                    this.say(this.n + ". " + this.expr);
                    this.say("");
                    try {
                        r.setProgram(this.compiler.compile(this.expr));
                    }
                    catch (Exception e) {
                        yesno = br.readLine().trim();
                        if (yesno.equals("ERR")) {
                            this.say("   Match: ERR");
                            this.success("Produces an error (" + e.toString() + "), as expected.");
                            continue;
                        }
                        this.fail("Produces the unexpected error \"" + e.getMessage() + "\"");
                    }
                    catch (Error e) {
                        this.fail("Compiler threw fatal error \"" + e.getMessage() + "\"");
                        e.printStackTrace();
                    }
                    String matchAgainst = br.readLine().trim();
                    this.say("   Match against: '" + matchAgainst + "'");
                    if (matchAgainst.equals("ERR")) {
                        this.fail("Was expected to be an error, but wasn't.");
                        continue;
                    }
                    try {
                        boolean b = r.match(matchAgainst);
                        yesno = br.readLine().trim();
                        if (b) {
                            this.say("   Match: YES");
                            if (yesno.equals("NO")) {
                                this.fail("Matched \"" + matchAgainst + "\", when not expected to.");
                                continue block10;
                            }
                            if (yesno.equals("YES")) {
                                this.success("Matched \"" + matchAgainst + "\", as expected:");
                                this.say("   Paren count: " + r.getParenCount());
                                int p = 0;
                                while (true) {
                                    if (p >= r.getParenCount()) continue block10;
                                    String register = br.readLine().trim();
                                    this.say("   Paren " + p + " : " + r.getParen(p));
                                    if (!register.equals(r.getParen(p))) {
                                        this.fail("Register " + p + " should be = \"" + register + "\", but is \"" + r.getParen(p) + "\" instead.");
                                    }
                                    ++p;
                                }
                            }
                            this.die("Test script error!");
                            continue block10;
                        }
                        this.say("   Match: NO");
                        if (yesno.equals("YES")) {
                            this.fail("Did not match \"" + matchAgainst + "\", when expected to.");
                            continue block10;
                        }
                        if (yesno.equals("NO")) {
                            this.success("Did not match \"" + matchAgainst + "\", as expected.");
                            continue block10;
                        }
                        this.die("Test script error!");
                        continue block10;
                    }
                    catch (Exception e) {
                        this.fail("Matcher threw exception: " + e.toString());
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        this.fail("Matcher threw fatal error \"" + e.getMessage() + "\"");
                        e.printStackTrace();
                    }
                }
                break block24;
                {
                    continue block10;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        System.out.println("\n\nMatch time = " + (System.currentTimeMillis() - ms) + " ms.");
        System.out.println("\nTests complete.  " + this.n + " tests, " + this.failures + " failure(s).");
    }
}

