/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import com.sun.xml.bind.marshaller.MarshallerImpl;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.serializer.NamespaceContext2;
import com.sun.xml.bind.serializer.NamespaceContextImpl;
import com.sun.xml.bind.serializer.PrefixCallback;
import com.sun.xml.bind.serializer.XMLSerializable;
import com.sun.xml.bind.serializer.XMLSerializer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.ValidationEventImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXMarshaller
implements XMLSerializer {
    private final AttributesImpl attributes = new AttributesImpl();
    private final ContentHandler writer;
    private final MarshallerImpl owner;
    private final NamespaceContextImpl nsContext = new NamespaceContextImpl();
    private String[] elementStack = new String[16];
    private int elementLen = 0;
    private final PrefixCallback startPrefixCallback = new PrefixCallback(){

        public void onPrefixMapping(String prefix, String nsUri) throws SAXException {
            SAXMarshaller.this.writer.startPrefixMapping(prefix, nsUri);
        }
    };
    private final PrefixCallback endPrefixCallback = new PrefixCallback(){

        public void onPrefixMapping(String prefix, String nsUri) throws SAXException {
            SAXMarshaller.this.writer.endPrefixMapping(prefix);
        }
    };
    private StringBuffer textBuf = new StringBuffer();
    private String attNamespaceUri;
    private String attLocalName;

    public void endAttribute() {
        String qname = this.attNamespaceUri.length() == 0 ? this.attLocalName : this.nsContext.declareNamespace(this.attNamespaceUri, true) + ':' + this.attLocalName;
        this.attributes.addAttribute(this.attNamespaceUri, this.attLocalName, qname, "CDATA", this.textBuf.toString());
        this.textBuf = null;
    }

    public void endAttributes() throws SAXException {
        String uri = this.getCurrentElementUri();
        String local = this.getCurrentElementLocal();
        String prefix = this.nsContext.declareNamespace(uri, false);
        String qname = local;
        if (prefix != null) {
            qname = prefix + ':' + qname;
        }
        this.nsContext.iterateDeclaredPrefixes(this.startPrefixCallback);
        this.writer.startElement(uri, local, qname, this.attributes);
        this.attributes.clear();
        SAXMarshaller._assert(this.textBuf == null);
        this.textBuf = new StringBuffer();
    }

    public void endElement() throws SAXException {
        this.writePendingText();
        String uri = this.getCurrentElementUri();
        String local = this.getCurrentElementLocal();
        String prefix = this.nsContext.getPrefix(uri);
        String qname = local;
        if (prefix != null) {
            qname = prefix + ':' + qname;
        }
        this.writer.endElement(uri, local, qname);
        this.nsContext.iterateDeclaredPrefixes(this.endPrefixCallback);
        this.popElement();
        SAXMarshaller._assert(this.textBuf == null);
        this.textBuf = new StringBuffer();
        this.nsContext.endElement();
    }

    private void missingObjectError() throws SAXException {
        ValidationEventImpl ev = new ValidationEventImpl(1, Messages.format("SAXMarshaller.MissingObject"), null);
        this.reportError(ev);
    }

    private void popElement() {
        this.elementLen -= 2;
    }

    private void writePendingText() throws SAXException {
        if (this.textBuf.length() != 0) {
            this.writer.characters(this.textBuf.toString().toCharArray(), 0, this.textBuf.length());
        }
        this.textBuf = null;
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new InternalError(Messages.format("SAXMarshaller.AssertFailed"));
        }
    }

    public NamespaceContext2 getNamespaceContext() {
        return this.nsContext;
    }

    public void childAsAttributeBodies(XMLSerializable o) throws SAXException {
        if (o == null) {
            this.missingObjectError();
            return;
        }
        o.serializeAttributeBodies(this);
    }

    public void childAsAttributes(XMLSerializable o) throws SAXException {
        if (o == null) {
            this.missingObjectError();
            return;
        }
        o.serializeAttributes(this);
    }

    public void childAsElements(XMLSerializable o) throws SAXException {
        if (o == null) {
            this.missingObjectError();
            return;
        }
        o.serializeElements(this);
    }

    private String getCurrentElementLocal() {
        return this.elementStack[this.elementLen - 1];
    }

    private String getCurrentElementUri() {
        return this.elementStack[this.elementLen - 2];
    }

    public void text(String text) throws SAXException {
        SAXMarshaller._assert(this.textBuf != null);
        if (text == null) {
            ValidationEventImpl ev = new ValidationEventImpl(1, Messages.format("SAXMarshaller.MissingObject"), null, new NullPointerException());
            this.reportError(ev);
            return;
        }
        if (this.textBuf.length() != 0) {
            this.textBuf.append(' ');
        }
        this.textBuf.append(text);
    }

    public void reportError(ValidationEvent ve) throws AbortSerializationException {
        ValidationEventHandler handler;
        try {
            handler = this.owner.getEventHandler();
        }
        catch (JAXBException e) {
            throw new AbortSerializationException(e);
        }
        if (!handler.handleEvent(ve)) {
            throw new AbortSerializationException(ve.getMessage());
        }
    }

    public SAXMarshaller(ContentHandler _writer, MarshallerImpl _owner) {
        this.writer = _writer;
        this.owner = _owner;
    }

    public String onID(String value) throws SAXException {
        return value;
    }

    public String onIDREF(String value) throws SAXException {
        return value;
    }

    private void pushElement(String uri, String local) {
        if (this.elementStack.length == this.elementLen) {
            String[] buf = new String[this.elementStack.length * 2];
            System.arraycopy(this.elementStack, 0, buf, 0, this.elementStack.length);
            this.elementStack = buf;
        }
        this.elementStack[this.elementLen++] = uri;
        this.elementStack[this.elementLen++] = local;
    }

    public void startAttribute(String uri, String local) {
        SAXMarshaller._assert(this.textBuf == null);
        this.textBuf = new StringBuffer();
        this.attNamespaceUri = uri;
        this.attLocalName = local;
    }

    public void startElement(String uri, String local) throws SAXException {
        this.writePendingText();
        this.nsContext.startElement();
        this.pushElement(uri, local);
    }
}

