/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class WriterOutputStream
extends OutputStream {
    private Writer _writer = null;
    private CharsetDecoder _charsetDecoder = null;

    public WriterOutputStream(Writer writer) {
        this._writer = writer;
    }

    public WriterOutputStream(Writer writer, String charsetName) {
        this._writer = writer;
        Charset charset = Charset.forName(charsetName);
        this._charsetDecoder = charset != null ? charset.newDecoder() : null;
    }

    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder) {
        this._writer = writer;
        this._charsetDecoder = charsetDecoder;
    }

    public void write(byte[] b) throws IOException {
        if (this._charsetDecoder == null) {
            this._writer.write(new String(b));
        } else {
            this.write(ByteBuffer.wrap(b));
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this._charsetDecoder == null) {
            this._writer.write(new String(b, off, len));
        } else {
            this.write(ByteBuffer.wrap(b, off, len));
        }
    }

    public void write(int b) throws IOException {
        byte[] ba = new byte[]{(byte)b};
        this.write(ba);
    }

    private void write(ByteBuffer b) throws IOException {
        this._charsetDecoder.reset();
        CharBuffer c = null;
        try {
            c = this._charsetDecoder.decode(b);
        }
        catch (CharacterCodingException e) {
            throw new IOException(e.getMessage());
        }
        if (c != null) {
            this._writer.write(c.array());
        }
    }
}

