/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.httpservice;

import com.sun.enterprise.web.connector.httpservice.HttpServiceConnector;
import java.io.IOException;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteOutputStream;
import org.apache.tomcat.util.buf.ByteChunk;

final class HttpServiceResponseStream
extends CoyoteOutputStream
implements OutputBuffer {
    private HttpServiceConnector _connector;
    private boolean _flushNativeStream;
    private boolean _isDirty;
    protected boolean committed;

    public HttpServiceResponseStream(HttpServiceConnector connector) {
        super(null);
        this._connector = connector;
        this._flushNativeStream = true;
        this._isDirty = true;
    }

    public void flush() throws IOException {
        if (this._flushNativeStream && this._isDirty) {
            super.flush();
            this._connector.flush();
            this.committed = false;
        }
    }

    public void close() throws IOException {
        this._connector.setClosing();
        this.flush();
    }

    public void setOutputBuffer(org.apache.coyote.tomcat5.OutputBuffer outputBuffer) {
        this.ob = outputBuffer;
    }

    protected void setNativeStreamFlushMode(boolean flag) {
        this._flushNativeStream = flag;
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            res.action(ActionCode.ACTION_COMMIT, null);
        }
        this.committed = true;
        this._connector.write(chunk.getBuffer(), chunk.getStart(), chunk.getLength());
        return chunk.getLength();
    }
}

