/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.httpservice;

import com.sun.enterprise.web.PwcWebModule;
import com.sun.enterprise.web.connector.httpservice.HttpServiceConnector;
import com.sun.enterprise.web.connector.httpservice.HttpServiceRequest;
import com.sun.enterprise.web.connector.httpservice.HttpServiceResponseStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import org.apache.catalina.Request;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

final class HttpServiceResponse
extends CoyoteResponse {
    protected boolean isClosing = false;
    protected StringBuffer resultBuffer = new StringBuffer();

    public HttpServiceResponse() {
        this.urlEncoder.addSafeCharacter('/');
        this.setCoyoteResponse(new Response());
        this.coyoteResponse.setStatus(0);
    }

    public void setClosing() {
        this.isClosing = true;
        ((HttpServiceConnector)this.connector).setClosing();
    }

    protected void sendHeaders() throws IOException {
        MessageBytes headerValue;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(this.request.getRequest().getProtocol())) {
            return;
        }
        MimeHeaders headers = this.coyoteResponse.getMimeHeaders();
        String valueStr = this.coyoteResponse.getContentType();
        if (valueStr != null) {
            headerValue = headers.setValue("content-type");
            headerValue.setString(valueStr);
        }
        if ((valueStr = this.coyoteResponse.getContentLanguage()) != null) {
            headerValue = headers.setValue("content-language");
            headerValue.setString(valueStr);
        }
        Object[] responseStrs = null;
        int numStrs = 0;
        int nHeaders = headers.size();
        int nCookies = this.cookies.size();
        int totalHeaders = nHeaders + nCookies;
        boolean useResponseCTForHeaders = false;
        String encoding = null;
        PwcWebModule wm = (PwcWebModule)this.getContext();
        if (wm != null) {
            useResponseCTForHeaders = wm.getResponseCTForHeaders();
            encoding = this.getCharacterEncoding();
        }
        if (totalHeaders > 0) {
            responseStrs = new Object[totalHeaders * 2];
            for (int i = 0; i < nHeaders; ++i) {
                responseStrs[numStrs++] = headers.getName(i).toString();
                responseStrs[numStrs++] = useResponseCTForHeaders ? (Object)headers.getValue(i).toString().getBytes(encoding) : headers.getValue(i).toString();
            }
            if (nCookies > 0) {
                boolean encodeCookies = false;
                if (wm == null || wm.getEncodeCookies()) {
                    encodeCookies = true;
                }
                Iterator items = this.cookies.iterator();
                while (items.hasNext()) {
                    final Cookie cookie = (Cookie)items.next();
                    responseStrs[numStrs++] = "Set-Cookie";
                    final StringBuffer sb = new StringBuffer();
                    if (encodeCookies && !cookie.getName().equals("JSESSIONID")) {
                        if (System.getSecurityManager() != null) {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    ServerCookie.appendEncodedCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure());
                                    return null;
                                }
                            });
                        } else {
                            ServerCookie.appendEncodedCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure());
                        }
                    } else if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure());
                                return null;
                            }
                        });
                    } else {
                        ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure());
                    }
                    String value = sb.toString();
                    if (useResponseCTForHeaders) {
                        responseStrs[numStrs++] = value.getBytes(this.getCharacterEncoding());
                        continue;
                    }
                    responseStrs[numStrs++] = value;
                }
            }
        }
        HttpServiceConnector conn = (HttpServiceConnector)this.connector;
        conn.setAllResponseFields(this.getStatus(), this.filter(this.getMessage()), this.getContentType(), this.getContentLength(), this.isError(), responseStrs, numStrs, useResponseCTForHeaders);
        this.coyoteResponse.setCommitted(true);
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        this.outputStream.flush();
    }

    public void setBufferSize(int size) {
        super.setBufferSize(size);
        HttpServiceConnector conn = (HttpServiceConnector)this.connector;
        conn.resize(size);
    }

    public void setStream(OutputStream stream) {
        this.outputStream = (HttpServiceResponseStream)((Object)stream);
        ((HttpServiceResponseStream)((Object)stream)).setOutputBuffer(this.outputBuffer);
        this.coyoteResponse.setOutputBuffer((OutputBuffer)this.outputStream);
    }

    public void recycle() {
        this.coyoteResponse.recycle();
        super.recycle();
        this.coyoteResponse.setStatus(0);
    }

    public void setRequest(Request request) {
        super.setRequest(request);
        this.coyoteResponse.setRequest(((CoyoteRequest)request).getCoyoteRequest());
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.cookies.add(cookie);
    }

    protected String toEncoded(String url, String sessionId) {
        String jrouteId;
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        if ((jrouteId = ((HttpServiceRequest)this.request).getJrouteId()) != null) {
            sb.append(":");
            sb.append(jrouteId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        this.resultBuffer.setLength(0);
        block9: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    this.resultBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    this.resultBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    this.resultBuffer.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    this.resultBuffer.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    this.resultBuffer.append("\\'");
                    continue block9;
                }
                case '\n': {
                    this.resultBuffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.resultBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    this.resultBuffer.append(content[i]);
                }
            }
        }
        return this.resultBuffer.toString();
    }
}

