/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.httpservice;

import com.sun.enterprise.web.connector.httpservice.HttpServiceConnector;
import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.tomcat5.CoyoteInputStream;
import org.apache.tomcat.util.buf.ByteChunk;

final class HttpServiceRequestStream
extends CoyoteInputStream
implements InputBuffer {
    private HttpServiceConnector _connector;
    private int _maxBytes = -1;
    private int _count = 0;

    public HttpServiceRequestStream(HttpServiceConnector connector, int maxBytes) {
        super(null);
        this._connector = connector;
        this._maxBytes = maxBytes;
    }

    public int read() throws IOException {
        if (this._maxBytes != -1 && this._count == this._maxBytes) {
            return -1;
        }
        int rval = this._connector.readByte();
        if (rval != -1) {
            ++this._count;
        }
        return rval;
    }

    public int read(byte[] destn, int offset, int length) throws IOException {
        int rval;
        if (this._maxBytes != -1) {
            if (this._count == this._maxBytes) {
                return -1;
            }
            if (this._count + length >= this._maxBytes) {
                length = this._maxBytes - this._count;
            }
        }
        if ((rval = this._connector.read(destn, offset, length)) > 0) {
            this._count += rval;
        }
        return rval;
    }

    public int readLine(byte[] destn, int offset, int length) throws IOException {
        int rval;
        if (this._maxBytes != -1) {
            if (this._count == this._maxBytes) {
                return -1;
            }
            if (this._count + length >= this._maxBytes) {
                length = this._maxBytes - this._count;
            }
        }
        if ((rval = this._connector.readLine(destn, offset, length)) > 0) {
            this._count += rval;
        }
        return rval;
    }

    public int available() throws IOException {
        if (this._count > this._maxBytes) {
            return 0;
        }
        return this._maxBytes - this._count;
    }

    public void close() {
        this._connector.skip(this._maxBytes - this._count);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this._maxBytes >= this._count) {
            int rval = this._connector.read(chunk.getBytes(), 0, this._maxBytes - this._count);
            if (rval > 0) {
                chunk.setEnd(rval);
                this._count += rval;
            } else {
                return -1;
            }
        }
        return this._maxBytes - this._count;
    }

    protected void recycle() {
        this._maxBytes = -1;
        this._count = 0;
    }
}

