/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.httpservice;

import com.sun.enterprise.web.PwcWebModule;
import com.sun.enterprise.web.connector.coyote.PECoyoteRequest;
import com.sun.enterprise.web.connector.httpservice.HttpServiceConnector;
import com.sun.enterprise.web.connector.httpservice.HttpServiceProcessor;
import com.sun.enterprise.web.connector.httpservice.HttpServiceRequestStream;
import com.sun.logging.LogDomains;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import org.apache.catalina.Response;
import org.apache.catalina.util.RequestUtil;
import org.apache.coyote.ActionCode;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.ContentType;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

public final class HttpServiceRequest
extends PECoyoteRequest {
    private static final byte[] httpBytes = "http".getBytes();
    private static final byte[] httpsBytes = "https".getBytes();
    private String[] _rqStrs;
    byte[][] _mbRqStrs;
    int[] _rqInts;
    private String _jrouteId;
    private static final int REQ_REMOTE_ADDRESS = 0;
    private static final int REQ_PROTOCOL = 1;
    private static final int REQ_METHOD = 2;
    private static final int REQ_URI = 3;
    private static final int SERVER_NAME = 4;
    private static final int REQ_CONTENT_LENGTH = 5;
    private static final int REQ_CONTENT_TYPE = 6;
    private static final int REQ_AUTH_TYPE = 7;
    private static final int REQ_ACCEPT_LANG = 8;
    private static final int REQ_CLIENT_CERT = 9;
    private static final int REQ_HTTPS_CIPHER = 10;
    private static final int REQ_AUTHORIZATION = 11;
    private static final int REQ_PROXY_JROUTE = 12;
    private static final int REQ_REMOTE_HOST = 13;
    private static final int REQ_CORE_USER = 14;
    private static final int REQ_ERROR_REQUEST_URI = 15;
    private static final int REQ_LOCAL_ADDRESS = 16;
    private static final int LAST_DEFINED_HEADER = 16;
    private static final int MB_REQ_QUERY_STRING = 0;
    private static final int MB_REQ_COOKIE = 1;
    public static final int REQ_SERVER_PORT = 0;
    public static final int REQ_IS_SECURE = 1;
    public static final int REQ_HTTPS_KEY_SIZE = 2;
    public static final int REQ_NATIVE_STREAM_SIZE = 3;
    public static final int REQ_ERROR_STATUS_CODE = 4;
    public static final int REQ_REMOTE_PORT = 5;
    public static final int REQ_LOCAL_PORT = 6;
    private static final String _match = ";jsessionid=";
    private static Logger _logger = null;
    private static boolean _debugLog;
    private boolean _headersLoaded = false;
    private boolean _localeParsed = false;

    public HttpServiceRequest() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
        super.setCoyoteRequest(new Request());
    }

    public void initialize(String[] rqStrs, byte[][] mbRqStrs, int[] rqInts) {
        this._rqStrs = rqStrs;
        this._mbRqStrs = mbRqStrs;
        this._rqInts = rqInts;
        this.setupRequestFields();
    }

    public String getJrouteId() {
        return this._jrouteId;
    }

    public void addHeader(String name, String value) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        MessageBytes headerValue = this.coyoteRequest.getMimeHeaders().addValue(name);
        headerValue.setString(value);
    }

    public long getDateHeader(String name) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        return super.getDateHeader(name);
    }

    public String getHeader(String name) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        return super.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        return super.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        return super.getHeaderNames();
    }

    public int getIntHeader(String name) {
        if (!this._headersLoaded) {
            this.loadHeaders();
        }
        return super.getIntHeader(name);
    }

    public void clearHeaders() {
        this._headersLoaded = true;
        super.clearHeaders();
    }

    public void recycle() {
        this.coyoteRequest.recycle();
        super.recycle();
        this._rqStrs = null;
        this._mbRqStrs = null;
        this._rqInts = null;
        this._jrouteId = null;
        this._headersLoaded = false;
    }

    public void setResponse(Response response) {
        super.setResponse(response);
        this.coyoteRequest.setResponse(((CoyoteResponse)response).getCoyoteResponse());
    }

    private void setJrouteId(String value) {
        this._jrouteId = value;
    }

    private void setupRequestFields() {
        boolean isSecure;
        this.setServerPort(this._rqInts[0]);
        if (this._rqStrs[11] != null) {
            this.setAuthorization(this._rqStrs[11]);
        }
        if (this._rqStrs[12] != null) {
            this.setJrouteId(this._rqStrs[12]);
        }
        this._headersLoaded = false;
        this._localeParsed = false;
        this.setRemoteAddr(this._rqStrs[0]);
        this.setRemoteHost(this._rqStrs[13]);
        this.setRemotePort(this._rqInts[5]);
        this.setLocalPort(this._rqInts[6]);
        this.setLocalAddr(this._rqStrs[16]);
        this.setProtocol(this._rqStrs[1]);
        this.setMethod(this._rqStrs[2]);
        String uristr = this._rqStrs[3];
        int semicolon = uristr.indexOf(_match);
        if (semicolon >= 0) {
            String id;
            String rest = uristr.substring(semicolon + _match.length());
            int semicolon2 = rest.indexOf(59);
            if (semicolon2 >= 0) {
                id = rest.substring(0, semicolon2);
                rest = rest.substring(semicolon2);
            } else {
                id = rest;
                rest = "";
            }
            int colon = id.indexOf(58);
            if (colon > 0) {
                id = id.substring(0, colon);
            }
            this.setRequestedSessionId(id);
            this.setRequestedSessionURL(true);
            uristr = uristr.substring(0, semicolon) + rest;
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
        this.setRequestURI(uristr);
        this.setDecodedRequestURI(this._rqStrs[3]);
        if (this._rqStrs[6] != null) {
            this.setContentType(this._rqStrs[6]);
        }
        if (this._mbRqStrs[0] != null) {
            MessageBytes queryStringValue = null;
            PwcWebModule wm = (PwcWebModule)this.context;
            String charEncoding = ContentType.getCharsetFromContentType((String)this.getContentType());
            if (charEncoding == null && wm.getFormHintField() != null) {
                queryStringValue = new MessageBytes();
                queryStringValue.setEncoding("ISO-8859-1");
                queryStringValue.setBytes(this._mbRqStrs[0], 0, this._mbRqStrs[0].length);
                String queryString = queryStringValue.toString();
                charEncoding = this.getEncodingFromFormHintField(queryString, wm.getFormHintField());
            }
            if (charEncoding == null) {
                charEncoding = "ISO-8859-1";
            }
            queryStringValue = new MessageBytes();
            queryStringValue.setEncoding(charEncoding);
            queryStringValue.setBytes(this._mbRqStrs[0], 0, this._mbRqStrs[0].length);
            this.setQueryString(queryStringValue.toString());
        }
        int cl = -1;
        if (this._rqStrs[5] != null) {
            String reqContentLength = this._rqStrs[5];
            try {
                int n = reqContentLength.indexOf(44);
                cl = n > 0 ? Integer.parseInt(reqContentLength.substring(0, n).trim()) : Integer.parseInt(reqContentLength);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.setContentLength(cl);
        }
        this.setStream((InputStream)((Object)new HttpServiceRequestStream((HttpServiceConnector)this.connector, cl)));
        if (this._mbRqStrs[1] != null) {
            MimeHeaders cookiesHeader = new MimeHeaders();
            MessageBytes headerValue = cookiesHeader.addValue("cookie");
            PwcWebModule wm = (PwcWebModule)this.context;
            if (wm.getEncodeCookies()) {
                byte[] decodedReqCookie = RequestUtil.URLDecode((byte[])this._mbRqStrs[1], (String)"UTF-8").getBytes();
                headerValue.setBytes(decodedReqCookie, 0, decodedReqCookie.length);
            } else {
                headerValue.setBytes(this._mbRqStrs[1], 0, this._mbRqStrs[1].length);
            }
            Cookies serverCookies = new Cookies(cookiesHeader);
            int count = serverCookies.getCookieCount();
            for (int i = 0; i < count; ++i) {
                ServerCookie scookie = serverCookies.getCookie(i);
                if (scookie.getName().equals("JSESSIONID")) {
                    if (!this.isRequestedSessionIdFromCookie()) {
                        this.setRequestedSessionId(scookie.getValue().toString());
                        this.setRequestedSessionCookie(true);
                        this.setRequestedSessionURL(false);
                    } else if (!this.isRequestedSessionIdValid()) {
                        this.setRequestedSessionId(scookie.getValue().toString());
                    }
                }
                try {
                    Cookie cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
                    cookie.setPath(scookie.getPath().toString());
                    cookie.setVersion(scookie.getVersion());
                    String domain = scookie.getDomain().toString();
                    if (domain != null) {
                        cookie.setDomain(scookie.getDomain().toString());
                    }
                    this.addCookie(cookie);
                    continue;
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.log(Level.FINEST, "http.service.bad_cookie_name", new Object[]{scookie.getName(), scookie.getValue()});
                    _logger.log(Level.FINEST, "httservice.got.exception", ex);
                }
            }
        }
        if (this._rqStrs[4] != null) {
            String serverName = this._rqStrs[4];
            int n = serverName.indexOf(58);
            if (n > 0) {
                this.setServerName(serverName.substring(0, n).trim());
            } else {
                this.setServerName(serverName);
            }
        }
        boolean bl = isSecure = this._rqInts[1] == 1;
        if (isSecure) {
            this.setSecure(true);
            this.setScheme("https");
        } else {
            this.setSecure(false);
            this.setScheme("http");
        }
    }

    protected int getNativeStreamSize() {
        return this._rqInts[3];
    }

    private String getEncodingFromFormHintField(String query, String formHintField) {
        String encoding = null;
        int index = query.indexOf(formHintField = formHintField + "=");
        if (index != -1) {
            int endIndex = query.indexOf(38, index);
            encoding = endIndex != -1 ? query.substring(index + formHintField.length(), endIndex) : query.substring(index + formHintField.length());
        }
        return encoding;
    }

    private void loadHeaders() {
        if (!this._headersLoaded) {
            int i = 17;
            while (this._rqStrs[i] != null) {
                MessageBytes headerValue = this.coyoteRequest.getMimeHeaders().addValue(this._rqStrs[i]);
                headerValue.setString(this._rqStrs[i + 1]);
                i += 2;
            }
            this._headersLoaded = true;
        }
    }

    public int getRemotePort() {
        return this.coyoteRequest.getRemotePort();
    }

    public String getLocalName() {
        String localName = this.coyoteRequest.localName().toString();
        if (localName == null) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, (Object)this.coyoteRequest);
            localName = this.coyoteRequest.localName().toString();
        }
        return localName;
    }

    public String getLocalAddr() {
        return this.coyoteRequest.localAddr().toString();
    }

    public int getLocalPort() {
        return this.coyoteRequest.getLocalPort();
    }

    public void setAuthorization(String authoriz) {
        if (authoriz == null) {
            authoriz = "";
        }
        MessageBytes headerValue = this.coyoteRequest.getMimeHeaders().addValue("authorization");
        headerValue.setString(authoriz);
    }

    public void setContentLength(int length) {
        this.coyoteRequest.setContentLength(length);
    }

    public void setContentType(String type) {
        MessageBytes mb;
        if (type == null) {
            type = "";
        }
        if ((mb = this.coyoteRequest.contentType()) == null) {
            mb = this.coyoteRequest.getMimeHeaders().addValue("content-type");
        }
        mb.setString(type);
    }

    public void setProtocol(String protocol) {
        if (protocol == null) {
            protocol = "";
        }
        this.coyoteRequest.protocol().setString(protocol);
    }

    public void setRemotePort(int remotePort) {
        this.coyoteRequest.setRemotePort(remotePort);
    }

    public void setRemoteAddr(String remoteAddr) {
        if (remoteAddr == null) {
            remoteAddr = "";
        }
        this.coyoteRequest.remoteAddr().setString(remoteAddr);
    }

    public void setRemoteHost(String remoteHost) {
        if (remoteHost == null) {
            remoteHost = "";
        }
        this.coyoteRequest.remoteHost().setString(remoteHost);
    }

    public void setLocalPort(int localPort) {
        this.coyoteRequest.setLocalPort(localPort);
    }

    public void setLocalAddr(String localAddr) {
        if (localAddr == null) {
            localAddr = "";
        }
        this.coyoteRequest.localAddr().setString(localAddr);
    }

    public void setLocalName(String localHost) {
        if (localHost == null) {
            localHost = "";
        }
        this.coyoteRequest.localName().setString(localHost);
    }

    public void setScheme(String scheme) {
        if (scheme == null) {
            scheme = "";
        }
        this.coyoteRequest.scheme().setString(scheme);
    }

    public void setMethod(String method) {
        if (method == null) {
            method = "";
        }
        this.coyoteRequest.method().setString(method);
    }

    public void setRequestURI(String uri) {
        if (uri == null) {
            uri = "";
        }
        this.coyoteRequest.requestURI().setString(uri);
    }

    public void setDecodedRequestURI(String uri) {
        if (uri == null) {
            uri = "";
        }
        this.coyoteRequest.decodedURI().setString(uri);
    }

    public void setQueryString(String query) {
        if (query == null) {
            query = "";
        }
        byte[] queryBytes = query.getBytes();
        this.coyoteRequest.queryString().setBytes(queryBytes, 0, queryBytes.length);
    }

    public void setStream(InputStream stream) {
        this.inputStream = (HttpServiceRequestStream)((Object)stream);
        this.coyoteRequest.setInputBuffer((InputBuffer)stream);
    }

    public void clearParameters() {
        this.coyoteRequest.getParameters().recycle();
    }

    public void setServletPath(String path) {
        if (path != null) {
            this.mappingData.wrapperPath.setString(path);
        }
    }

    public void setRequestPath(String path) {
        if (path != null) {
            this.mappingData.requestPath.setString(path);
        }
    }

    public void setAttributes() {
        if (this._rqInts[1] == 1) {
            if (this._rqStrs[10] != null) {
                this.setAttribute("javax.servlet.request.cipher_suite", this._rqStrs[10]);
            }
            this.setAttribute("javax.servlet.request.key_size", new Integer(this._rqInts[2]));
        }
        if (this._rqStrs[14] != null) {
            // empty if block
        }
        if (this._rqStrs[7] != null) {
            // empty if block
        }
        if (this._rqStrs[9] != null) {
            try {
                HttpServiceProcessor.attachRequestCertificate(this._rqStrs[9], this);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        if (this._rqInts[4] != -1) {
            this.setAttribute("javax.servlet.error.status_code", new Integer(this._rqInts[4]));
        }
        if (this._rqStrs[15] != null) {
            this.setAttribute("javax.servlet.error.request_uri", this._rqStrs[15]);
        }
    }
}

