/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.httpservice.monitor;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCThreadPoolStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.httpservice.spi.monitor.ThreadPoolMB;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCThreadPoolStatsImpl
implements PWCThreadPoolStats {
    static Logger _logger = null;
    private ThreadPoolMB _bean;
    private long _startTime;
    private GenericStatsImpl _gsImpl;
    private StringStatistic _id;
    private MutableCountStatistic _countThreadsIdle;
    private MutableCountStatistic _countThreads;
    private MutableCountStatistic _maxThreads;
    private MutableCountStatistic _countQueued;
    private MutableCountStatistic _peakQueued;
    private MutableCountStatistic _maxQueued;

    public PWCThreadPoolStatsImpl(ThreadPoolMB bean) {
        this._bean = bean;
        this.initializeStatistics();
        try {
            this._gsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.WARNING, "httpservice.monitor.stats.constructor.exception", cnfe);
        }
    }

    public StringStatistic getId() {
        StringStatisticImpl ss = new StringStatisticImpl(this._bean.getId(), "id", "String", "Thread pool ID", this._startTime, this._bean.getUpdateTime());
        return ss;
    }

    public CountStatistic getCountThreadsIdle() {
        long countThreadsIdle = this.getBean().getCountThreadsIdle();
        this._countThreadsIdle.setCount(countThreadsIdle);
        return (CountStatistic)this._countThreadsIdle.unmodifiableView();
    }

    public CountStatistic getCountThreads() {
        long countThreads = this.getBean().getCountThreads();
        this._countThreads.setCount(countThreads);
        return (CountStatistic)this._countThreads.unmodifiableView();
    }

    public CountStatistic getMaxThreads() {
        long maxThreads = this.getBean().getMaxThreads();
        this._maxThreads.setCount(maxThreads);
        return (CountStatistic)this._maxThreads.unmodifiableView();
    }

    public CountStatistic getCountQueued() {
        long countQueued = this.getBean().getCountQueued();
        this._countQueued.setCount(countQueued);
        return (CountStatistic)this._countQueued.unmodifiableView();
    }

    public CountStatistic getPeakQueued() {
        long peakQueued = this.getBean().getPeakQueued();
        this._peakQueued.setCount(peakQueued);
        return (CountStatistic)this._peakQueued.unmodifiableView();
    }

    public CountStatistic getMaxQueued() {
        long maxQueued = this.getBean().getMaxQueued();
        this._maxQueued.setCount(maxQueued);
        return (CountStatistic)this._maxQueued.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this._gsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this._gsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this._gsImpl.getStatisticNames();
    }

    private ThreadPoolMB getBean() {
        return this._bean;
    }

    private void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, "countThreadsIdle", "count", "Number of idle request processing threads", time, time);
        this._countThreadsIdle = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countThreads", "count", "Number of request processing threads", time, time);
        this._countThreads = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxThreads", "count", "Maximum number of request processing threads", time, time);
        this._maxThreads = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countQueued", "count", "Number of requests queued for processing by this thread pool", time, time);
        this._countQueued = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "peakQueued", "count", "Largest number of requests that have been in the queue simultaneously", time, time);
        this._peakQueued = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxQueued", "", "Maximum number of request that can be in the queue", time, time);
        this._maxQueued = new MutableCountStatisticImpl((CountStatistic)cs);
        this._startTime = time;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

