/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.httpservice.monitor;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCHttpServiceStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.httpservice.spi.monitor.HttpServiceMB;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCHttpServiceStatsImpl
implements PWCHttpServiceStats {
    static Logger _logger = null;
    private HttpServiceMB _bean;
    private StringStatistic _id;
    private StringStatistic _versionServer;
    private StringStatistic _timeStarted;
    private MutableCountStatistic _secondsRunning;
    private MutableCountStatistic _ticksPerSecond;
    private MutableCountStatistic _maxThreads;
    private MutableCountStatistic _maxVirtualServers;
    private MutableCountStatistic _flagProfilingEnabled;
    private MutableCountStatistic _flagVirtualServerOverflow;
    private MutableCountStatistic _load1MinuteAverage;
    private MutableCountStatistic _load5MinuteAverage;
    private MutableCountStatistic _load15MinuteAverage;
    private MutableCountStatistic _rateBytesTransmitted;
    private MutableCountStatistic _rateBytesReceived;
    private GenericStatsImpl _gsImpl;
    private long _startTime;

    public PWCHttpServiceStatsImpl(HttpServiceMB bean) {
        this._bean = bean;
        this.initializeStatistics();
        try {
            this._gsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.WARNING, "httpservice.monitor.stats.constructor.exception", cnfe);
        }
    }

    public StringStatistic getID() {
        StringStatisticImpl ss = new StringStatisticImpl(this._bean.getId(), "id", "String", "HttpServer instance ID", this._startTime, this._bean.getUpdateTime());
        return ss;
    }

    public StringStatistic getVersionServer() {
        StringStatisticImpl ss = new StringStatisticImpl(this._bean.getVersionServer(), "versionServer", "String", "HttpServer version", this._startTime, this._bean.getUpdateTime());
        return ss;
    }

    public StringStatistic getTimeStarted() {
        StringStatisticImpl ss = new StringStatisticImpl(this._bean.getTimeStarted(), "timeStarted", "time (GMT)", "Time HttpService was started", this._startTime, this._bean.getUpdateTime());
        return ss;
    }

    public CountStatistic getSecondsRunning() {
        long secondsRunning = this.getBean().getSecondsRunning();
        this._secondsRunning.setCount(secondsRunning);
        return (CountStatistic)this._secondsRunning.unmodifiableView();
    }

    public CountStatistic getMaxThreads() {
        long maxThreads = this.getBean().getMaxThreads();
        this._maxThreads.setCount(maxThreads);
        return (CountStatistic)this._maxThreads.unmodifiableView();
    }

    public CountStatistic getMaxVirtualServers() {
        long maxVirtualServers = this.getBean().getMaxVirtualServers();
        this._maxVirtualServers.setCount(maxVirtualServers);
        return (CountStatistic)this._maxVirtualServers.unmodifiableView();
    }

    public CountStatistic getFlagProfilingEnabled() {
        long flagProfilingEnabled = this.getBean().getFlagProfilingEnabled();
        this._flagProfilingEnabled.setCount(flagProfilingEnabled);
        return (CountStatistic)this._flagProfilingEnabled.unmodifiableView();
    }

    public CountStatistic getFlagVirtualServerOverflow() {
        long flagVirtualServerOverflow = this.getBean().getFlagVirtualServerOverflow();
        this._flagVirtualServerOverflow.setCount(flagVirtualServerOverflow);
        return (CountStatistic)this._flagVirtualServerOverflow.unmodifiableView();
    }

    public CountStatistic getLoad1MinuteAverage() {
        long load1MinuteAverage = (long)this.getBean().getLoad1MinuteAverage();
        this._load1MinuteAverage.setCount(load1MinuteAverage);
        return (CountStatistic)this._load1MinuteAverage.unmodifiableView();
    }

    public CountStatistic getLoad5MinuteAverage() {
        long load5MinuteAverage = (long)this.getBean().getLoad5MinuteAverage();
        this._load5MinuteAverage.setCount(load5MinuteAverage);
        return (CountStatistic)this._load5MinuteAverage.unmodifiableView();
    }

    public CountStatistic getLoad15MinuteAverage() {
        long load15MinuteAverage = (long)this.getBean().getLoad15MinuteAverage();
        this._load15MinuteAverage.setCount(load15MinuteAverage);
        return (CountStatistic)this._load15MinuteAverage.unmodifiableView();
    }

    public CountStatistic getRateBytesTransmitted() {
        long rateBytesTransmitted = (long)this.getBean().getRateBytesTransmitted();
        this._rateBytesTransmitted.setCount(rateBytesTransmitted);
        return (CountStatistic)this._rateBytesTransmitted.unmodifiableView();
    }

    public CountStatistic getRateBytesReceived() {
        long rateBytesReceived = (long)this.getBean().getRateBytesReceived();
        this._rateBytesReceived.setCount(rateBytesReceived);
        return (CountStatistic)this._rateBytesReceived.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this._gsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this._gsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this._gsImpl.getStatisticNames();
    }

    private HttpServiceMB getBean() {
        return this._bean;
    }

    private void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, "secondsRunning", "seconds", "Time since HttpService started", time, time);
        this._secondsRunning = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "ticksPerSecond", "ticks/second", "Number of ticks in a second", time, time);
        this._ticksPerSecond = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxThreads", "count", "Maximum amount of processing threads", time, time);
        this._maxThreads = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "MaxVirtualServers", "count", "Maximum amount of virtual servers tracked", time, time);
        this._maxVirtualServers = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "flagProfilingEnabled", "(0/1)", "Is profiling enabled?", time, time);
        this._flagProfilingEnabled = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "flagVirtualServerOverflow", "(0/1)", "More virtual servers than tracked?", time, time);
        this._flagVirtualServerOverflow = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "load1MinuteAverage", "count", "Average load for last 1 minute", time, time);
        this._load1MinuteAverage = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "load5MinuteAverage", "count", "Average load for last 5 minutes", time, time);
        this._load5MinuteAverage = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "load15MinuteAverage", "count", "Average load for last 15 minutes", time, time);
        this._load15MinuteAverage = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "rateBytesTransmitted", "bytes/second", "Rate at which bytes are being transmitted", time, time);
        this._rateBytesTransmitted = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "rateBytesReceived", "bytes/second", "Rate at which bytes are being received", time, time);
        this._rateBytesReceived = new MutableCountStatisticImpl((CountStatistic)cs);
        this._startTime = time;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

