/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.util.zip;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipInputStream;

public class Unzipper {
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.util");
    private static final int BUFFER_SIZE = 16384;
    private String _targetDirectory;
    private static StringManager _localStrMgr = StringManager.getManager((Class)Unzipper.class);

    public Unzipper(String targetDirectory) {
        this._targetDirectory = targetDirectory;
    }

    public long writeZipBytes(byte[] zipBytes) throws IOException {
        return this.writeZipInputStream(new ByteArrayInputStream(zipBytes));
    }

    public long writeZipFile(String zipFileName) throws IOException, FileNotFoundException {
        return this.writeZipInputStream(new FileInputStream(zipFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected long writeZipInputStream(InputStream in) throws IOException {
        block23: {
            zin = null;
            cis = null;
            out = null;
            buffer = new byte[16384];
            len = 0;
            file = null;
            parent = null;
            entry = null;
            try {
                cis = new CheckedInputStream(in, new CRC32());
                zin = new ZipInputStream(cis);
                entry = zin.getNextEntry();
                while (entry != null) {
                    fileName = this._targetDirectory + File.separator + entry.getName();
                    file = new File(fileName);
                    if (entry.isDirectory()) {
                        Unzipper._logger.fine("[Unzipper] Extracting directory: " + fileName);
                        if (!file.exists()) {
                            Unzipper._logger.fine("[Unzipper] Creating Directory: " + file);
                            Unzipper.safeMkDirs(file);
                        }
                    } else {
                        Unzipper._logger.fine("[Unzipper] Extracting file: " + fileName);
                        parent = file.getParentFile();
                        if (parent != null && !parent.exists()) {
                            Unzipper._logger.fine("[Unzipper] Creating Directory: " + parent);
                            Unzipper.safeMkDirs(parent);
                        }
                        out = null;
                        try {
                            out = new BufferedOutputStream(new FileOutputStream(fileName));
                            while ((len = zin.read(buffer, 0, 16384)) >= 0) {
                                out.write(buffer, 0, len);
                            }
                            out.close();
                            file.setLastModified(entry.getTime());
                            out = null;
                            var12_11 = null;
                            ** if (out == null) goto lbl-1000
                        }
                        catch (Throwable var11_13) {
                            var12_11 = null;
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            throw var11_13;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                out.close();
                            }
                            catch (Exception ex) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    zin.closeEntry();
                    entry = zin.getNextEntry();
                }
                zin.close();
                zin = null;
                var11_14 = cis.getChecksum().getValue();
                var15_15 = null;
                if (cis == null) break block23;
            }
            catch (Throwable var14_19) {
                block25: {
                    var15_16 = null;
                    if (cis != null) {
                        try {
                            cis.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (zin == null) break block25;
                    try {
                        zin.close();
                    }
                    catch (Exception ex) {}
                }
                throw var14_19;
            }
            try {
                cis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (zin != null) {
            try {
                zin.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return var11_14;
    }

    static synchronized void safeMkDirs(File dir) {
        boolean created = dir.mkdirs();
        if (!created && !dir.exists()) {
            String normalizedTmp;
            File safeDir;
            String tmp = dir.getPath();
            if (tmp.endsWith(File.separator + ".")) {
                tmp = tmp.substring(0, tmp.length() - 2);
            }
            if (!(created = (safeDir = new File(normalizedTmp = Unzipper.normalizePath(tmp))).mkdirs()) && !safeDir.exists()) {
                String msg = _localStrMgr.getString("DirNotCreated", (Object)normalizedTmp);
                throw new RuntimeException(msg);
            }
        }
    }

    public static void usage() {
        System.out.println("usage: zip-file-name directory-name");
        System.exit(1);
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 2) {
                Unzipper.usage();
            }
            Unzipper z = new Unzipper(argv[1]);
            z.writeZipFile(argv[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String normalizePath(String path) {
        if (path == null) {
            return path;
        }
        if (File.separatorChar == '\\') {
            if (path.indexOf(47) >= 0) {
                _logger.fine("[Unzipper] Path contains forward slash. Normalizing: " + path);
            }
            path = FileUtils.makeForwardSlashes((String)path);
            path = path.replaceAll("/\\./", "/");
            return path.replace('/', '\\');
        }
        path = FileUtils.makeForwardSlashes((String)path);
        return path.replaceAll(File.separator + "\\." + File.separator, File.separator);
    }
}

