/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.cleaner;

import com.sun.enterprise.ee.synchronization.JmxRequestMediator;
import com.sun.enterprise.ee.synchronization.cleaner.Cleaner;
import com.sun.enterprise.ee.synchronization.cleaner.CleanerUtils;
import com.sun.enterprise.ee.synchronization.cleaner.DirPruner;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroupRequestCleaner
implements Cleaner {
    private File _trash = null;
    private JmxRequestMediator[] _mediators = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    public GroupRequestCleaner(JmxRequestMediator[] mReqs) {
        this._mediators = mReqs;
        this._trash = CleanerUtils.getTemporaryTrash();
    }

    public void gc() {
        try {
            if (this._mediators == null || this._trash == null) {
                _logger.fine("Invalid argument. Mediator or trash is null.");
                return;
            }
            DirPruner[] pruners = CleanerUtils.getDirPruner(this._mediators, this._trash);
            for (int i = 0; i < pruners.length; ++i) {
                if (pruners[i] == null) continue;
                pruners[i].prune();
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error while cleaning directory", e);
        }
    }
}

