/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.cleaner;

import com.sun.enterprise.ee.synchronization.JmxRequestMediator;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.cleaner.CleanerConstants;
import com.sun.enterprise.ee.synchronization.cleaner.DirPruner;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Logger;

public class CleanerUtils {
    private static final String TRASH_FILE = ".com_sun_appserv_trash";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    public static boolean isExcluded(String file) {
        if (file == null) {
            return false;
        }
        String f = FileUtils.makeForwardSlashes((String)file);
        for (int i = 0; i < CleanerConstants.EXCLUDE_LIST.length; ++i) {
            String s = CleanerConstants.EXCLUDE_LIST[i];
            if (f.indexOf(s) == -1) continue;
            return true;
        }
        return false;
    }

    static File getMainTrash() {
        String iRoot = System.getProperty("com.sun.aas.instanceRoot");
        File trash = new File(iRoot + File.separator + "generated" + File.separator + TRASH_FILE);
        if (!trash.exists()) {
            trash.mkdirs();
            _logger.fine("Created main trash folder: " + trash.getPath());
        }
        return trash;
    }

    static File getTemporaryTrash() {
        File temp = CleanerUtils.getMainTrash();
        long ts = System.currentTimeMillis();
        File trash = new File(temp, Long.toString(ts));
        while (trash.exists()) {
            trash = new File(temp, Long.toString(++ts));
        }
        trash.mkdirs();
        _logger.fine("Created temporary trash folder: " + trash.getPath());
        return trash;
    }

    static DirPruner[] getDirPruner(JmxRequestMediator[] mReqs, File trash) {
        DirPruner[] pruners = null;
        if (mReqs == null || trash == null) {
            return null;
        }
        pruners = new DirPruner[mReqs.length];
        for (int i = 0; i < pruners.length; ++i) {
            SynchronizationResponse res = mReqs[i].getResponse();
            SynchronizationRequest[] reqs = res.getReply();
            if (reqs[0] == null) continue;
            String baseDir = reqs[0].getBaseDirectory();
            String targetDir = reqs[0].getTargetDirectory();
            File reqDir = new File(baseDir + File.separator + targetDir);
            pruners[i] = new DirPruner(reqDir, trash, mReqs[i].getCRInventory());
        }
        return pruners;
    }
}

