/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.audit;

import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.TimestampRemoveCommand;
import com.sun.enterprise.ee.synchronization.audit.AuditException;
import com.sun.enterprise.ee.synchronization.audit.AuditGetCommand;
import com.sun.enterprise.ee.synchronization.audit.AuditReport;
import com.sun.enterprise.ee.synchronization.audit.RequestAuditor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.List;
import java.util.logging.Logger;

public class AuditMgr {
    private static final String AUDIT_KEY = "com.sun.appserv.synchronization.audit";
    private SynchronizationRequest[] _requests = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private static final StringManager _localStrMgr = StringManager.getManager((Class)AuditMgr.class);

    public AuditMgr(SynchronizationRequest[] requests) {
        this._requests = requests;
    }

    public void auditServer(DASPropertyReader dasProperties) throws AuditException {
        try {
            if (!this.isAuditON()) {
                return;
            }
            MBeanServerConnectionInfo connInfo = new MBeanServerConnectionInfo(dasProperties);
            AuditGetCommand aCommand = new AuditGetCommand(this._requests, connInfo);
            aCommand.execute();
            SynchronizationResponse response = (SynchronizationResponse)aCommand.getResult();
            List auditList = response.getFileList();
            RequestAuditor ra = new RequestAuditor(response);
            ra.audit();
            AuditReport aReport = new AuditReport(response, ra.getMissingList(), ra.getExtraList());
            aReport.report();
            if (aReport.isAuditFailed()) {
                this.removeTS();
            }
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("serverAuditError");
            throw new AuditException(msg, e);
        }
    }

    private void removeTS() {
        for (int i = 0; i < this._requests.length; ++i) {
            try {
                TimestampRemoveCommand trc = new TimestampRemoveCommand(this._requests[i], null);
                trc.execute();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SynchronizationRequest[] getRequests() {
        return this._requests;
    }

    private boolean isAuditON() {
        return Boolean.getBoolean(AUDIT_KEY);
    }
}

