/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.api;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.api.SynchronizationClient;
import com.sun.enterprise.ee.synchronization.api.SynchronizationContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.Constructor;

public class SynchronizationFactory {
    private static final String SYNCHRONIZATION_CONTEXT_IMPL = "com.sun.enterprise.ee.synchronization.impl.SynchronizationContextImpl";
    private static final String SYNCHRONIZATION_CLIENT_IMPL = "com.sun.enterprise.ee.synchronization.impl.SynchronizationClientImpl";
    private static final StringManager _localStrMgr = StringManager.getManager((Class)SynchronizationFactory.class);

    public static SynchronizationContext createSynchronizationContext(ConfigContext ctx) throws SynchronizationException {
        SynchronizationContext sCtx = null;
        try {
            Class<?> c = Class.forName(SYNCHRONIZATION_CONTEXT_IMPL);
            sCtx = (SynchronizationContext)c.newInstance();
            sCtx.setConfigContext(ctx);
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("SynchCtxCreationError");
            throw new SynchronizationException(msg, e);
        }
        return sCtx;
    }

    public static SynchronizationClient createSynchronizationClient(String remoteServerName) throws SynchronizationException {
        SynchronizationClient client = null;
        try {
            Class<?> c = Class.forName(SYNCHRONIZATION_CLIENT_IMPL);
            Constructor<?> constructor = c.getConstructor(String.class);
            client = (SynchronizationClient)constructor.newInstance(remoteServerName);
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("SynchClientCreationError");
            throw new SynchronizationException(msg, e);
        }
        return client;
    }
}

