/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

class TimestampCommand
implements Command {
    private static Logger _logger;
    private static final StringManagerBase _logStrMgr;
    private static final StringManager _localStrMgr;
    private SynchronizationRequest _request = null;
    private SynchronizationResponse _response = null;
    private static final String NAME = "Synchronization-Timestamp-Command";
    static final /* synthetic */ boolean $assertionsDisabled;

    TimestampCommand(SynchronizationRequest req, SynchronizationResponse res) {
        this._request = req;
        this._response = res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws SynchronizationException {
        try {
            File parentDir;
            File cacheTSFile;
            long startTime;
            block17: {
                startTime = this._response.getSynchronizationStartTime();
                cacheTSFile = this._request.getCacheTimestampFile();
                if (!$assertionsDisabled && cacheTSFile == null) {
                    throw new AssertionError();
                }
                parentDir = cacheTSFile.getParentFile();
                if (cacheTSFile.exists()) {
                    BufferedReader is = null;
                    try {
                        is = new BufferedReader(new FileReader(cacheTSFile));
                        long lastModifiedTime = Long.parseLong(is.readLine());
                        is.close();
                        is = null;
                        if (startTime < lastModifiedTime) {
                            String msg = _localStrMgr.getString("invalidSynchronizationTS", (Object)cacheTSFile.getPath(), (Object)Long.toString(startTime), (Object)Long.toString(lastModifiedTime));
                            throw new SynchronizationException(msg);
                        }
                        Object var10_8 = null;
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (Exception e) {}
                    is.close();
                } else {
                    cacheTSFile.getParentFile().mkdirs();
                }
            }
            if (!parentDir.exists()) {
                _logger.log(Level.FINE, _logStrMgr.getString("synchronization.ts_exists", (Object)cacheTSFile.getPath()));
                return;
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(cacheTSFile);
                fw.write(Long.toString(startTime));
                fw.flush();
                fw.close();
                fw = null;
                _logger.log(Level.FINE, _logStrMgr.getString("synchronization.ts_created", (Object)cacheTSFile.getPath()));
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {
                return;
            }
            if (fw == null) return;
            fw.close();
            return;
        }
        catch (Exception e) {
            _logger.log(Level.FINE, _logStrMgr.getString("synchronization.ts_not_created", (Object)this._request.getMetaFileName()));
            String msg = _localStrMgr.getString("updateTimestampError", (Object)this._request.getMetaFileName());
            throw new SynchronizationException(msg, e);
        }
    }

    public String getName() {
        return NAME;
    }

    public Object getResult() {
        return null;
    }

    static {
        $assertionsDisabled = !TimestampCommand.class.desiredAssertionStatus();
        _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
        _logStrMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
        _localStrMgr = StringManager.getManager((Class)TimestampCommand.class);
    }
}

