/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.TextProcess;
import com.sun.enterprise.ee.synchronization.inventory.InventoryMgr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SynchronizationConfig {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    public static final String INSTANCE_CONFIG_URL = "synchronization-meta-data.xml";
    public static final String NODEAGT_CONFIG_URL = "na-synchronization-meta-data.xml";
    public static final String NODEAGT_STARTUP_CONFIG_URL = "na-startup-meta-data.xml";
    protected Document configDoc;
    protected NodeList maps;
    private static String serverName = null;

    public SynchronizationConfig(String xmlFile) {
        this(xmlFile, null);
    }

    public SynchronizationConfig(String xmlFile, String sName) {
        serverName = sName == null ? System.getProperty("com.sun.aas.instanceName") : sName;
        try {
            this.configDoc = this.readConfiguration(xmlFile);
        }
        catch (MalformedURLException e) {
            _logger.log(Level.SEVERE, "synchronization.malformed_xml", new Object[]{xmlFile, e.getLocalizedMessage()});
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "synchronization.config.io_exception", new Object[]{xmlFile, e.getLocalizedMessage()});
        }
        NodeList mappings = this.configDoc.getElementsByTagName("mappings");
        Element e = (Element)mappings.item(0);
        this.maps = e.getElementsByTagName("mapping");
    }

    private Document readConfiguration(String url) throws IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream in = ClassLoader.getSystemResourceAsStream(url);
            doc = docBuilder.parse(in);
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            _logger.log(Level.SEVERE, "synchronization.parser_config_exception", e.getLocalizedMessage());
        }
        catch (SAXParseException e) {
            _logger.log(Level.SEVERE, "synchronization.sax_parse_exception", new Object[]{new Integer(e.getLineNumber()), e.getSystemId(), e.getLocalizedMessage()});
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        return doc;
    }

    int getSyncCount() {
        return this.maps.getLength();
    }

    String getAttrInternal(int i, String attr) {
        Element mapping = (Element)this.maps.item(i);
        String val = mapping.getAttribute(attr).trim();
        return val;
    }

    String getNextSource(int i) {
        return this.getAttrInternal(i, "source");
    }

    String getNextBaseDir(int i) {
        return this.getAttrInternal(i, "basedir");
    }

    String getNextSrcTimestampFile(int i) {
        return this.getAttrInternal(i, "src-timestamp-file");
    }

    String getNextDestTimestampFile(int i) {
        return this.getAttrInternal(i, "dest-timestamp-file");
    }

    String getNextDestination(int i) {
        return this.getAttrInternal(i, "destination");
    }

    String getNextExclude(int i) {
        return this.getAttrInternal(i, "exclude");
    }

    String getNextGCEnabled(int i) {
        return this.getAttrInternal(i, "gc-enabled");
    }

    String getNextShallowCopyEnabled(int i) {
        return this.getAttrInternal(i, "shallow-copy-enabled");
    }

    int getNextTimestampType(int i) {
        Element mapping = (Element)this.maps.item(i);
        String val = mapping.getAttribute("timestamp-type").trim();
        if (val.compareTo("none") == 0) {
            return 2;
        }
        if (val.compareTo("modification-time") == 0) {
            return 1;
        }
        if (val.compareTo("modified-since") == 0) {
            return 3;
        }
        if (val.compareTo("file") == 0) {
            return 0;
        }
        return -1;
    }

    List getListInternal(int i, String element, String attr) {
        ArrayList<String> list = new ArrayList<String>();
        Element mapping = (Element)this.maps.item(i);
        NodeList patterns = mapping.getElementsByTagName(element);
        int length = patterns.getLength();
        for (int idx = 0; idx < length; ++idx) {
            Element e = (Element)patterns.item(idx);
            String val = e.getAttribute(attr);
            list.add(val.trim());
        }
        return list;
    }

    List getExcludePatternList(int i) {
        return this.getListInternal(i, "exclude-pattern", "regular-expression");
    }

    List getIncludePatternList(int i) {
        return this.getListInternal(i, "include-pattern", "regular-expression");
    }

    List getClientRepositoryInfoList(int i) {
        return this.getListInternal(i, "client-repository-info", "path");
    }

    Set processClientRepositoryInfo(List list, String server, Properties env) {
        HashSet<String> criSet = new HashSet<String>();
        if (list != null) {
            int cnt = list.size();
            for (int i = 0; i < cnt; ++i) {
                String f = TextProcess.tokenizeConfig((String)list.get(i), server, env);
                File dir = new File(f);
                String[] fileNames = dir.list();
                if (fileNames == null) continue;
                for (int j = 0; j < fileNames.length; ++j) {
                    criSet.add(fileNames[j]);
                }
            }
        }
        return criSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SynchronizationRequest[] getSyncRequests() {
        requests = new SynchronizationRequest[this.getSyncCount()];
        is = null;
        modifiedTime = 0L;
        for (i = 0; i < this.getSyncCount(); ++i) {
            block14: {
                modifiedTime = 0L;
                destTimestampFile = null;
                tempEnv = new Properties();
                try {
                    block13: {
                        destTimestampFile = TextProcess.tokenizeConfig(this.getNextDestTimestampFile(i), SynchronizationConfig.serverName, tempEnv);
                        if (destTimestampFile == null) break block13;
                        is = new BufferedReader(new FileReader(new File(destTimestampFile)));
                        modifiedTime = Long.parseLong(is.readLine());
                        is.close();
                        is = null;
                    }
                    var10_11 = null;
                    ** if (is == null) goto lbl-1000
                }
                catch (Throwable var9_10) {
                    var10_11 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var9_10;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                    catch (Exception e) {
                        SynchronizationConfig._logger.log(Level.FINE, "synchronization.timestamp_exception", new Object[]{destTimestampFile, e.getLocalizedMessage()});
                        var10_11 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
            requests[i] = new SynchronizationRequest(this.getNextSource(i), this.getNextDestination(i), modifiedTime, this.getNextTimestampType(i), this.getNextSrcTimestampFile(i));
            env = requests[i].getEnvironmentProperties();
            env.putAll((Map<?, ?>)tempEnv);
            requests[i].setServerName(SynchronizationConfig.serverName);
            requests[i].setCacheTimestampFile(destTimestampFile);
            base = TextProcess.tokenizeConfig(this.getNextBaseDir(i), SynchronizationConfig.serverName, env);
            requests[i].setBaseDirectory(base);
            exclude = this.getNextExclude(i);
            requests[i].setExclude(Boolean.valueOf(exclude));
            gcEnabled = this.getNextGCEnabled(i);
            enabled = Boolean.valueOf(gcEnabled);
            requests[i].setGCEnabled(enabled);
            if (enabled && (f = requests[i].getFile()).exists()) {
                mgr = new InventoryMgr(f);
                list = mgr.getInventory();
                requests[i].setInventory(list);
            }
            eList = this.getExcludePatternList(i);
            requests[i].addToExcludePatternList(eList);
            sCopyEnabled = this.getNextShallowCopyEnabled(i);
            scEnabled = Boolean.valueOf(sCopyEnabled);
            requests[i].setShallowCopyEnabled(scEnabled);
            iList = this.getIncludePatternList(i);
            requests[i].addToIncludePatternList(iList);
            criList = this.getClientRepositoryInfoList(i);
            if (criList == null || criList.size() <= 0 || (criSet = this.processClientRepositoryInfo(criList, SynchronizationConfig.serverName, env)) == null || criSet.size() <= 0) continue;
            requests[i].addToClientRepositoryInfo(criSet);
        }
        return requests;
    }
}

