/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.synchronization.ApplicationSynchRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.inventory.InventoryMgr;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RequestBuilderBase {
    private ConfigContext _configCtx = null;
    private String _serverName = null;
    String OPEN_PROP = "${";
    String CLOSE_PROP = "}";
    private String TIMESTAMP_EXT = ".com_sun_appserv_timestamp";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    public RequestBuilderBase(ConfigContext ctx, String serverName) {
        this._configCtx = ctx;
        this._serverName = serverName;
    }

    abstract String getApplicationName(ConfigBean var1);

    public ApplicationSynchRequest build(ConfigBean cb) {
        ApplicationSynchRequest asr = new ApplicationSynchRequest();
        SynchronizationRequest sr = this.buildPolicyDir(cb);
        asr.setPolicyRequest(sr);
        sr = this.buildAppDir(cb);
        asr.setApplicationRequest(sr);
        sr = this.buildXmlDir(cb);
        asr.setXMLRequest(sr);
        return asr;
    }

    SynchronizationRequest buildRequest(String src) {
        SynchronizationRequest sr = null;
        String dest = ".";
        String tsFile = src + File.separator + this.TIMESTAMP_EXT;
        Object is = null;
        long modTime = 0L;
        Properties tempEnv = new Properties();
        sr = new SynchronizationRequest(src, dest, modTime, 3, null);
        Properties env = sr.getEnvironmentProperties();
        env.putAll((Map<?, ?>)tempEnv);
        sr.setServerName(this._serverName);
        sr.setCacheTimestampFile(tsFile);
        sr.setBaseDirectory(src);
        try {
            InventoryMgr mgr;
            List list;
            File f = sr.getFile();
            if (f.isDirectory() && (list = (mgr = new InventoryMgr(f)).getInventory()) != null) {
                sr.setInventory(list);
                sr.setGCEnabled(true);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error while setting GC enabled", e);
        }
        return sr;
    }

    String getPolicyDir(ConfigBean cb) {
        String src = this.OPEN_PROP + "com.sun.aas.instanceRoot" + this.CLOSE_PROP + File.separator + "generated" + File.separator + "policy" + File.separator + this.getApplicationName(cb);
        return src;
    }

    SynchronizationRequest buildPolicyDir(ConfigBean cb) {
        return this.buildRequest(this.getPolicyDir(cb));
    }

    String getJspDir(ConfigBean cb, String appOrModule) {
        String src = this.OPEN_PROP + "com.sun.aas.instanceRoot" + this.CLOSE_PROP + File.separator + "generated" + File.separator + "jsp" + File.separator + appOrModule + File.separator + this.getApplicationName(cb);
        return src;
    }

    SynchronizationRequest buildJspDir(ConfigBean cb, String appOrModule) {
        return this.buildRequest(this.getJspDir(cb, appOrModule));
    }

    String getEjbDir(ConfigBean cb, String appOrModule) {
        String src = this.OPEN_PROP + "com.sun.aas.instanceRoot" + this.CLOSE_PROP + File.separator + "generated" + File.separator + "ejb" + File.separator + appOrModule + File.separator + this.getApplicationName(cb);
        return src;
    }

    SynchronizationRequest buildEjbDir(ConfigBean cb, String appOrModule) {
        return this.buildRequest(this.getEjbDir(cb, appOrModule));
    }

    String getXmlDir(ConfigBean cb, String appOrModule) {
        String src = this.OPEN_PROP + "com.sun.aas.instanceRoot" + this.CLOSE_PROP + File.separator + "generated" + File.separator + "xml" + File.separator + appOrModule + File.separator + this.getApplicationName(cb);
        return src;
    }

    SynchronizationRequest buildXmlDir(ConfigBean cb, String appOrModule) {
        return this.buildRequest(this.getXmlDir(cb, appOrModule));
    }

    abstract SynchronizationRequest buildAppDir(ConfigBean var1);

    abstract SynchronizationRequest buildJspDir(ConfigBean var1);

    abstract SynchronizationRequest buildEjbDir(ConfigBean var1);

    abstract SynchronizationRequest buildXmlDir(ConfigBean var1);
}

