/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.admin.server.core.channel.RRStateFactory;
import com.sun.enterprise.admin.server.core.jmx.ssl.AsTlsClientEnvSetter;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import com.sun.enterprise.ee.synchronization.ApplicationSynchRequest;
import com.sun.enterprise.ee.synchronization.DASCommunicationException;
import com.sun.enterprise.ee.synchronization.JmxRequestMediator;
import com.sun.enterprise.ee.synchronization.PingCommand;
import com.sun.enterprise.ee.synchronization.SynchronizationConfig;
import com.sun.enterprise.ee.synchronization.SynchronizationDriver;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationPingResponse;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.audit.AuditException;
import com.sun.enterprise.ee.synchronization.audit.AuditMgr;
import com.sun.enterprise.ee.synchronization.cleaner.CacheRepositoryCleanerMain;
import com.sun.enterprise.ee.synchronization.tx.Transaction;
import com.sun.enterprise.ee.synchronization.tx.TransactionManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmxSynchronizationDriver
implements SynchronizationDriver {
    private static Logger _logger;
    private static final StringManager _localStrMgr;
    private String _metaFile = null;
    private String _instanceRoot = null;
    private static final int MAJOR_VERSION = 8;
    private static final int MINOR_VERSION = 1;
    private static final String THREAD_NAME = "sync-";
    static final /* synthetic */ boolean $assertionsDisabled;

    public JmxSynchronizationDriver(String root, String xml) {
        this._instanceRoot = root;
        this._metaFile = xml;
    }

    public boolean acceptsURL(String url) {
        return "synchronization-meta-data.xml".equals(url) || "na-synchronization-meta-data.xml".equals(url) || "na-startup-meta-data.xml".equals(url);
    }

    public int getMajorVersion() {
        return 8;
    }

    public int getMinorVersion() {
        return 1;
    }

    public void synchronize() throws SynchronizationException {
        try {
            this.synchronizeInternal();
        }
        catch (DASCommunicationException dce) {
            throw dce;
        }
        catch (SynchronizationException e) {
            _logger.log(Level.FINE, "synchronization.retry_synchronization");
            this.synchronizeInternal();
        }
    }

    private void synchronizeInternal() throws SynchronizationException {
        block14: {
            long b = System.currentTimeMillis();
            try {
                TransactionManager txMgr = TransactionManager.getTransactionManager();
                DASPropertyReader dpr = new DASPropertyReader(new InstanceConfig());
                dpr.read();
                if (Boolean.valueOf(dpr.isDASSecure()).booleanValue()) {
                    new AsTlsClientEnvSetter().setup();
                }
                PingCommand pc = new PingCommand(dpr);
                pc.execute();
                if (pc.isAlive()) {
                    int i;
                    SynchronizationRequest[] reqs = this.getAllRequests(pc);
                    if (!$assertionsDisabled && reqs.length == 0) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && dpr == null) {
                        throw new AssertionError();
                    }
                    Transaction tx = txMgr.begin(reqs.length);
                    JmxRequestMediator[] mReqs = new JmxRequestMediator[reqs.length];
                    Thread[] reqThreads = new Thread[reqs.length];
                    for (i = 0; i < reqs.length; ++i) {
                        mReqs[i] = new JmxRequestMediator(dpr, reqs[i], tx);
                        reqThreads[i] = new Thread((Runnable)mReqs[i], THREAD_NAME + i);
                        reqThreads[i].start();
                    }
                    for (i = 0; i < reqThreads.length; ++i) {
                        reqThreads[i].join();
                    }
                    for (i = 0; i < reqThreads.length; ++i) {
                        if (mReqs[i].isException()) {
                            throw mReqs[i].getException();
                        }
                        _logger.log(Level.FINE, "synchronization.done_request", mReqs[i].getRequest().getMetaFileName());
                    }
                    long a = System.currentTimeMillis();
                    _logger.log(Level.INFO, "synchronization.time_taken", new Long(a - b).toString());
                    if ("synchronization-meta-data.xml".equals(this._metaFile)) {
                        long cb = System.currentTimeMillis();
                        CacheRepositoryCleanerMain cleanerMain = CacheRepositoryCleanerMain.getInstance();
                        cleanerMain.run(mReqs);
                        RRStateFactory.removeStateFile();
                        long ca = System.currentTimeMillis();
                        _logger.log(Level.INFO, "synchronization.cleaner.time_taken", new Long(ca - cb).toString());
                        try {
                            AuditMgr aMgr = new AuditMgr(reqs);
                            aMgr.auditServer(dpr);
                        }
                        catch (AuditException aEx) {
                            _logger.log(Level.SEVERE, "synchronization.audit_fail", aEx);
                        }
                    }
                    break block14;
                }
                _logger.log(Level.INFO, "synchronization.skipping_synchronization");
                String msg = _localStrMgr.getString("dasCommunicationError");
                throw new DASCommunicationException(msg);
            }
            catch (DASCommunicationException dce) {
                throw dce;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "synchronization.sync_fail", e);
                throw new SynchronizationException(e);
            }
        }
    }

    private SynchronizationRequest[] getAllRequests(PingCommand pc) throws IOException {
        SynchronizationRequest[] reqs = this.getRequests();
        ArrayList<SynchronizationRequest> list = new ArrayList<SynchronizationRequest>();
        list.addAll(Arrays.asList(reqs));
        SynchronizationPingResponse pingResponse = (SynchronizationPingResponse)pc.getResult();
        if (pingResponse != null) {
            List appReqs = pingResponse.getApplicationSynchRequests();
            Iterator iter = appReqs.iterator();
            while (iter.hasNext()) {
                ApplicationSynchRequest aReq = (ApplicationSynchRequest)iter.next();
                list.addAll(aReq.toSynchronizationRequest());
            }
        }
        SynchronizationRequest[] allReqs = new SynchronizationRequest[list.size()];
        return list.toArray(allReqs);
    }

    private SynchronizationRequest[] getRequests() throws IOException {
        if (!$assertionsDisabled && this._metaFile == null) {
            throw new AssertionError();
        }
        SynchronizationConfig sConfig = new SynchronizationConfig(this._metaFile);
        SynchronizationRequest[] requests = sConfig.getSyncRequests();
        return requests;
    }

    static {
        $assertionsDisabled = !JmxSynchronizationDriver.class.desiredAssertionStatus();
        _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
        _localStrMgr = StringManager.getManager((Class)JmxSynchronizationDriver.class);
    }
}

