/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.JmxGetCommand;
import com.sun.enterprise.ee.synchronization.ResponseProcessCommand;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.TimestampCommand;
import com.sun.enterprise.ee.synchronization.TimestampRemoveCommand;
import com.sun.enterprise.ee.synchronization.store.StoreException;
import com.sun.enterprise.ee.synchronization.store.SynchronizationMemento;
import com.sun.enterprise.ee.synchronization.tx.Transaction;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmxRequestMediator
implements Runnable {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private SynchronizationRequest _request = null;
    private Exception _exception = null;
    private DASPropertyReader _dasProperties = null;
    private boolean _isException = false;
    private Transaction _tx = null;
    private SynchronizationResponse _response = null;
    private SynchronizationMemento _memento = null;

    JmxRequestMediator(DASPropertyReader p, SynchronizationRequest req, Transaction tx) {
        this._request = req;
        this._dasProperties = p;
        this._tx = tx;
    }

    SynchronizationMemento getMemento() {
        return this._memento;
    }

    void execute() throws Exception {
        MBeanServerConnectionInfo connInfo = new MBeanServerConnectionInfo(this._dasProperties);
        JmxGetCommand cGet = new JmxGetCommand(this._request, connInfo);
        cGet.execute();
        this._response = (SynchronizationResponse)cGet.getResult();
        this._memento = new SynchronizationMemento(this._response);
        this._memento.saveState();
        ResponseProcessCommand cProcess = new ResponseProcessCommand(this._request, this._response);
        cProcess.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.execute();
            this._tx.voteCommit();
            _logger.log(Level.FINE, _strMgr.getString("synchronization.vote_commit", (Object)this._request.getMetaFileName()));
        }
        catch (Exception e) {
            this._tx.voteRollback();
            _logger.log(Level.INFO, _strMgr.getString("synchronization.vote_rollback", (Object)this._request.getMetaFileName()));
            this._exception = e;
            this._isException = true;
        }
        finally {
            this.commit();
        }
    }

    void commit() {
        if (this._tx.isCommited()) {
            try {
                if (this._memento != null) {
                    this._memento.commit();
                }
                _logger.log(Level.FINE, _strMgr.getString("synchronization.tran_commit", (Object)this._request.getMetaFileName()));
            }
            catch (StoreException se) {
                _logger.log(Level.INFO, _strMgr.getString("synchronization.store_commit_error"), se);
            }
            try {
                TimestampCommand cTimestamp = new TimestampCommand(this._request, this._response);
                cTimestamp.execute();
            }
            catch (SynchronizationException e) {
                _logger.log(Level.INFO, _strMgr.getString("synchronization.timestamp_command_error"), e);
            }
        } else {
            try {
                if (this._memento != null) {
                    this._memento.rollback();
                }
            }
            catch (StoreException se) {
                se.printStackTrace();
                _logger.log(Level.INFO, _strMgr.getString("synchronization.store_rollback_error"), se);
            }
            try {
                TimestampRemoveCommand cTSRemove = new TimestampRemoveCommand(this._request, this._response);
                cTSRemove.execute();
            }
            catch (SynchronizationException e) {
                _logger.log(Level.INFO, _strMgr.getString("synchronization.timestamp_command_error"), e);
            }
        }
    }

    int getStatusCode() {
        int status = 1;
        if (!this.isException()) {
            status = 0;
        }
        return status;
    }

    boolean isException() {
        return this._isException;
    }

    Exception getException() {
        return this._exception;
    }

    public SynchronizationRequest getRequest() {
        return this._request;
    }

    public SynchronizationResponse getResponse() {
        return this._response;
    }

    File getRequestDir() {
        File reqDir = null;
        try {
            String file;
            File f;
            SynchronizationRequest[] reqs;
            if (this._response != null && (reqs = this._response.getReply())[0] != null && (f = new File(file = reqs[0].getFileName())).isDirectory()) {
                reqDir = f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reqDir;
    }

    public List getCRInventory() {
        List crList = null;
        try {
            SynchronizationRequest[] reqs;
            if (this._response != null && (reqs = this._response.getReply())[0] != null) {
                crList = reqs[0].getInventory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crList;
    }
}

