/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.quorum.core;

import com.sun.enterprise.ee.quorum.core.MemberException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Member {
    private String host = null;
    private int port;
    private String name = null;
    private String memberId = null;
    private Hashtable fencedMembers;
    private String operationalState;

    public Member(String host, int port, String name, String memberId) {
        this.host = host;
        this.port = port;
        this.name = name;
        this.memberId = memberId;
        this.fencedMembers = new Hashtable();
    }

    public void setOperationalState(String state, Member fencedMember) {
        this.fencedMembers.put(fencedMember, state);
    }

    public void removeFencedMember(Member m) throws MemberException {
        String state = (String)this.fencedMembers.get(m);
        if (!state.equals("MEMBER_STATE_TRANSFER_COMPLETE")) {
            throw new MemberException("Fenced Member cannot be removed as statetransfer is not complete");
        }
        this.fencedMembers.remove(m);
    }

    public Enumeration getFencedMembers() {
        return this.fencedMembers.keys();
    }

    public boolean isMemberFenced(Member m) {
        return this.fencedMembers.containsKey(m);
    }

    public String getFencedMemberState(Member m) {
        return (String)this.fencedMembers.get(m);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setGroup(String groupName) {
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + "]";
    }
}

