/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.ActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationAction;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.core.FailureRecoveryAction;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignalImpl;
import com.sun.enterprise.ee.cms.core.MessageAction;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.MessageSignalImpl;
import com.sun.enterprise.ee.cms.core.QueueHelper;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalHandler;
import com.sun.enterprise.ee.cms.core.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Router {
    private static Vector failureNotificationAF = new Vector();
    private static Vector failureRecoveryAF = new Vector();
    private static Vector messageAF = new Vector();
    QueueHelper queHelper;
    Logger logger = GMSLogDomain.getLogger((String)"javax.ee.enterprise.system.gms");

    Router() {
        this.queHelper = new QueueHelper();
        SignalHandler signalHandler = new SignalHandler(this.queHelper);
        new Thread(signalHandler).start();
    }

    void addDestinations(Collection actionFactories) {
        this.docketDestinations(actionFactories);
    }

    void addDestination(ActionFactory actionFactory) {
        this.docketDestination(actionFactory);
    }

    void removeDestinations(Collection actionFactories) {
        this.undocketDestinations(actionFactories);
    }

    void removeDestination(ActionFactory actionFactory) {
        this.undocketDestination(actionFactory);
    }

    void queueSignals(SignalPacket signalPacket) {
        this.queHelper.put(signalPacket);
    }

    void queueSignal(SignalPacket signalPacket) {
        this.queHelper.put(signalPacket);
    }

    private void docketDestinations(Collection actionFactories) {
        Iterator i = actionFactories.iterator();
        while (i.hasNext()) {
            this.docketDestination(i.next());
        }
    }

    private void docketDestination(Object actionFactory) {
        if (actionFactory instanceof FailureNotificationActionFactory) {
            failureNotificationAF.add(actionFactory);
        } else if (actionFactory instanceof FailureRecoveryActionFactory) {
            failureRecoveryAF.add(actionFactory);
        } else if (actionFactory instanceof MessageActionFactory) {
            messageAF.add(actionFactory);
        }
    }

    private void undocketDestinations(Collection actionFactories) {
        Iterator i = actionFactories.iterator();
        while (i.hasNext()) {
            this.undocketDestination(i.next());
        }
    }

    private void undocketDestination(Object actionFactory) {
        if (actionFactory instanceof FailureNotificationActionFactory) {
            failureNotificationAF.remove(actionFactory);
        } else if (actionFactory instanceof FailureRecoveryActionFactory) {
            failureRecoveryAF.remove(actionFactory);
        } else if (actionFactory instanceof MessageActionFactory) {
            messageAF.remove(actionFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undocketAllDestinations() {
        Vector vector = failureRecoveryAF;
        synchronized (vector) {
            failureRecoveryAF.removeAllElements();
        }
        vector = failureNotificationAF;
        synchronized (vector) {
            failureNotificationAF.removeAllElements();
        }
        vector = messageAF;
        synchronized (vector) {
            messageAF.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureNotificationAction(Signal signal) {
        this.logger.log(Level.FINE, "Sending FailureNotificationSignals to registered Actions...");
        Vector vector = failureNotificationAF;
        synchronized (vector) {
            Iterator i = failureNotificationAF.iterator();
            while (i.hasNext()) {
                FailureNotificationAction a = (FailureNotificationAction)((FailureNotificationActionFactory)i.next()).produceAction();
                this.callAction(a, new FailureNotificationSignalImpl((FailureNotificationSignalImpl)signal));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFailureRecoveryAction(Signal signal) {
        this.logger.log(Level.FINE, "Sending FailureRecoveryNotifications to registered Actions...");
        Vector vector = failureRecoveryAF;
        synchronized (vector) {
            Iterator i = failureRecoveryAF.iterator();
            while (i.hasNext()) {
                FailureRecoveryAction a = (FailureRecoveryAction)((FailureRecoveryActionFactory)i.next()).produceAction();
                this.callAction(a, new FailureRecoverySignalImpl((FailureRecoverySignalImpl)signal));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyMessageAction(Signal signal) {
        Vector vector = messageAF;
        synchronized (vector) {
            Iterator i = messageAF.iterator();
            while (i.hasNext()) {
                MessageAction a = (MessageAction)((MessageActionFactory)i.next()).produceAction();
                this.callAction(a, new MessageSignalImpl((MessageSignalImpl)signal));
            }
        }
    }

    private void callAction(Action a, Signal signal) {
        try {
            a.consumeSignal(signal);
        }
        catch (ActionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFailureNotificationAFRegistered() {
        boolean retval = true;
        Vector vector = failureNotificationAF;
        synchronized (vector) {
            if (failureNotificationAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFailureRecoveryAFRegistered() {
        boolean retval = true;
        Vector vector = failureRecoveryAF;
        synchronized (vector) {
            if (failureRecoveryAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMessageAFRegistered() {
        boolean retval = true;
        Vector vector = messageAF;
        synchronized (vector) {
            if (messageAF.isEmpty()) {
                retval = false;
            }
        }
        return retval;
    }
}

