/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.ActionFactory;
import com.sun.enterprise.ee.cms.core.DoorManager;
import com.sun.enterprise.ee.cms.core.GMSConfig;
import com.sun.enterprise.ee.cms.core.GMSContext;
import com.sun.enterprise.ee.cms.core.GMSContextFactory;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.Router;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.RspList;

public class GroupManagementServiceImpl
implements GroupManagementService,
Runnable {
    final String serverToken;
    final GMSContext ctx;
    IpAddress failedMember;
    String failedMemToken = null;
    DoorManager doorManager;
    private Router router;
    private static final Logger logger = GMSLogDomain.getLogger((String)"javax.ee.enterprise.system.gms");

    public GroupManagementServiceImpl(Collection actionFactories, String serverToken) {
        this.ctx = GMSContextFactory.produceGMSContext(serverToken, this);
        this.router = this.ctx.getRouter();
        this.serverToken = serverToken;
        this.router.addDestinations(actionFactories);
        this.doorManager = new DoorManager();
    }

    public GroupManagementServiceImpl(String serverToken) {
        this.ctx = GMSContextFactory.produceGMSContext(serverToken, this);
        this.router = this.ctx.getRouter();
        this.serverToken = serverToken;
        this.doorManager = new DoorManager();
    }

    public void run() {
    }

    public void addActionFactories(Collection actionFactories) {
        this.router.addDestinations(actionFactories);
    }

    public void addActionFactory(ActionFactory actionFactory) {
        this.router.addDestination(actionFactory);
    }

    public void removeActionFactories(Collection actionFactories) {
        this.router.removeDestinations(actionFactories);
    }

    public void removeActionFactory(ActionFactory actionFactory) {
        this.router.removeDestination(actionFactory);
    }

    public GroupHandle getGroupHandle() {
        return this.ctx.getGroupHandle();
    }

    public void startup() {
        if (this.isOkayToJoin()) {
            try {
                logger.log(Level.FINE, "gms.joinMessage");
                this.join();
            }
            catch (Exception e) {
                logger.log(Level.FINE, "gms.joinException", e);
            }
        }
    }

    public void shutdown() {
        this.leave();
    }

    private boolean isOkayToJoin() {
        if (!this.doorManager.isOpen()) {
            this.waitForOpen(3000L);
        }
        return true;
    }

    private void waitForOpen(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            logger.log(Level.FINE, e.getLocalizedMessage());
        }
        this.isOkayToJoin();
    }

    private void join() throws GMSException {
        logger.log(Level.FINE, "Connecting to group......");
        try {
            GMSConfig cfg = new GMSConfig();
            this.ctx.getMembershipChannel().connect(cfg.getGroupName());
            this.ctx.createPullPushAdapter();
            this.ctx.createRPCDispatcher();
            logger.log(Level.FINE, "Member " + this.serverToken + " joined group by name: " + this.ctx.getMembershipChannel().getChannelName());
        }
        catch (Exception e) {
            throw new GMSException("Member " + this.serverToken + " did not succeed in joining the group.", e);
        }
    }

    private void leave() {
        logger.log(Level.FINE, "Deregistering ActionFactory instances...");
        this.removeAllActionFactories();
        logger.log(Level.FINE, "Announcing Shutdown to group.....");
        MethodCall methodCall = new MethodCall("shutdownInitiated", new Object[]{this.ctx.getLocalAddress()}, new Class[]{Address.class});
        RspList responses = this.ctx.getRpcDispatcher().callRemoteMethods(null, methodCall, 2, 0L);
        logger.log(Level.FINE, "Received responses=" + responses);
        this.ctx.getMembershipChannel().close();
        this.ctx.getRpcDispatcher().stop();
        this.ctx.getPullPushAdapter().stop();
    }

    private void removeAllActionFactories() {
        this.router.undocketAllDestinations();
    }
}

