/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.GMSConfig;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupHandleImpl;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.MembershipListenerImpl;
import com.sun.enterprise.ee.cms.core.MessageListenerImpl;
import com.sun.enterprise.ee.cms.core.RPCInvocationHandler;
import com.sun.enterprise.ee.cms.core.Router;
import com.sun.enterprise.ee.cms.core.ViewWindow;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.HashMap;
import java.util.logging.Logger;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.IpAddress;

public class GMSContext {
    String serverToken = null;
    GroupManagementService gms;
    private JChannel memChannel;
    private MembershipListener memListener;
    private PullPushAdapter adapter;
    private RpcDispatcher dispatcher;
    private MessageListener messageListener;
    private GroupHandle ch;
    private Router router;
    private ViewWindow viewWindow;
    private Logger logger = GMSLogDomain.getLogger((String)"javax.ee.enterprise.system.gms");

    GMSContext(String serverToken, GroupManagementService gms) {
        this.serverToken = serverToken;
        this.gms = gms;
        this.viewWindow = new ViewWindow();
        this.memListener = new MembershipListenerImpl();
        this.messageListener = new MessageListenerImpl();
        this.setupMembershipChannel();
        this.ch = new GroupHandleImpl();
        this.router = new Router();
    }

    String getServerIdentityToken() {
        return this.serverToken;
    }

    Channel getMembershipChannel() {
        return this.memChannel;
    }

    MembershipListener getMembershipListener() {
        return this.memListener;
    }

    RpcDispatcher getRpcDispatcher() {
        return this.dispatcher;
    }

    PullPushAdapter getPullPushAdapter() {
        return this.adapter;
    }

    IpAddress getLocalAddress() {
        return (IpAddress)this.memChannel.getLocalAddress();
    }

    GroupHandle getGroupHandle() {
        return this.ch;
    }

    Router getRouter() {
        return this.router;
    }

    ViewWindow getViewWindow() {
        return this.viewWindow;
    }

    private JChannel setupMembershipChannel() {
        GMSConfig cfg = new GMSConfig();
        this.memChannel = cfg.getMembershipChannel();
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("additional_data", this.serverToken.getBytes());
        this.memChannel.down(new Event(56, m));
        this.memChannel.setOpt(0, (Object)Boolean.TRUE);
        this.memChannel.setOpt(2, (Object)Boolean.TRUE);
        this.memChannel.setOpt(3, (Object)Boolean.FALSE);
        return this.memChannel;
    }

    void createPullPushAdapter() {
        this.adapter = new PullPushAdapter((Transport)this.memChannel, this.messageListener, this.memListener);
    }

    void createRPCDispatcher() {
        this.dispatcher = new RpcDispatcher((Channel)this.memChannel, this.messageListener, this.memListener, (Object)new RPCInvocationHandler());
    }
}

