/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.cli.commands.BaseNodeAgentCommand;
import com.sun.enterprise.util.i18n.StringManager;

public class StartNodeAgentCommand
extends BaseNodeAgentCommand {
    private static final StringManager _strMgr = StringManager.getManager((Class)StartNodeAgentCommand.class);

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            String agentName = this.getAgentName();
            AgentConfig agentConfig = new AgentConfig(agentName, this.getAgentPath());
            AgentManager manager = this.getAgentManager(agentConfig);
            manager.validateNodeAgent(agentConfig, true);
            agentConfig.put("agent.das.user", this.getUser());
            agentConfig.put("agent.das.password", this.getPassword());
            agentConfig.put("agent.masterpassword", this.getMasterPassword((RepositoryManager)manager, agentConfig));
            manager.validateAdminUserAndPassword(agentConfig);
            manager.validateMasterPassword(agentConfig, false);
            String[] extraPasswordOptions = manager.getExtraPasswordOptions(agentConfig);
            if (extraPasswordOptions != null) {
                agentConfig.put("agent.extraPasswords", this.getExtraPasswords(extraPasswordOptions));
            }
            String override = this.getOption("startinstances");
            CLILogger.getInstance().printDebugMessage("startInstanceOverride = " + override);
            if (this.getBooleanOption("verbose")) {
                agentConfig.put("domain.verbose", Boolean.TRUE);
            }
            manager.startNodeAgent(override);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
    }
}

