/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.proxy;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.ee.admin.clientreg.NodeAgentRegistry;
import com.sun.enterprise.ee.admin.mbeanapi.NodeAgentMBean;
import com.sun.enterprise.ee.admin.proxy.BaseProxy;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class NodeAgentProxy
extends BaseProxy
implements InvocationHandler {
    private static final StringManager _strMgr = StringManager.getManager((Class)NodeAgentProxy.class);
    private static Logger _logger = null;
    private static HashMap _invocationAttributes = null;
    private static InvocationAttributes _defaultAttributes = null;
    private static String _defaultDomain = null;
    private ObjectName _objectName = null;
    private MBeanServerConnection _connection = null;
    private String _nodeAgentName = null;

    public static NodeAgentMBean getNodeAgentProxy(String nodeAgentName) {
        return (NodeAgentMBean)Proxy.newProxyInstance(NodeAgentMBean.class.getClassLoader(), new Class[]{NodeAgentMBean.class}, (InvocationHandler)new NodeAgentProxy(nodeAgentName));
    }

    private String getNodeAgentName() {
        return this._nodeAgentName;
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeAgentProxy(String nodeAgentName) {
        this._nodeAgentName = nodeAgentName;
        Class clazz = NodeAgentProxy.class;
        synchronized (clazz) {
            if (_invocationAttributes == null) {
                _invocationAttributes = new HashMap();
                _invocationAttributes.put("synchronizeWithDAS", new InvocationAttributes(false));
            }
        }
    }

    private InvocationAttributes getInvocationAttributes(String methodName) {
        InvocationAttributes attrs = (InvocationAttributes)_invocationAttributes.get(methodName);
        if (attrs == null) {
            if (_defaultAttributes == null) {
                _defaultAttributes = new InvocationAttributes(true);
            }
            attrs = _defaultAttributes;
        }
        return attrs;
    }

    private ObjectName getObjectName() throws IOException, MalformedObjectNameException, AgentException {
        if (this._objectName == null) {
            if (_defaultDomain == null) {
                _defaultDomain = this.getConnection().getDefaultDomain();
            }
            this._objectName = new ObjectName(_defaultDomain + ":type=NodeAgent,name=" + this.getNodeAgentName() + ",category=config");
        }
        return this._objectName;
    }

    private MBeanServerConnection getConnection() throws AgentException {
        if (this._connection == null) {
            this._connection = NodeAgentRegistry.getNodeAgentConnection(this.getNodeAgentName());
        }
        return this._connection;
    }

    private boolean hasRendezvousOccurred() throws ConfigException, MBeanException {
        ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
        Domain domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext);
        NodeAgents controllers = domain.getNodeAgents();
        NodeAgent controller = controllers.getNodeAgentByName(this.getNodeAgentName());
        boolean rendezvousOccurred = true;
        ElementProperty rendezvousProperty = null;
        if (controller != null) {
            rendezvousProperty = controller.getElementPropertyByName("rendezvousOccurred");
            rendezvousOccurred = new Boolean(rendezvousProperty.getValue());
        }
        if (rendezvousOccurred) {
            if (controller == null) {
                NodeAgentProxy.getLogger().log(Level.FINEST, "NodeAgentProxy: Defaulted to NodeAgent has rendezvoused since the agent has been removed ???");
            } else {
                NodeAgentProxy.getLogger().log(Level.FINEST, "NodeAgentProxy: The Nodeagent has rendezvoused with the DAS");
            }
        } else {
            NodeAgentProxy.getLogger().log(Level.FINEST, "NodeAgentProxy: The NodeAgent has not rendezvoused with the DAS");
        }
        return rendezvousOccurred;
    }

    private Exception mangleInvokeException(Exception ex) {
        Object result = null;
        if (ex instanceof MBeanException) {
            Throwable t = ex.getCause();
            if (t != null && t instanceof Exception) {
                ex = (Exception)t;
            }
            result = ex;
        }
        result = ex instanceof AgentException ? ex : new AgentException(ex);
        if (NodeAgentProxy.isUnreachable(ex)) {
            try {
                NodeAgentRegistry.disconnectNodeAgentConnection(this.getNodeAgentName());
            }
            catch (Exception ex2) {
                NodeAgentProxy.getLogger().log(Level.WARNING, "nodeAgent.proxy.exception", ex2);
            }
        }
        return result;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        NodeAgentProxy.getLogger().log(Level.FINEST, "NodeAgentProxy:invoke " + methodName);
        InvocationAttributes attrs = this.getInvocationAttributes(methodName);
        Exception exception = null;
        Object result = null;
        try {
            if (!this.hasRendezvousOccurred()) {
                throw new ConnectException(_strMgr.getString("nodeAgent.not.rendezvoused"));
            }
            NodeAgentProxy.getLogger().log(Level.FINEST, "Sending command ....");
            result = this.getConnection().invoke(this.getObjectName(), methodName, args, NodeAgentProxy.getParameterTypes(method.getParameterTypes()));
            return result;
        }
        catch (Exception ex) {
            NodeAgentProxy.getLogger().log(Level.FINEST, "NodeAgentProxy:invoke: Connection processing exception: " + ex.toString());
            exception = this.mangleInvokeException(ex);
            if (attrs.mustSucceed()) {
                throw exception;
            }
            if (!NodeAgentProxy.isUnreachable(exception)) {
                NodeAgentProxy.getLogger().log(Level.FINE, "nodeAgent.proxy.exception", exception);
            } else {
                NodeAgentProxy.getLogger().log(Level.FINE, "nodeAgent.proxy.cannotConnect", this.getNodeAgentName());
            }
            return result;
        }
    }

    private class InvocationAttributes {
        boolean _mustSucceed;

        InvocationAttributes(boolean mustSucceed) {
            this._mustSucceed = mustSucceed;
        }

        boolean mustSucceed() {
            return this._mustSucceed;
        }
    }
}

