/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class EEApplicationsConfigMBean
extends com.sun.enterprise.ee.deployment.EEApplicationsConfigMBean
implements com.sun.enterprise.ee.admin.mbeanapi.EEApplicationsConfigMBean {
    private static final TargetType[] VALID_CREATE_DELETE_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.UNCLUSTERED_SERVER, TargetType.DAS};
    private static final TargetType[] VALID_LIST_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS};
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(EEApplicationsConfigMBean.getLogger());
        }
        return _handler;
    }

    public String[] listApplicationReferencesAsString(String targetName) throws ConfigException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, configContext);
            ApplicationRef[] refs = target.getApplicationRefs();
            String[] result = new String[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                result[i] = refs[i].getRef();
            }
            return result;
        }
        catch (Exception ex) {
            throw EEApplicationsConfigMBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listApplicationReferences.Exception", targetName);
        }
    }

    public ObjectName[] listReferencees(String applicationRef) throws ConfigException {
        ObjectName[] referencees = new ObjectName[]{};
        try {
            Cluster[] clusters;
            ConfigContext ctx = this.getConfigContext();
            ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
            Server[] servers = ServerHelper.getServersReferencingApplication((ConfigContext)ctx, (String)applicationRef);
            if (servers != null) {
                for (int i = 0; i < servers.length; ++i) {
                    String name = servers[i].getName();
                    if (ServerHelper.isServerClustered((ConfigContext)ctx, (String)name)) continue;
                    objectNames.add(this.getServerObjectName(name));
                }
            }
            if ((clusters = ClusterHelper.getClustersReferencingApplication((ConfigContext)ctx, (String)applicationRef)) != null) {
                for (int i = 0; i < clusters.length; ++i) {
                    String name = clusters[i].getName();
                    objectNames.add(this.getClusterObjectName(name));
                }
            }
            referencees = objectNames.toArray(new ObjectName[0]);
        }
        catch (Exception ex) {
            throw EEApplicationsConfigMBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listApplicationReferencees.Exception", applicationRef);
        }
        return referencees;
    }
}

