/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameAliasSupport;
import com.sun.enterprise.admin.dottedname.DottedNameForValue;
import com.sun.enterprise.admin.dottedname.DottedNameQuery;
import com.sun.enterprise.admin.dottedname.DottedNameRegistry;
import com.sun.enterprise.admin.dottedname.DottedNameResolver;
import com.sun.enterprise.admin.dottedname.DottedNameResolverForAliases;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.dottedname.DottedNameWildcardMatcherImpl;
import com.sun.enterprise.admin.dottedname.valueaccessor.PrefixedValueSupport;
import com.sun.enterprise.admin.dottedname.valueaccessor.PropertyValueAccessor;
import com.sun.enterprise.admin.dottedname.valueaccessor.PropertyValueAccessorBase;
import com.sun.enterprise.admin.dottedname.valueaccessor.SystemPropertyValueAccessor;
import com.sun.enterprise.admin.mbeans.DottedNameGetSetForConfig;
import com.sun.enterprise.admin.mbeans.DottedNameGetSetMBeanBase;
import com.sun.enterprise.admin.mbeans.DottedNameGetSetMBeanImpl;
import com.sun.enterprise.admin.util.ArrayConversion;
import com.sun.enterprise.ee.admin.dottedname.DottedNameAliasSupportEE;
import com.sun.enterprise.ee.admin.dottedname.DottedNameAliasedQueryEE;
import com.sun.enterprise.ee.admin.dottedname.DottedNameClusterInfo;
import com.sun.enterprise.ee.admin.dottedname.DottedNameClusterInfoCache;
import com.sun.enterprise.ee.admin.dottedname.DottedNameClusterInfoImpl;
import com.sun.enterprise.ee.admin.dottedname.DottedNameResolverForAliasesEE;
import com.sun.enterprise.ee.admin.dottedname.DottedNameServerInfoCacheEE;
import com.sun.enterprise.ee.admin.dottedname.DottedNameServerInfoEE;
import com.sun.enterprise.ee.admin.dottedname.DottedNameServerInfoImplEE;
import com.sun.enterprise.ee.admin.dottedname.UnavailableException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class DottedNameGetSetMBeanImplEE
extends DottedNameGetSetMBeanImpl {
    final DottedNameGetSetForConfig mConfigImpl;
    final DottedNameServerInfoCacheEE mServerInfo;
    final DottedNameClusterInfoCache mClusterInfo;
    private static final StringManager _strMgr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DottedNameGetSetMBeanImplEE(MBeanServerConnection conn, DottedNameRegistry registry, DottedNameRegistry monitoringRegistry) throws NotCompliantMBeanException, MalformedObjectNameException {
        super(conn, registry, monitoringRegistry);
        this.mServerInfo = new DottedNameServerInfoCacheEE((DottedNameServerInfoEE)this.createServerInfo(conn));
        this.mClusterInfo = new DottedNameClusterInfoCache(this.createClusterInfo(conn));
        this.mConfigImpl = new DottedNameGetSetForConfigEE(conn, registry, this.mServerInfo, this.mClusterInfo);
    }

    protected DottedNameClusterInfo createClusterInfo(MBeanServerConnection conn) {
        return new DottedNameClusterInfoImpl(conn);
    }

    protected DottedNameServerInfo createServerInfo(MBeanServerConnection conn) {
        return new DottedNameServerInfoImplEE(conn);
    }

    protected void pre() {
        this.mClusterInfo.refresh();
        this.mServerInfo.refresh();
        super.pre();
    }

    protected Object[] dottedNameAnyGet(DottedNameGetSetMBeanBase impl, String[] names) {
        this.pre();
        return super.dottedNameAnyGet(impl, names);
    }

    public Object[] dottedNameGet(String[] names) {
        return this.dottedNameAnyGet((DottedNameGetSetMBeanBase)this.mConfigImpl, names);
    }

    public Object dottedNameGet(String name) {
        Object result = this.dottedNameAnyGet((DottedNameGetSetMBeanBase)this.mConfigImpl, name);
        return result;
    }

    public Object[] dottedNameSet(String[] nameValuePairs) {
        this.pre();
        Object[] results = this.mConfigImpl.dottedNameSet(nameValuePairs);
        if (!$assertionsDisabled && !this.checkSetResults(results)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && results.length != nameValuePairs.length) {
            throw new AssertionError();
        }
        return this.convertArrayType(results);
    }

    public String[] dottedNameList(String[] namePrefixes) {
        this.pre();
        return this.mConfigImpl.dottedNameList(namePrefixes);
    }

    static {
        $assertionsDisabled = !DottedNameGetSetMBeanImplEE.class.desiredAssertionStatus();
        _strMgr = StringManager.getManager((Class)DottedNameGetSetMBeanImplEE.class);
    }

    class SetDisallowedForSharedConfigException
    extends Exception {
        public SetDisallowedForSharedConfigException(String msg) {
            super(msg);
        }

        public SetDisallowedForSharedConfigException(Throwable e) {
            super(e);
        }

        public SetDisallowedForSharedConfigException(String msg, Throwable e) {
            super(msg, e);
        }
    }

    class SetDisallowedForSharedResourceException
    extends Exception {
        public SetDisallowedForSharedResourceException(String msg) {
            super(msg);
        }

        public SetDisallowedForSharedResourceException(Throwable e) {
            super(e);
        }

        public SetDisallowedForSharedResourceException(String msg, Throwable e) {
            super(msg, e);
        }
    }

    class SetDisallowedForSharedApplicationException
    extends Exception {
        public SetDisallowedForSharedApplicationException(String msg) {
            super(msg);
        }

        public SetDisallowedForSharedApplicationException(Throwable e) {
            super(e);
        }

        public SetDisallowedForSharedApplicationException(String msg, Throwable e) {
            super(msg, e);
        }
    }

    class DottedNameGetSetForConfigEE
    extends DottedNameGetSetForConfig {
        final DottedNameResolverForAliases mResolver;
        final DottedNameQuery mQuery;
        final DottedNameRegistry mRegistry;
        private final Set APP_RES_SET;
        static final /* synthetic */ boolean $assertionsDisabled;

        DottedNameGetSetForConfigEE(MBeanServerConnection conn, DottedNameRegistry registry, DottedNameServerInfo serverInfo, DottedNameClusterInfo clusterInfo) {
            super(conn, registry, serverInfo);
            this.APP_RES_SET = ArrayConversion.toSet((Object[])new String[]{"applications", "resources"});
            this.mRegistry = registry;
            this.mResolver = new DottedNameResolverForAliasesEE((DottedNameQuery)registry, serverInfo, clusterInfo);
            this.mQuery = new DottedNameAliasedQueryEE((DottedNameQuery)registry, serverInfo, clusterInfo);
        }

        protected Set doList(String[] namePrefixes) throws DottedNameServerInfo.UnavailableException {
            return super.doList(namePrefixes);
        }

        protected Set getAllTopLevelNames() {
            HashSet<String> all = new HashSet<String>();
            Set searchSet = this.createQuery().allDottedNameStrings();
            Iterator iter = searchSet.iterator();
            while (iter.hasNext()) {
                String candidateString = (String)iter.next();
                DottedName dn = this.getDottedName(candidateString);
                if (dn.getParts().size() != 0 || DottedNameGetSetMBeanImplEE.this.mClusterInfo.isClusteredInstance(candidateString)) continue;
                all.add(candidateString);
            }
            return all;
        }

        protected Set getSearchSet(String dottedNameExpr) {
            DottedName dn = this.getDottedName(dottedNameExpr);
            String scope = dn.getScope();
            boolean isDomain = scope.startsWith("domain");
            boolean isConfig = this.startsWithConfigName(dottedNameExpr);
            Set s = isDomain || isConfig ? this.getRegistry().allDottedNameStrings() : this.createQuery().allDottedNameStrings();
            return s;
        }

        protected Set resolveWildcardPrefix(String dottedNamePrefix) throws DottedNameServerInfo.UnavailableException {
            Set resolvedSet = Collections.EMPTY_SET;
            if (DottedName.isWildcardName((String)dottedNamePrefix)) {
                if (dottedNamePrefix.equals("*")) {
                    resolvedSet = this.createQuery().allDottedNameStrings();
                    resolvedSet = this.resolveAppsOrResourcesToTarget(this.getDottedName(dottedNamePrefix), resolvedSet, resolvedSet);
                    resolvedSet = this.resolveDomainSvrsCfgsClstrsQuery(this.getDottedName(dottedNamePrefix), resolvedSet, resolvedSet);
                } else {
                    Set searchSet = this.getSearchSet(dottedNamePrefix);
                    resolvedSet = this.performRegexpMatch(dottedNamePrefix, searchSet);
                    resolvedSet = this.resolveAppsOrResourcesToTarget(this.getDottedName(dottedNamePrefix), searchSet, resolvedSet);
                    resolvedSet = this.resolveDomainSvrsCfgsClstrsQuery(this.getDottedName(dottedNamePrefix), searchSet, resolvedSet);
                }
            } else {
                resolvedSet = Collections.singleton(dottedNamePrefix);
            }
            return resolvedSet;
        }

        private Set performRegexpMatch(String dottedNamePrefix, Set searchSet) {
            String regex = DottedNameGetSetForConfigEE.convertWildcardStringToJavaFormat((String)dottedNamePrefix);
            DottedNameWildcardMatcherImpl matcher = new DottedNameWildcardMatcherImpl(searchSet);
            Set resolvedSet = matcher.matchDottedNames(regex);
            return resolvedSet;
        }

        private Set resolveDomainSvrsCfgsClstrsQuery(DottedName prefixDottedName, Set searchSet, Set resolvedSet) {
            String scope = prefixDottedName.getScope();
            String string = scope = scope.indexOf("*") <= 0 ? scope : scope.substring(0, scope.indexOf("*"));
            if (scope.equals("*") || DottedNameAliasSupportEE.scopeIsDomain((String)scope) && prefixDottedName.getParts().size() == 0) {
                this.addSpecialCaseResults(resolvedSet, searchSet);
            } else if (DottedNameAliasSupportEE.scopeIsDomain((String)scope) && prefixDottedName.getParts().size() >= 1) {
                String prefix = prefixDottedName.toString();
                if (prefixDottedName.getPart(0).equals("*")) {
                    this.addSpecialCaseResults(resolvedSet, searchSet);
                }
                if (prefix.indexOf("*") > 0) {
                    if ((prefix = prefix.substring(0, prefix.indexOf("*"))).endsWith(".")) {
                        prefix = prefix.substring(0, prefix.lastIndexOf("."));
                    }
                    if (this.isSpecialCaseQuery(prefix)) {
                        try {
                            resolvedSet.addAll(this.getSpecialCaseChildren(prefix));
                        }
                        catch (Exception e) {
                            DottedNameGetSetForConfigEE.logException((Exception)e);
                        }
                    }
                }
            }
            return resolvedSet;
        }

        private void addSpecialCaseResults(Set resolvedSet, Set searchSet) {
            try {
                HashMap s = this.getSpecialCases();
                Iterator keys = s.keySet().iterator();
                while (keys.hasNext()) {
                    Iterator values = ((Collection)s.get(keys.next())).iterator();
                    while (values.hasNext()) {
                        resolvedSet.addAll(this.performRegexpMatch((String)values.next(), searchSet));
                    }
                }
            }
            catch (Exception e) {
                DottedNameGetSetForConfigEE.logException((Exception)e);
            }
        }

        private Set resolveAppsOrResourcesToTarget(DottedName prefixDottedName, Set searchSet, Set resolvedSet) {
            HashSet<String> result = new HashSet<String>();
            if (!prefixDottedName.getScope().startsWith("domain") && (prefixDottedName.getParts().size() == 0 || prefixDottedName.getParts().size() > 0 && prefixDottedName.getPart(0).matches(".*resources.*") || prefixDottedName.getPart(0).matches(".*applications.*"))) {
                Iterator resolved = resolvedSet.iterator();
                while (resolved.hasNext()) {
                    String candidate = (String)resolved.next();
                    DottedName candidateDN = this.getDottedName(candidate);
                    if (!DottedNameAliasSupportEE.scopeIsDomain((String)candidateDN.getScope()) && candidate.matches(".*resources.*") || candidate.matches(".*applications.*")) {
                        Iterator search = searchSet.iterator();
                        while (search.hasNext()) {
                            String searchCand = (String)search.next();
                            DottedName searchCandDN = this.getDottedName(searchCand);
                            if (searchCandDN.getParts().isEmpty() || !searchCandDN.getPart(0).equals("resource-ref") && !searchCandDN.getPart(0).equals("application-ref") || candidateDN.getParts().size() <= 1 || !candidateDN.getScope().equals(searchCandDN.getScope()) || !candidateDN.getPart(1).equals(searchCandDN.getPart(1)) && !candidateDN.getPart(2).equals(searchCandDN.getPart(1))) continue;
                            result.add(candidate);
                        }
                        continue;
                    }
                    result.add(candidate);
                }
                return result;
            }
            return resolvedSet;
        }

        protected Set getAllDescendants(String namePrefix) {
            Set searchSet = this.getSearchSet(namePrefix);
            String searchPrefix = namePrefix + ".";
            Set<String> resultSet = new HashSet();
            Iterator iter = searchSet.iterator();
            String scope = this.getDottedName(namePrefix).getScope();
            while (iter.hasNext()) {
                String candidateString = (String)iter.next();
                if (!DottedNameAliasSupport.scopeIsDomain((String)scope)) {
                    resultSet = this.filterAppAndRef(namePrefix, candidateString, DottedName.escapePart((String)scope), resultSet);
                    resultSet = this.filterResAndRef(namePrefix, candidateString, DottedName.escapePart((String)scope), resultSet);
                    if (!candidateString.startsWith(searchPrefix)) continue;
                    resultSet.add(candidateString);
                    continue;
                }
                if (!candidateString.startsWith(searchPrefix = this.getNodeAgentsSearchPrefix(namePrefix, searchPrefix))) continue;
                resultSet.add(candidateString);
            }
            return resultSet;
        }

        private String getNodeAgentsSearchPrefix(String namePrefix, String searchPrefix) {
            DottedName dn = this.getDottedName(namePrefix);
            if (dn.getParts().size() > 0 && dn.getPart(0).equalsIgnoreCase("node-agents")) {
                searchPrefix = namePrefix.substring(0, namePrefix.length() - 1) + ".";
            }
            return searchPrefix;
        }

        private Set filterResAndRef(String namePrefix, String candidateString, String scope, Set resultSet) {
            if (namePrefix.matches(".*resources$")) {
                if (candidateString.startsWith(scope + ".resource-ref")) {
                    resultSet.add(candidateString);
                } else if (candidateString.startsWith(scope + ".resources")) {
                    resultSet.add(candidateString);
                }
            }
            return resultSet;
        }

        private Set filterAppAndRef(String namePrefix, String candidateString, String scope, Set resultSet) {
            if (namePrefix.matches(".*applications$")) {
                if (candidateString.startsWith(scope + ".application-ref")) {
                    resultSet.add(candidateString);
                } else if (candidateString.startsWith(scope + ".applications")) {
                    resultSet.add(candidateString);
                }
            }
            return resultSet;
        }

        protected Set getAllImmediateChildren(String namePrefix) {
            if (this.isSpecialCaseQuery(namePrefix)) {
                try {
                    return this.getSpecialCaseChildren(namePrefix);
                }
                catch (Exception e) {
                    DottedNameGetSetForConfigEE.logException((Exception)e);
                }
            }
            Set allChildren = this.getAllDescendants(namePrefix);
            DottedName namePrefixDn = this.getDottedName(namePrefix);
            int numParentParts = namePrefixDn.getParts().size();
            if (!namePrefixDn.getScope().equalsIgnoreCase("domain") && this.containsAppRes(namePrefixDn)) {
                allChildren = this.resolveRefToSrc(allChildren);
            }
            Iterator iter = allChildren.iterator();
            HashSet<String> resultSet = new HashSet<String>();
            while (iter.hasNext()) {
                String descendant = (String)iter.next();
                DottedName dn = this.getDottedName(descendant);
                if (this.containsServerRef(dn)) {
                    descendant = this.replaceServerRefWithSrc(descendant);
                    dn = this.getDottedName(descendant);
                }
                if (numParentParts == 0) {
                    if (dn.getParts().size() != numParentParts + 1) continue;
                    resultSet.add(descendant);
                    continue;
                }
                if (dn.getParts().size() > numParentParts + 2) continue;
                resultSet.add(descendant);
            }
            return resultSet;
        }

        private Set getSpecialCaseChildren(String namePrefix) throws Exception {
            return (Set)this.getSpecialCases().get(namePrefix);
        }

        private final HashMap getSpecialCases() throws Exception {
            HashMap<String, Set> specialCases = new HashMap<String, Set>();
            specialCases.put("domain.clusters", this.escapeNames(DottedNameGetSetMBeanImplEE.this.mClusterInfo.getClusterNames()));
            specialCases.put("domain.servers", this.escapeNames(DottedNameGetSetMBeanImplEE.this.mServerInfo.getServerNames()));
            specialCases.put("domain.configs", this.escapeNames(DottedNameGetSetMBeanImplEE.this.mClusterInfo.getConfigNames()));
            return specialCases;
        }

        private Set escapeNames(Set targetNames) {
            HashSet<String> escTargets = new HashSet<String>();
            Iterator i = targetNames.iterator();
            while (i.hasNext()) {
                escTargets.add(DottedName.escapePart((String)((String)i.next())));
            }
            return escTargets;
        }

        private boolean isSpecialCaseQuery(String namePrefix) {
            DottedName dn = this.getDottedName(namePrefix);
            try {
                if (dn.getParts().size() > 0 && this.getSpecialCases().keySet().contains(namePrefix)) {
                    return true;
                }
            }
            catch (Exception e) {
                DottedNameGetSetForConfigEE.logException((Exception)e);
            }
            return false;
        }

        private String replaceServerRefWithSrc(String descendant) {
            String temp = descendant.substring(0, descendant.indexOf("."));
            temp = temp + descendant.substring(descendant.lastIndexOf("."), descendant.length());
            return temp;
        }

        private Set resolveRefToSrc(Set children) {
            HashSet<String> resultSet = new HashSet<String>();
            Iterator iter = children.iterator();
            block0: while (iter.hasNext()) {
                String candidate = (String)iter.next();
                if (!candidate.matches(".+application-ref.+") && !candidate.matches(".+resource-ref.+")) continue;
                Iterator tempIter = children.iterator();
                while (tempIter.hasNext()) {
                    String cand = (String)tempIter.next();
                    if (!cand.matches(".+applications.+") && !cand.matches(".+resources.+") || !cand.endsWith(candidate.substring(candidate.lastIndexOf(".") + 1, candidate.length()))) continue;
                    resultSet.add(cand);
                    resultSet.add(candidate);
                    continue block0;
                }
            }
            return resultSet;
        }

        private boolean containsAppRes(DottedName dn) {
            boolean contains = false;
            List parts = dn.getParts();
            if (parts.size() >= 1) {
                contains = this.APP_RES_SET.contains(parts.get(0));
            }
            return contains;
        }

        private boolean containsServerRef(DottedName dn) {
            boolean contains = false;
            if (((String)dn.getParts().get(0)).equalsIgnoreCase("server-ref")) {
                contains = true;
            }
            return contains;
        }

        protected DottedNameQuery createQuery() {
            return this.mQuery;
        }

        public Object[] dottedNameSet(String[] nameValuePairs) {
            int numItems = nameValuePairs.length;
            Object[] sortedPairs = new String[numItems];
            for (int i = 0; i < numItems; ++i) {
                sortedPairs[i] = nameValuePairs[i];
            }
            Arrays.sort(sortedPairs);
            Object[] results = new Object[sortedPairs.length];
            for (int i = 0; i < numItems; ++i) {
                results[i] = this.dottedNameSet((String)sortedPairs[i]);
            }
            return results;
        }

        protected Object dottedNameSet(String nameValuePair) {
            Serializable result;
            try {
                result = this.doSet(nameValuePair);
            }
            catch (Exception e) {
                DottedNameGetSetForConfigEE.logException((Exception)e);
                result = e;
            }
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }

        protected DottedNameResolver getResolver() {
            return this.mResolver;
        }

        boolean isDottedNameForClusterName(DottedName prefix, String valueName) throws DottedNameServerInfo.UnavailableException {
            return valueName.equals("name") && this.isClusterName(prefix.getScope()) && prefix.getParts().size() == 0;
        }

        private boolean isClusterName(String scope) throws DottedNameServerInfo.UnavailableException {
            return DottedNameGetSetMBeanImplEE.this.mClusterInfo.getClusterNames().contains(scope);
        }

        protected boolean startsWithConfigName(String dottedNameExpr) {
            boolean startsWithConfig = false;
            try {
                Iterator iter = DottedNameGetSetMBeanImplEE.this.mClusterInfo.getConfigNames().iterator();
                while (iter.hasNext()) {
                    String configName = (String)iter.next();
                    if (!dottedNameExpr.startsWith(configName)) continue;
                    startsWithConfig = true;
                    break;
                }
                if (!startsWithConfig) {
                    startsWithConfig = super.startsWithConfigName(dottedNameExpr);
                }
            }
            catch (DottedNameServerInfo.UnavailableException e) {
                DottedNameGetSetForConfigEE.logException((Exception)((Object)e));
            }
            return startsWithConfig;
        }

        public Attribute doSet(String dottedNameString, String value) throws Exception {
            DottedName dn = this.getDottedName(dottedNameString);
            if (dn.isWildcardName()) {
                String msg = _strMgr.getString("WildcardDisallowedForSet", (Object)dottedNameString);
                throw new IllegalArgumentException(msg);
            }
            if (!DottedNameAliasSupportEE.scopeIsDomain((String)dn.getScope()) && !this.startsWithConfigName(dn.getScope()) && dn.getParts().size() > 0) {
                try {
                    this.checkShared(dn);
                }
                catch (Exception e) {
                    Attribute resultAttr = new Attribute(e.getClass().getName(), e.getMessage());
                    return resultAttr;
                }
            }
            DottedNameForValue dnv = new DottedNameForValue(dn);
            String prefix = dnv.getPrefix().toString();
            ObjectName target = this.isDottedNameForClusterName(dnv.getPrefix(), dnv.getValueName()) || this.isDottedNameForServerName(dnv.getPrefix(), dnv.getValueName()) ? this.getRegistry().dottedNameToObjectName(dnv.getPrefix().toString()) : (prefix.equalsIgnoreCase("domain") || prefix.indexOf(".") < 0 || dnv.getValueName().matches("system-property..+") ? this.mRegistry.dottedNameToObjectName(prefix) : DottedNameGetSetForConfigEE.getTarget((DottedNameForValue)dnv, (DottedNameResolver)this.getResolver()));
            if (target == null) {
                throw new UnavailableException(_strMgr.getString("ObjectInstanceNotFound", (Object)prefix));
            }
            Attribute inAttr = new Attribute(dnv.getValueName(), value);
            Attribute resultAttr = this.mValueAccessor.setValue(target, inAttr);
            if (resultAttr != null && resultAttr.getValue() != null) {
                String fullName = dnv.getPrefix() + "." + inAttr.getName();
                resultAttr = new Attribute(fullName, resultAttr.getValue());
            }
            return resultAttr;
        }

        private void checkShared(DottedName dn) throws Exception {
            this.checkSharedResource(dn);
            this.checkSharedApplication(dn);
            this.checkSharedConfig(dn);
        }

        private void checkSharedConfig(DottedName dn) throws UnavailableException {
            if (!(this.isApplicationsQuery(dn) || this.isResourcesQuery(dn) || this.isAppOrResRefQuery(dn))) {
                try {
                    String resolvedScope = DottedNameAliasSupportEE.resolveScope(DottedNameGetSetMBeanImplEE.this.mClusterInfo, DottedNameGetSetMBeanImplEE.this.mServerInfo, dn);
                    if (!this.startsWithConfigName(resolvedScope)) {
                        return;
                    }
                    if (DottedNameGetSetMBeanImplEE.this.mClusterInfo.getTargetsSharingConfig(resolvedScope).length > 1 && !resolvedScope.equalsIgnoreCase(dn.getScope())) {
                        String msg = _strMgr.getString("SetOperationDisallowedForSharedConfigs", (Object)resolvedScope, (Object)dn.getPart(dn.getParts().size() - 1));
                        throw new SetDisallowedForSharedResourceException(msg);
                    }
                }
                catch (Exception e) {
                    throw new UnavailableException(this.getRootCause(e).getMessage());
                }
            }
        }

        private boolean isAppOrResRefQuery(DottedName dn) {
            boolean retval = false;
            if (dn.getPart(0).equalsIgnoreCase("resource-ref") || dn.getPart(0).equalsIgnoreCase("application-ref")) {
                retval = true;
            }
            return retval;
        }

        private boolean isResourcesQuery(DottedName dn) {
            return dn.getPart(0).equalsIgnoreCase("resources");
        }

        private boolean isApplicationsQuery(DottedName dn) {
            return dn.getPart(0).equalsIgnoreCase("applications");
        }

        private void checkSharedApplication(DottedName dn) throws UnavailableException {
            block9: {
                if (this.isApplicationsQuery(dn)) {
                    try {
                        if (dn.getParts().size() > 2) {
                            String appName = dn.getPart(2);
                            if (DottedNameGetSetMBeanImplEE.this.mClusterInfo.getTargetsSharingApplication(appName).length > 1) {
                                String msg = _strMgr.getString("SetOperationDisallowedForSharedApplications", (Object)appName, (Object)dn.getPart(dn.getParts().size() - 1));
                                throw new SetDisallowedForSharedResourceException(msg);
                            }
                            String scope = dn.getScope();
                            if (DottedNameGetSetMBeanImplEE.this.mClusterInfo.getClusterNames().contains(scope)) {
                                if (!DottedNameGetSetMBeanImplEE.this.mClusterInfo.getApplicationNamesForCluster(scope).contains(appName)) {
                                    String msg = _strMgr.getString("ApplicationNotReferencedByCluster", new Object[]{appName, scope, dn.getPart(dn.getParts().size() - 1)});
                                    throw new UnavailableException(msg);
                                }
                            } else if (DottedNameGetSetMBeanImplEE.this.mServerInfo.getUnclusteredServerNames().contains(scope) && !DottedNameGetSetMBeanImplEE.this.mServerInfo.getApplicationNamesForServer(scope).contains(appName)) {
                                String msg = _strMgr.getString("ApplicationNotReferencedByServer", new Object[]{appName, scope, dn.getPart(dn.getParts().size() - 1)});
                                throw new UnavailableException(msg);
                            }
                            break block9;
                        }
                        String msg = _strMgr.getString("ObjectInstanceNotFound", (Object)dn.toString());
                        throw new UnavailableException(msg);
                    }
                    catch (Exception e) {
                        DottedNameGetSetForConfigEE.logException((Exception)e);
                        throw new UnavailableException(e);
                    }
                }
            }
        }

        private void checkSharedResource(DottedName dn) throws Exception {
            if (this.isResourcesQuery(dn)) {
                if (dn.getParts().size() > 2) {
                    String resName = dn.getPart(2);
                    if (DottedNameGetSetMBeanImplEE.this.mClusterInfo.getTargetsSharingResource(resName).length > 1) {
                        String msg = _strMgr.getString("SetOperationDisallowedForSharedResources", (Object)resName, (Object)dn.getPart(dn.getParts().size() - 1));
                        throw new SetDisallowedForSharedResourceException(msg);
                    }
                    String scope = dn.getScope();
                    if (DottedNameGetSetMBeanImplEE.this.mClusterInfo.getClusterNames().contains(scope)) {
                        if (!DottedNameGetSetMBeanImplEE.this.mClusterInfo.getResourceNamesForCluster(scope).contains(resName)) {
                            String msg = _strMgr.getString("ResourceNotReferencedByCluster", new Object[]{resName, scope, dn.getPart(dn.getParts().size() - 1)});
                            throw new UnavailableException(msg);
                        }
                    } else if (DottedNameGetSetMBeanImplEE.this.mServerInfo.getUnclusteredServerNames().contains(scope) && !scope.equals("server") && !DottedNameGetSetMBeanImplEE.this.mServerInfo.getResourceNamesForServer(scope).contains(resName)) {
                        String msg = _strMgr.getString("ResourceNotReferencedByServer", new Object[]{resName, scope, dn.getPart(dn.getParts().size() - 1)});
                        throw new UnavailableException(msg);
                    }
                } else {
                    String msg = _strMgr.getString("ObjectInstanceNotFound", (Object)dn.toString());
                    throw new UnavailableException(msg);
                }
            }
        }

        protected void doGet(String dottedNameString, AttributeList attrsOut) throws Exception {
            DottedName dn = this.getDottedName(dottedNameString);
            DottedNameForValue dnv = new DottedNameForValue(dn);
            String prefix = dnv.getPrefix().toString();
            ObjectName target = prefix.equalsIgnoreCase("domain") || prefix.indexOf(".") < 0 ? this.mRegistry.dottedNameToObjectName(prefix) : DottedNameGetSetForConfigEE.getTarget((DottedNameForValue)dnv, (DottedNameResolver)this.getResolver());
            String valueName = dnv.getValueName();
            if (target == null) {
                throw new UnavailableException(_strMgr.getString("ObjectInstanceNotFound", (Object)prefix));
            }
            Attribute attr = this.mValueAccessor.getValue(target, valueName);
            if (attr != null) {
                attrsOut.add(this.formAttribute(dnv.getPrefix(), valueName, attr.getValue()));
            }
        }

        protected Set prefixToValueDottedNamesWild(DottedNameResolver resolver, String prefix, String suffix) {
            HashSet all = new HashSet();
            try {
                ObjectName objectName = prefix.equalsIgnoreCase("domain") || prefix.indexOf(".") < 0 ? this.mRegistry.dottedNameToObjectName(prefix) : resolver.resolveDottedName(prefix);
                if (objectName != null) {
                    Set allValueNames;
                    if (suffix.equals("*")) {
                        allValueNames = DottedNameGetSetForConfigEE.getAllPropertyNames((PropertyValueAccessorBase)new PropertyValueAccessor(this.getMBS()), (ObjectName)objectName);
                        allValueNames.addAll(DottedNameGetSetForConfigEE.getAllPropertyNames((PropertyValueAccessorBase)new SystemPropertyValueAccessor(this.getMBS()), (ObjectName)objectName));
                        allValueNames.addAll(DottedNameGetSetForConfigEE.getAllValueNames((MBeanServerConnection)this.getMBS(), (ObjectName)objectName));
                    } else {
                        PropertyValueAccessorBase prop_accessor = new PrefixedValueSupport(this.getMBS()).getPrefixedValueAccessor(suffix);
                        allValueNames = prop_accessor != null ? DottedNameGetSetForConfigEE.getAllPropertyNames((PropertyValueAccessorBase)prop_accessor, (ObjectName)objectName) : DottedNameGetSetForConfigEE.getAllValueNames((MBeanServerConnection)this.getMBS(), (ObjectName)objectName);
                    }
                    Set valuesDottedNames = DottedNameGetSetForConfigEE.generateDottedNamesForValues((Set)allValueNames, (String)prefix, (String)suffix);
                    all.addAll(valuesDottedNames);
                }
            }
            catch (Exception e) {
                DottedNameGetSetForConfigEE.logException((Exception)e);
            }
            return all;
        }

        public Throwable[] getCauses(Throwable start) {
            ArrayList<Throwable> list = new ArrayList<Throwable>();
            boolean haveNonException = false;
            Throwable t = start;
            while (t != null) {
                Throwable temp;
                list.add(t);
                if (!(t instanceof Exception)) {
                    haveNonException = true;
                }
                if ((temp = t.getCause()) == null) break;
                t = temp;
            }
            Throwable[] results = haveNonException ? new Throwable[list.size()] : new Exception[list.size()];
            list.toArray(results);
            return results;
        }

        public Throwable getRootCause(Throwable e) {
            Throwable[] causes = this.getCauses(e);
            return causes[causes.length - 1];
        }

        static {
            $assertionsDisabled = !(class$com$sun$enterprise$ee$admin$mbeans$DottedNameGetSetMBeanImplEE == null ? (class$com$sun$enterprise$ee$admin$mbeans$DottedNameGetSetMBeanImplEE = DottedNameGetSetMBeanImplEE.class$("com.sun.enterprise.ee.admin.mbeans.DottedNameGetSetMBeanImplEE")) : class$com$sun$enterprise$ee$admin$mbeans$DottedNameGetSetMBeanImplEE).desiredAssertionStatus();
        }
    }
}

