/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.PropertyReader;
import com.sun.enterprise.ee.admin.lbadmin.transform.PropertyVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.Visitor;
import com.sun.enterprise.util.i18n.StringManager;

public class PropertyReaderImpl
implements PropertyReader {
    private static final StringManager _localStrMgr = StringManager.getManager((Class)PropertyReaderImpl.class);
    private String _value = null;
    private String _name = null;
    private String _description = null;

    public PropertyReaderImpl(LbConfig lbConfig, String propName) {
        if (lbConfig == null || propName == null) {
            String msg = _localStrMgr.getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }
        this.setValue(lbConfig, propName);
    }

    public String getName() throws LbReaderException {
        return this._name;
    }

    public String getValue() throws LbReaderException {
        return this._value;
    }

    public String getDescription() throws LbReaderException {
        return this._description;
    }

    public void accept(Visitor v) {
        PropertyVisitor pv = (PropertyVisitor)v;
        pv.visit(this);
    }

    private void setValue(LbConfig lbConfig, String name) {
        if (name.equals("response-timeout-in-seconds")) {
            this._value = lbConfig.getResponseTimeoutInSeconds();
        } else if (name.equals("reload-poll-interval-in-seconds")) {
            this._value = lbConfig.getReloadPollIntervalInSeconds();
        } else if (name.equals("https-routing")) {
            this._value = "" + lbConfig.isHttpsRouting();
        } else if (name.equals("require-monitor-data")) {
            this._value = "" + lbConfig.isMonitoringEnabled();
        } else if (name.equals("route-cookie-enabled")) {
            this._value = "" + lbConfig.isRouteCookieEnabled();
        } else {
            String msg = _localStrMgr.getString("PropertyNotFound", (Object)name, (Object)lbConfig.getName());
            throw new IllegalArgumentException(msg);
        }
        this._name = name;
    }
}

