/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.ClusterReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LoadbalancerReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.PropertyReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.ClusterReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.PropertyReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.StandAloneClusterReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.transform.LoadbalancerVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.Visitor;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;

public class LoadbalancerReaderImpl
implements LoadbalancerReader {
    LbConfig _lbConfig = null;
    ConfigContext _ctx = null;
    private static final StringManager _localStrMgr = StringManager.getManager((Class)LoadbalancerReaderImpl.class);

    public LoadbalancerReaderImpl(ConfigContext ctx, LbConfig lbConfig) {
        if (lbConfig == null || ctx == null) {
            String msg = _localStrMgr.getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }
        this._ctx = ctx;
        this._lbConfig = lbConfig;
    }

    public PropertyReader[] getProperties() throws LbReaderException {
        PropertyReader[] props = new PropertyReaderImpl[]{new PropertyReaderImpl(this._lbConfig, "response-timeout-in-seconds"), new PropertyReaderImpl(this._lbConfig, "reload-poll-interval-in-seconds"), new PropertyReaderImpl(this._lbConfig, "https-routing"), new PropertyReaderImpl(this._lbConfig, "require-monitor-data"), new PropertyReaderImpl(this._lbConfig, "route-cookie-enabled")};
        return props;
    }

    public ClusterReader[] getClusters() throws LbReaderException {
        ArrayList<ClusterReaderImpl> list = new ArrayList<ClusterReaderImpl>();
        ClusterRef[] clusters = this._lbConfig.getClusterRef();
        ServerRef[] servers = this._lbConfig.getServerRef();
        if (!(clusters != null && clusters.length != 0 || servers != null && servers.length != 0)) {
            return null;
        }
        int total = clusters.length + servers.length;
        ClusterReader clImpls = null;
        for (int i = 0; i < clusters.length; ++i) {
            clImpls = new ClusterReaderImpl(this._ctx, this._lbConfig.getClusterRef(i));
            list.add((ClusterReaderImpl)clImpls);
        }
        for (int j = clusters.length; j < total; ++j) {
            clImpls = new StandAloneClusterReaderImpl(this._ctx, this._lbConfig.getServerRef(j - clusters.length));
            list.add((ClusterReaderImpl)clImpls);
        }
        ClusterReader[] cls = new ClusterReader[list.size()];
        return list.toArray(cls);
    }

    public String getName() throws LbReaderException {
        return this._lbConfig.getName();
    }

    public void accept(Visitor v) {
        LoadbalancerVisitor cv = (LoadbalancerVisitor)v;
        cv.visit(this);
    }
}

