/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.WebModuleReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.LocationHelperImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.WebModuleReaderImpl;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterReaderHelper {
    private static final StringManager _strMgr = StringManager.getManager((Class)ClusterReaderHelper.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());

    public static WebModuleReader[] getWebModules(ConfigContext _configCtx, ApplicationRef[] refs, String target) throws LbReaderException {
        ArrayList<WebModuleReaderImpl> list = new ArrayList<WebModuleReaderImpl>();
        for (int i = 0; i < refs.length; ++i) {
            J2eeApplication app;
            Object l;
            String name = refs[i].getRef();
            ConfigBean bean = null;
            try {
                bean = ApplicationHelper.findApplication((ConfigContext)_configCtx, (String)name);
            }
            catch (ConfigException ce) {
                String msg = _strMgr.getString("ErrorFindingApplication", (Object)name, (Object)target);
                throw new LbReaderException(msg, ce);
            }
            LocationHelperImpl lhelper = new LocationHelperImpl(_configCtx);
            if (bean instanceof WebModule) {
                WebModule wMod = (WebModule)bean;
                if (wMod == null || !wMod.getObjectType().equals("user")) continue;
                l = lhelper.getSunWebXmlPathForModule(wMod.getName());
                WebModuleReaderImpl wr = new WebModuleReaderImpl(_configCtx, refs[i], bean, ClusterReaderHelper.createSunWebApp((String)l));
                list.add(wr);
                continue;
            }
            if (!(bean instanceof J2eeApplication) || (app = (J2eeApplication)bean) == null || !app.getObjectType().equals("user")) continue;
            l = lhelper.getSunWebXmlPathForApplication(app.getName());
            int size = l.size();
            for (int j = 0; j < size; ++j) {
                WebModuleReaderImpl wr = new WebModuleReaderImpl(_configCtx, refs[i], null, ClusterReaderHelper.createSunWebApp((String)l.get(j)));
                list.add(wr);
            }
        }
        WebModuleReader[] webModules = new WebModuleReader[list.size()];
        return list.toArray(webModules);
    }

    public static SunWebApp createSunWebApp(String l) throws LbReaderException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(l));
        }
        catch (FileNotFoundException fne) {
            _logger.log(Level.WARNING, _sMgr.getString("http_lb_admin.sunweb.xml.not.found", (Object)l));
        }
        SunWebApp sw = null;
        try {
            sw = SunWebApp.createGraph((InputStream)in);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, _sMgr.getString("http_lb_admin.sunweb.bean.create.failed", (Object)e));
        }
        return sw;
    }
}

