/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBCreateDBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;

class HADBCreateDB {
    private HADBCreateDBInfo info;

    HADBCreateDB(HADBCreateDBInfo info) {
        this.info = info;
    }

    void create() throws HADBSetupException {
        String[] commands = this.info.getCreateCommands();
        HADBMExecutor exec = new HADBMExecutor();
        int exitValue = exec.exec(this.info.getExecutable(), commands);
        if (exitValue != 0) {
            throw new HADBSetupException("hadbmgmt-res.CreateFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
        }
        LoggerHelper.fine("hadbmgmt-res.CreateDBOutput", exec.getStdout(), exec.getStderr());
    }

    void delete() throws HADBSetupException {
        HADBMExecutor exec = new HADBMExecutor();
        String[] commands = this.info.getStopCommands();
        int exitValue = exec.exec(this.info.getExecutable(), commands);
        commands = this.info.getDeleteCommands();
        exitValue = exec.exec(this.info.getExecutable(), commands);
        if (exitValue != 0) {
            throw new HADBSetupException("hadbmgmt-res.DeleteFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
        }
        LoggerHelper.fine("hadbmgmt-res.DeleteDBOutput", exec.getStdout(), exec.getStderr());
    }

    boolean exists() throws HADBSetupException {
        HADBMExecutor r = new HADBMExecutor();
        String[] commands = this.info.getExistsCommands();
        int exitValue = r.exec(this.info.getExecutable(), commands);
        if (exitValue == 0) {
            this.info.setDBPreExists();
            return true;
        }
        return false;
    }
}

