/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedNameLogger;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfoCache;
import com.sun.enterprise.ee.admin.dottedname.DottedNameServerInfoEE;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DottedNameServerInfoCacheEE
extends DottedNameServerInfoCache
implements DottedNameServerInfoEE {
    Set mUnclusteredServerNames;
    DottedNameServerInfoEE mSrc;
    private HashMap mAppsToServers;
    private HashMap mResToServers;

    public DottedNameServerInfoCacheEE(DottedNameServerInfoEE src) {
        super((DottedNameServerInfo)src);
        this.mSrc = src;
        this.mUnclusteredServerNames = Collections.EMPTY_SET;
        this.mAppsToServers = new HashMap();
        this.mResToServers = new HashMap();
    }

    public synchronized void refresh() {
        try {
            this.resetCache();
            this.mUnclusteredServerNames = this.mSrc.getUnclusteredServerNames();
            this.mapAppsToServers();
            this.mapResToServers();
            super.refresh();
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
    }

    private void resetCache() {
        this.mUnclusteredServerNames = Collections.EMPTY_SET;
        this.mAppsToServers.clear();
        this.mResToServers.clear();
    }

    public synchronized Set getUnclusteredServerNames() {
        return this.mUnclusteredServerNames;
    }

    public Set getApplicationNamesForServer(String serverName) throws Exception {
        return (Set)this.mAppsToServers.get(serverName);
    }

    public Set getResourceNamesForServer(String serverName) throws Exception {
        return (Set)this.mResToServers.get(serverName);
    }

    private void mapAppsToServers() throws Exception {
        Iterator iter = this.mUnclusteredServerNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Set apps = this.mSrc.getApplicationNamesForServer(name);
            if (apps == null) continue;
            this.mAppsToServers.put(name, apps);
        }
    }

    private void mapResToServers() throws Exception {
        Iterator iter = this.mUnclusteredServerNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Set res = this.mSrc.getResourceNamesForServer(name);
            if (res == null) continue;
            this.mResToServers.put(name, res);
        }
    }
}

