/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedNameLogger;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.util.ArrayConversion;
import com.sun.enterprise.ee.admin.dottedname.DottedNameClusterInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DottedNameClusterInfoImpl
implements DottedNameClusterInfo {
    final MBeanServerConnection mConn;

    public DottedNameClusterInfoImpl(MBeanServerConnection conn) {
        this.mConn = conn;
    }

    ObjectName getConfigsObjectName() throws MalformedObjectNameException {
        return new ObjectName("com.sun.appserv:type=configs,category=config");
    }

    Set _getConfigNames() throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, MalformedObjectNameException, AttributeNotFoundException {
        ObjectName[] configObjectNames = (ObjectName[])this.mConn.invoke(this.getConfigsObjectName(), "getConfig", null, null);
        HashSet<String> configNames = new HashSet<String>();
        for (int i = 0; i < configObjectNames.length; ++i) {
            String name = (String)this.mConn.getAttribute(configObjectNames[i], "name");
            configNames.add(name);
        }
        return configNames;
    }

    public Set getConfigNames() throws DottedNameServerInfo.UnavailableException {
        Set namesSet;
        try {
            namesSet = this._getConfigNames();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e.getCause());
        }
        return namesSet;
    }

    Set _getClusterNames() throws ReflectionException, InstanceNotFoundException, MBeanException, IOException {
        String[] domains = new String[]{MBeanRegistryFactory.getAdminContext().getDomainName()};
        MBeanRegistry reg = MBeanRegistryFactory.getAdminMBeanRegistry();
        MyClusters clusters = (MyClusters)MBeanServerInvocationHandler.newProxyInstance(this.mConn, reg.getMbeanObjectName("clusters", domains), MyClusters.class, false);
        Object[] names = clusters.listClustersAsString("domain", false);
        return ArrayConversion.toSet((Object[])names);
    }

    public Set getClusterNames() throws DottedNameServerInfo.UnavailableException {
        Set namesSet;
        try {
            namesSet = this._getClusterNames();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e.getCause());
        }
        return namesSet;
    }

    String[] _getServerNamesForCluster(String clusterName) throws ReflectionException, InstanceNotFoundException, MBeanException, IOException {
        ObjectName clusterObjectName = this.getClusterObjectName(clusterName);
        MyCluster cluster = (MyCluster)MBeanServerInvocationHandler.newProxyInstance(this.mConn, clusterObjectName, MyCluster.class, false);
        return cluster.listServerInstancesAsString(false);
    }

    public String[] getServerNamesForCluster(String clusterName) throws Exception {
        String[] namesSet;
        try {
            namesSet = this._getServerNamesForCluster(clusterName);
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e.getCause());
        }
        return namesSet;
    }

    public boolean isClusteredInstance(String serverName) {
        try {
            Iterator iter = this.getClusterNames().iterator();
            while (iter.hasNext()) {
                String[] serverNames = this.getServerNamesForCluster((String)iter.next());
                if (serverNames == null) continue;
                for (int i = 0; i < serverNames.length; ++i) {
                    if (!serverNames[i].equals(serverName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
        return false;
    }

    public String getConfigNameForCluster(String clusterName) throws DottedNameServerInfo.UnavailableException {
        String configName;
        ObjectName clusterObjectName = this.getClusterObjectName(clusterName);
        try {
            configName = (String)this.mConn.getAttribute(clusterObjectName, "config_ref");
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException(e.getCause());
        }
        return configName;
    }

    private ObjectName getClusterObjectName(String clusterName) {
        String[] domains = new String[]{MBeanRegistryFactory.getAdminContext().getDomainName(), clusterName, "config"};
        MBeanRegistry reg = MBeanRegistryFactory.getAdminMBeanRegistry();
        return reg.getMbeanObjectName("cluster", domains);
    }

    public String[] getClusterNamesForConfig(String configName) throws DottedNameServerInfo.UnavailableException {
        Iterator iter = this.getClusterNames().iterator();
        ArrayList<String> namesOut = new ArrayList<String>();
        while (iter.hasNext()) {
            String clusterName = (String)iter.next();
            if (!configName.equals(this.getConfigNameForCluster(clusterName))) continue;
            namesOut.add(clusterName);
        }
        String[] namesOutArray = new String[namesOut.size()];
        namesOut.toArray(namesOutArray);
        return namesOutArray;
    }

    public Set getResourceNamesForCluster(String clusterName) throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, DottedNameServerInfo.UnavailableException {
        ObjectName clusterObjectName = this.getClusterObjectName(clusterName);
        MyCluster cluster = (MyCluster)MBeanServerInvocationHandler.newProxyInstance(this.mConn, clusterObjectName, MyCluster.class, false);
        Object[] resourceNames = cluster.listResourceReferencesAsString();
        return ArrayConversion.toSet((Object[])resourceNames);
    }

    public Set getApplicationNamesForCluster(String clusterName) throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, DottedNameServerInfo.UnavailableException {
        ObjectName clusterObjectName = this.getClusterObjectName(clusterName);
        MyCluster cluster = (MyCluster)MBeanServerInvocationHandler.newProxyInstance(this.mConn, clusterObjectName, MyCluster.class, false);
        Object[] appNames = cluster.listApplicationReferencesAsString();
        return ArrayConversion.toSet((Object[])appNames);
    }

    public String[] getTargetsSharingResource(String resourceName) throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, AttributeNotFoundException, DottedNameServerInfo.UnavailableException, MalformedObjectNameException {
        MyResources resources = this.getResourcesProxy();
        ObjectName[] targetObjectNames = resources.listReferencees(resourceName);
        return this.getTargets(targetObjectNames);
    }

    public String[] getTargetsSharingConfig(String configName) throws Exception {
        MyConfig config = this.getConfigProxy(configName);
        ObjectName[] targetObjectNames = config.listReferencees();
        return this.getTargets(targetObjectNames);
    }

    public String[] getTargetsSharingApplication(String applicationName) throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, AttributeNotFoundException, DottedNameServerInfo.UnavailableException, MalformedObjectNameException {
        MyApplications apps = this.getApplicationsProxy();
        ObjectName[] targetObjectNames = apps.listReferencees(applicationName);
        return this.getTargets(targetObjectNames);
    }

    public String[] getAllResourceNames() {
        Set resNames = Collections.EMPTY_SET;
        try {
            Iterator i = this.getAllTargets().iterator();
            while (i.hasNext()) {
                Object[] res = this.getResourcesProxy().listResourceReferencesAsString((String)i.next());
                resNames.add(ArrayConversion.toSet((Object[])res));
            }
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
        return (String[])resNames.toArray();
    }

    private Collection getAllTargets() throws DottedNameServerInfo.UnavailableException, MalformedObjectNameException {
        Vector names = new Vector();
        Iterator iter = this.getClusterNames().iterator();
        while (iter.hasNext()) {
            names.add(iter.next());
        }
        iter = this.getUnclusteredInstancesNames().iterator();
        while (iter.hasNext()) {
            names.add(iter.next());
        }
        return names;
    }

    private Collection getUnclusteredInstancesNames() throws MalformedObjectNameException {
        ObjectName obj = new ObjectName("com.sun.appserv:type=servers,category=config");
        myServers servers = (myServers)MBeanServerInvocationHandler.newProxyInstance(this.mConn, obj, myServers.class, false);
        return ArrayConversion.toSet((Object[])servers.listUnclusteredServerInstancesAsString(false));
    }

    public String[] getAllApplicationNames() throws MalformedObjectNameException {
        Set appsNames = Collections.EMPTY_SET;
        try {
            Iterator i = this.getAllTargets().iterator();
            while (i.hasNext()) {
                Object[] apps = this.getApplicationsProxy().listApplicationReferencesAsString((String)i.next());
                appsNames.add(ArrayConversion.toSet((Object[])apps));
            }
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
        return (String[])appsNames.toArray();
    }

    private MyResources getResourcesProxy() throws MalformedObjectNameException {
        ObjectName obj = new ObjectName("com.sun.appserv:type=resources,category=config");
        return (MyResources)MBeanServerInvocationHandler.newProxyInstance(this.mConn, obj, MyResources.class, false);
    }

    private MyApplications getApplicationsProxy() throws MalformedObjectNameException {
        ObjectName obj = new ObjectName("com.sun.appserv:type=applications,category=config");
        return (MyApplications)MBeanServerInvocationHandler.newProxyInstance(this.mConn, obj, MyApplications.class, false);
    }

    private MyConfig getConfigProxy(String configName) throws MalformedObjectNameException {
        ObjectName obj = new ObjectName("com.sun.appserv:type=config,name=" + configName + ",category=config");
        return (MyConfig)MBeanServerInvocationHandler.newProxyInstance(this.mConn, obj, MyConfig.class, false);
    }

    private String[] getTargets(ObjectName[] targetObjectNames) throws ReflectionException, IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException {
        Vector<Object> targets = new Vector<Object>();
        for (int i = 0; i < targetObjectNames.length; ++i) {
            targets.add(this.mConn.getAttribute(targetObjectNames[i], "name"));
        }
        return targets.toArray(new String[targets.size()]);
    }

    private static interface myServers {
        public String[] listUnclusteredServerInstancesAsString(boolean var1);
    }

    private static interface MyApplications {
        public ObjectName[] listReferencees(String var1);

        public String[] listApplicationReferencesAsString(String var1);
    }

    private static interface MyConfig {
        public ObjectName[] listReferencees();
    }

    private static interface MyResources {
        public ObjectName[] listReferencees(String var1);

        public String[] listResourceReferencesAsString(String var1);
    }

    private static interface MyCluster {
        public String[] listServerInstancesAsString(boolean var1);

        public String[] listResourceReferencesAsString();

        public String[] listApplicationReferencesAsString();
    }

    private static interface MyClusters {
        public String[] listClustersAsString(String var1, boolean var2);
    }
}

