/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameAliasSupport;
import com.sun.enterprise.admin.dottedname.DottedNameAliasedQuery;
import com.sun.enterprise.admin.dottedname.DottedNameFactory;
import com.sun.enterprise.admin.dottedname.DottedNameQuery;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.ee.admin.dottedname.DottedNameClusterInfo;
import com.sun.enterprise.ee.admin.dottedname.DottedNameResolverForAliasesEE;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DottedNameAliasedQueryEE
extends DottedNameAliasedQuery {
    DottedNameClusterInfo mClusterInfo;
    DottedNameResolverForAliasesEE mAliasResolver;
    DottedNameServerInfo mServerInfo;

    public DottedNameAliasedQueryEE(DottedNameQuery srcQuery, DottedNameServerInfo serverInfo, DottedNameClusterInfo clusterInfo) {
        super(srcQuery, serverInfo);
        this.mServerInfo = serverInfo;
        this.mClusterInfo = clusterInfo;
        this.mAliasResolver = new DottedNameResolverForAliasesEE(srcQuery, serverInfo, clusterInfo);
    }

    protected Set allDottedNameStringsThrow() throws DottedNameServerInfo.UnavailableException {
        Set srcSet = this.mSrcQuery.allDottedNameStrings();
        Iterator iter = srcSet.iterator();
        HashSet<String> destSet = new HashSet<String>();
        Set configNames = this.mServerInfo.getConfigNames();
        try {
            configNames.addAll(this.mClusterInfo.getConfigNames());
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
        while (iter.hasNext()) {
            String dottedName = (String)iter.next();
            DottedName dn = DottedNameFactory.getInstance().get(dottedName);
            String scope = dn.getScope();
            if (DottedNameAliasSupport.scopeIsDomain((String)scope)) {
                if (DottedNameAliasSupport.isAliasedDomain((DottedName)dn)) {
                    destSet.add(dottedName);
                    this.addAllNamesForDomain(dn, destSet);
                    continue;
                }
                destSet.add(dottedName);
                continue;
            }
            if (configNames.contains(scope)) {
                this.addAllNamesForConfig(dn, destSet);
                destSet.add(dottedName);
                continue;
            }
            destSet.add(dottedName);
        }
        return destSet;
    }

    /*
     * WARNING - void declaration
     */
    protected void addAllNamesForDomain(DottedName domainDN, Set outSet) throws DottedNameServerInfo.UnavailableException {
        void var3_3;
        try {
            Iterator iter = this.mClusterInfo.getClusterNames().iterator();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
        while (var3_3.hasNext()) {
            String clusterName = (String)var3_3.next();
            String dottedNameString = DottedName.toString((String)domainDN.getDomain(), (String)clusterName, (List)domainDN.getParts());
            DottedName newName = DottedNameFactory.getInstance().get(dottedNameString);
            outSet.add(newName.toString());
        }
        super.addAllNamesForDomain(domainDN, outSet);
    }

    protected void addAllNamesForConfig(DottedName configDN, Set outSet) throws DottedNameServerInfo.UnavailableException {
        String[] clusterNames;
        try {
            clusterNames = this.mClusterInfo.getClusterNamesForConfig(configDN.getScope());
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
        if (clusterNames != null) {
            for (int i = 0; i < clusterNames.length; ++i) {
                String newName = DottedName.toString((String)configDN.getDomain(), (String)clusterNames[i], (List)configDN.getParts());
                outSet.add(newName);
            }
        }
        super.addAllNamesForConfig(configDN, outSet);
    }
}

