/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.cascading;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.cascading.CascadingLifecycleImpl;
import com.sun.enterprise.server.ApplicationServer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.remote.JMXConnector;

public class InstanceCascadingMBean
implements DynamicMBean {
    private String dClassName = this.getClass().getName();
    private String dDescription = "Implementation of a instance cascading dynamic MBean";
    private MBeanAttributeInfo[] dAttributes = new MBeanAttributeInfo[0];
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[2];
    private MBeanInfo dMBeanInfo = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");

    public InstanceCascadingMBean() {
        this.buildDynamicMBeanInfo();
    }

    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        throw new AttributeNotFoundException("Cannot find " + attribute_name + " attribute in " + this.dClassName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("cascadeInstance")) {
            if (params[0] == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("instance name cannot be null"), "Cannot invoke cascade operation in " + this.dClassName);
            }
            this.cascadeInstance((String)params[0]);
            return null;
        }
        if (operationName.equals("stopCascadeInstance")) {
            if (params[0] == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("instance name cannot be null"), "Cannot invoke stop cascade operation in " + this.dClassName);
            }
            this.stopCascadeInstance((String)params[0]);
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
    }

    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("InstanceCascadingMBean(): Constructs InstanceCascadingMBean object", constructors[0]);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("instanceName", "java.lang.String", "Server Instance Name")};
        this.dOperations[0] = new MBeanOperationInfo("cascadeInstance", "cascade remote server instance", params, "void", 1);
        this.dOperations[1] = new MBeanOperationInfo("stopCascadeInstance", "stop cascading remote server instance", params, "void", 1);
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, this.dAttributes, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    private void cascadeInstance(String instanceName) {
        String domain = ApplicationServer.getServerContext().getDefaultDomainName();
        ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            JMXConnector jmxConnector = ServerHelper.getJMXConnector((ConfigContext)configContext, (String)instanceName);
            CascadingLifecycleImpl cli = new CascadingLifecycleImpl();
            cli.cascadeInstance(domain, instanceName, jmxConnector);
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.get_server_connector_config_error", ce);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.IOException", ioe);
        }
    }

    private void stopCascadeInstance(String instanceName) {
        CascadingLifecycleImpl cli = new CascadingLifecycleImpl();
        cli.stopCascadeInstance(instanceName);
    }
}

