/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.cascading;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.DomainStatusHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.cascading.ASProxyCascadingAgent;
import com.sun.enterprise.ee.admin.cascading.CascadingConnectionNotifListener;
import com.sun.enterprise.ee.admin.cascading.InstanceCascadingMBean;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jdmk.remote.cascading.BasicMBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;

public class CascadingLifecycleImpl
implements ServerLifecycle {
    private static final Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManager _strMgr = StringManager.getManager((Class)CascadingLifecycleImpl.class);
    private static HashMap cMap = new HashMap();
    private static ObjectName icmbON = null;
    private DomainStatusHelper dsh = null;

    public CascadingLifecycleImpl() {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.init");
        this.dsh = new DomainStatusHelper();
    }

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.onInitialization");
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.onStartup");
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.onReady");
        ConfigContext configContext = sc.getConfigContext();
        String instanceName = sc.getInstanceName();
        try {
            if (ServerHelper.isDAS((ConfigContext)configContext, (String)instanceName)) {
                this.registerInstanceCascadingMBean(sc);
                this.cascadeInstances(sc);
            } else {
                this.invokeDASCascading(sc);
            }
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.ServerHelper_isDAS_error", ce);
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.onShutdown");
    }

    public void onTermination() throws ServerLifecycleException {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.onTermination");
        ServerContext sc = ApplicationServer.getServerContext();
        ConfigContext configContext = sc.getConfigContext();
        String instanceName = sc.getInstanceName();
        try {
            if (ServerHelper.isDAS((ConfigContext)configContext, (String)instanceName)) {
                this.stopCascadeInstances();
                this.unregisterInstanceCascadingMBean();
            } else {
                this.stopDASCascading();
            }
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.ServerHelper_isDAS_error", ce);
        }
    }

    private void debug(String str) {
        System.out.println("MSR: cascading: " + str);
    }

    private void cascadeInstances(ServerContext sc) {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.cascadeInstances");
        ConfigContext configContext = sc.getConfigContext();
        String serverName = null;
        Server[] serverArr = null;
        JMXConnector jmxConnector = null;
        try {
            serverArr = ServerHelper.getServersInDomain((ConfigContext)configContext);
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.get_servers_in_domain_error", ce);
        }
        for (int i = 0; i < serverArr.length; ++i) {
            serverName = serverArr[i].getName();
            try {
                if (ServerHelper.isDAS((ConfigContext)configContext, (String)serverName)) continue;
                try {
                    jmxConnector = ServerHelper.getJMXConnector((ConfigContext)configContext, (String)serverName);
                    this.cascadeInstance(sc.getDefaultDomainName(), serverName, jmxConnector);
                }
                catch (ConfigException ce1) {
                    ce1.printStackTrace();
                    _logger.log(Level.WARNING, "admin_ee.get_server_connector_config_error", ce1);
                    this.dsh.setstate(serverName, 3);
                }
                catch (IOException ioe) {
                    CascadingLifecycleImpl.setCMap(serverName, null);
                    this.dsh.setstate(serverName, 4);
                }
                continue;
            }
            catch (ConfigException ce) {
                ce.printStackTrace();
                _logger.log(Level.WARNING, "admin_ee.server_helper_is_das_error", ce);
            }
        }
    }

    private void stopCascadeInstances() {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.stopCascadeInstances");
        HashMap hMap = (HashMap)cMap.clone();
        Set keySet = hMap.keySet();
        if (keySet != null) {
            Iterator itr = keySet.iterator();
            while (itr.hasNext()) {
                this.stopCascadeInstance((String)itr.next());
            }
        }
    }

    private static void setCMap(String serverName, ObjectName on) {
        if (cMap.containsKey(serverName)) {
            cMap.remove(serverName);
        }
        cMap.put(serverName, on);
    }

    void cascadeInstance(String domain, String serverName, JMXConnector jmxConnector) {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.cascadeInstance.serverName = " + serverName);
        ObjectName cascadingAgentName = null;
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        boolean mfail = false;
        try {
            cascadingAgentName = (ObjectName)cMap.remove(serverName);
            if (cascadingAgentName != null) {
                mbs.unregisterMBean(cascadingAgentName);
            }
        }
        catch (MBeanException e) {
            e.printStackTrace();
            _logger.log(Level.FINE, "admin_ee.cascadeInstance_unregisterMBean", e);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
            _logger.log(Level.FINE, "admin_ee.cascadeInstance_unregisterMBean", infe);
        }
        try {
            cascadingAgentName = new ObjectName(domain + ":type=CascadingAgent,serverName=" + serverName);
            MBeanServerConnectionFactory mbscf = BasicMBeanServerConnectionFactory.newInstance((JMXConnector)jmxConnector);
            ObjectName runtimeFilterON = new ObjectName(domain + ":category=runtime,*");
            ObjectName webmoduleFilterON = new ObjectName(domain + ":j2eeType=WebModule,*");
            ObjectName servletFilterON = new ObjectName(domain + ":j2eeType=Servlet,*");
            ObjectName monitorFilterON = new ObjectName(domain + ":category=monitor,*");
            ObjectName runtimeServerFilterON = new ObjectName(domain + ":category=runtime,j2eeType=J2EEServer,*");
            QueryExp queryExp = Query.or(webmoduleFilterON, Query.or(servletFilterON, Query.or(monitorFilterON, Query.and(runtimeFilterON, Query.not(runtimeServerFilterON)))));
            ASProxyCascadingAgent cascadingAgent = new ASProxyCascadingAgent(mbscf, new ObjectName(domain + ":*"), queryExp, null);
            CascadingConnectionNotifListener ccnl = new CascadingConnectionNotifListener(serverName);
            cascadingAgent.addNotificationListener(ccnl, null, null);
            ObjectInstance cascadingAgentInstance = mbs.registerMBean((Object)cascadingAgent, cascadingAgentName);
            mbs.invoke(cascadingAgentName, "start", null, null);
            CascadingLifecycleImpl.setCMap(serverName, cascadingAgentName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_malformedObjectName", e);
            mfail = true;
        }
        catch (InstanceAlreadyExistsException iae) {
            iae.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_InstanceAlreadyExists", iae);
            mfail = true;
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_InstanceNotFound", infe);
            mfail = true;
        }
        catch (MBeanRegistrationException mbre) {
            mbre.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_mBeanRegistrationException", mbre);
            mfail = true;
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_mBeanException", mbe);
            mfail = true;
        }
        catch (NotCompliantMBeanException ncmbe) {
            ncmbe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_NotCompliantMBeanException", ncmbe);
            mfail = true;
        }
        catch (ReflectionException re) {
            re.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_ReflectionException", re);
            mfail = true;
        }
        if (mfail) {
            this.dsh.setstate(serverName, 4);
        } else {
            this.dsh.setstate(serverName, 1);
        }
    }

    void stopCascadeInstance(String serverName) {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.stopCascadeInstance.serverName = " + serverName);
        ObjectName cascadingAgentName = null;
        MBeanServer mbs = null;
        boolean mfail = false;
        try {
            cascadingAgentName = (ObjectName)cMap.remove(serverName);
            if (cascadingAgentName != null) {
                mbs = MBeanServerFactory.getMBeanServer();
                mbs.invoke(cascadingAgentName, "stop", null, null);
                mbs.unregisterMBean(cascadingAgentName);
            }
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
            _logger.log(Level.FINE, "admin_ee.cascadeInstance_InstanceNotFound", infe);
            mfail = true;
        }
        catch (MBeanRegistrationException mbre) {
            mbre.printStackTrace();
            _logger.log(Level.FINE, "admin_ee.cascadeInstance_mBeanRegistrationException", mbre);
            mfail = true;
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_mBeanException", mbe);
            mfail = true;
        }
        catch (ReflectionException re) {
            re.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_ReflectionException", re);
            mfail = true;
        }
        if (mfail) {
            this.dsh.setstate(serverName, 4);
        } else {
            this.dsh.setstate(serverName, 3);
        }
    }

    private void registerInstanceCascadingMBean(ServerContext sc) {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.registerInstanceCascadingMBean");
        String domain = sc.getDefaultDomainName();
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        try {
            icmbON = new ObjectName(this.getInstanceCascadingMBeanObjName(sc, sc.getInstanceName()));
            InstanceCascadingMBean icmb = new InstanceCascadingMBean();
            ObjectInstance icmbInstance = mbs.registerMBean(icmb, icmbON);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.MalformedObjectNameException", e);
        }
        catch (InstanceAlreadyExistsException iae) {
            iae.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.InstanceAlreadyExistsException", iae);
        }
        catch (MBeanRegistrationException mre) {
            mre.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.MBeanRegistrationException", mre);
        }
        catch (NotCompliantMBeanException ncmbe) {
            ncmbe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.NotCompliantMBeanException", ncmbe);
        }
    }

    private void unregisterInstanceCascadingMBean() {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.unregisterInstanceCascadingMBean");
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        try {
            if (icmbON != null) {
                mbs.unregisterMBean(icmbON);
            }
        }
        catch (InstanceNotFoundException iae) {
            iae.printStackTrace();
            _logger.log(Level.FINE, "admin_ee.InstanceAlreadyExistsException", iae);
        }
        catch (MBeanRegistrationException mre) {
            mre.printStackTrace();
            _logger.log(Level.FINE, "admin_ee.MBeanRegistrationException", mre);
        }
    }

    private void invokeDASCascading(ServerContext sc) {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.invokeDASCascading");
        ConfigContext configContext = sc.getConfigContext();
        if (!this.isDASRunning(configContext)) {
            _logger.log(Level.INFO, "cascading.noCascadingNeededStartup");
            return;
        }
        try {
            Server dasServer = ServerHelper.getDAS((ConfigContext)configContext);
            String dasInstanceName = dasServer.getName();
            MBeanServerConnection mbsc = ServerHelper.connect((ConfigContext)configContext, (String)dasInstanceName);
            ObjectName on = new ObjectName(this.getInstanceCascadingMBeanObjName(sc, dasInstanceName));
            String[] signature = new String[]{"java.lang.String"};
            Object[] param = new Object[]{sc.getInstanceName()};
            mbsc.invoke(on, "cascadeInstance", param, signature);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.MalformedObjectNameException", mone);
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.get_server_connector_config_error", ce);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.get_server_connector_config_error", ioe);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_InstanceNotFound", infe);
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_mBeanException", mbe);
        }
        catch (ReflectionException re) {
            re.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_ReflectionException", re);
        }
    }

    private void stopDASCascading() {
        _logger.log(Level.FINE, "CascadingLifecycleImpl.stopDASCascading");
        ServerContext sc = ApplicationServer.getServerContext();
        ConfigContext configContext = sc.getConfigContext();
        if (!this.isDASRunning(configContext)) {
            _logger.fine("Domain Admin Server is not running. No need to remove the cascading of MBeans");
            return;
        }
        try {
            Server dasServer = ServerHelper.getDAS((ConfigContext)configContext);
            String dasInstanceName = dasServer.getName();
            MBeanServerConnection mbsc = ServerHelper.connect((ConfigContext)configContext, (String)dasInstanceName);
            ObjectName on = new ObjectName(this.getInstanceCascadingMBeanObjName(sc, dasInstanceName));
            String[] signature = new String[]{"java.lang.String"};
            Object[] param = new Object[]{sc.getInstanceName()};
            mbsc.invoke(on, "stopCascadeInstance", param, signature);
        }
        catch (MalformedObjectNameException mone) {
            mone.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.MalformedObjectNameException", mone);
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.get_server_connector_config_error", ce);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.get_server_connector_config_error", ioe);
        }
        catch (InstanceNotFoundException infe) {
            infe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_InstanceNotFound", infe);
        }
        catch (MBeanException mbe) {
            mbe.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_mBeanException", mbe);
        }
        catch (ReflectionException re) {
            re.printStackTrace();
            _logger.log(Level.WARNING, "admin_ee.cascadeInstance_ReflectionException", re);
        }
    }

    private String getInstanceCascadingMBeanObjName(ServerContext sc, String instanceName) {
        return sc.getDefaultDomainName() + ":type=Cascading,serverName=" + instanceName + ",name=instanceCascadingMBean";
    }

    private boolean isDASRunning(ConfigContext ctx) {
        boolean running = false;
        try {
            MBeanServerConnection mbsc = InstanceRegistry.getDASConnection(ctx);
            mbsc.getDefaultDomain();
            running = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return running;
    }
}

