/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CommandValidationException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class LocalStringsManager {
    private String packageName;
    private String propertyFile;
    private Vector resourceBundles = new Vector();
    public static String DEFAULT_STRING_VALUE = "Key not found";

    public LocalStringsManager(String packageName, String propertyFile) {
        this.packageName = packageName;
        this.propertyFile = propertyFile;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(packageName + "." + propertyFile);
        this.resourceBundles.add(resourceBundle);
    }

    public LocalStringsManager(Vector localizePropertiesList) {
        for (int i = 0; i < localizePropertiesList.size(); ++i) {
            Properties properties = (Properties)localizePropertiesList.get(i);
            String packageNameStr = (String)properties.get("base-package");
            String propertyFileStr = (String)properties.get("property-file-name");
            ResourceBundle resourceBundle = ResourceBundle.getBundle(packageNameStr + "." + propertyFileStr);
            this.resourceBundles.add(resourceBundle);
        }
    }

    public String getPropertiesFile() {
        return this.propertyFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getString(String key) {
        Iterator resourcesIter = this.resourceBundles.iterator();
        String value = DEFAULT_STRING_VALUE + " (" + key + ")";
        while (resourcesIter.hasNext()) {
            ResourceBundle resourceBundle = (ResourceBundle)resourcesIter.next();
            try {
                value = resourceBundle.getString(key);
                break;
            }
            catch (MissingResourceException mre) {
            }
        }
        return value;
    }

    public String getString(String key, Object[] toInsert) throws CommandValidationException {
        String fmtStr = null;
        try {
            MessageFormat msgFormat = new MessageFormat(this.getString(key));
            fmtStr = msgFormat.format(toInsert);
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
        return fmtStr;
    }
}

