/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.HelpException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.enterprise.cli.framework.ValidOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class CommandLineParser {
    private String commandName = null;
    private HashMap optionsList = new HashMap();
    private Vector Operands = new Vector();
    private ValidCommand validCommand = null;
    private static final String ANY_SHORT_OPTION_REGEXP = "^-[^-.*]+";
    private static final String SHORT_OPTION_REGEXP = "^-[\\w?]+";
    private static final String SHORT_OPTION_ARGUMENT_REGEXP = "^-[\\w?](=.*)";
    private final String LONG_OPTION_REGEXP = "^--\\w[-\\w]*(=.*)*";
    private static final String COMMAND_NAME_REGEXP = "^[a-z][a-z0-9\\-\\_]*$";
    private static final String SHORT_OPTION_HELP_REGEXP = "-\\w*[h?]\\w*";
    private static final String HELP_OPTION = "--help";
    private static final String BOOLEAN_NO_OPTION = "--no-";
    private static final String BOOLEAN = "boolean";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public CommandLineParser() {
    }

    public CommandLineParser(ValidCommand validCommand) {
        this.validCommand = validCommand;
    }

    public CommandLineParser(String[] args, ValidCommand validCommand) throws CommandValidationException, HelpException {
        this.validCommand = validCommand;
        if (validCommand != null) {
            this.parseCommandLine(args);
        }
    }

    public void parseCommandLine(String[] args) throws CommandValidationException, HelpException {
        this.commandName = args[0];
        if (this.validCommand == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidCommand", new Object[]{this.commandName}));
        }
        for (int ii = 1; ii < args.length; ++ii) {
            if (args[ii].equals(HELP_OPTION) || args[ii].matches(SHORT_OPTION_HELP_REGEXP)) {
                throw new HelpException(this.commandName);
            }
            ii = args[ii].matches(ANY_SHORT_OPTION_REGEXP) ? this.verifyShortOptions(args, ii) : (args[ii].matches("^--\\w[-\\w]*(=.*)*") ? this.insertLongOption(args, ii) : this.insertOperands(Arrays.asList(args).listIterator(ii)));
        }
        this.insertEnvironmentOptions();
        this.insertDefaultOptions();
        this.replaceAlternativeOptions();
    }

    private int verifyShortOptions(String[] args, int ii) throws CommandValidationException {
        if (!args[ii].matches(SHORT_OPTION_REGEXP) && !args[ii].matches(SHORT_OPTION_ARGUMENT_REGEXP)) {
            throw new CommandValidationException(this.getLocalizedString("NoSuchOption", new Object[]{args[ii]}));
        }
        int index = this.insertShortOption(args, ii);
        return index;
    }

    private void insertShortOptionsGroup(String sOptions) throws CommandValidationException {
        for (int ii = 1; ii < sOptions.length(); ++ii) {
            String optionName = this.findOptionName(sOptions.charAt(ii));
            this.insertBooleanOption(optionName);
        }
    }

    private void insertBooleanOption(String optionName) throws CommandValidationException {
        if (this.checkOptionIsBoolean(optionName)) {
            this.optionsList.put(optionName, this.getDefaultBooleanValue(optionName));
        } else {
            this.optionsList.put(optionName, null);
        }
    }

    private int insertShortOption(String[] args, int ii) throws CommandValidationException {
        if (args[ii].length() > 2) {
            int index = args[ii].indexOf(61);
            if (index == -1) {
                this.insertShortOptionsGroup(args[ii]);
            } else {
                this.insertOptionWithEqualSign(this.findOptionName(args[ii].charAt(1)), args[ii].substring(index + 1));
            }
        } else if (ii + 1 < args.length) {
            String optionName = this.findOptionName(args[ii].charAt(1));
            if (args[ii + 1].startsWith("-") || this.checkOptionIsBoolean(optionName)) {
                this.insertBooleanOption(optionName);
            } else {
                this.optionsList.put(this.findOptionName(args[ii].charAt(1)), args[ii + 1]);
                ++ii;
            }
        } else {
            this.insertBooleanOption(this.findOptionName(args[ii].charAt(1)));
        }
        return ii;
    }

    private int insertLongOption(String[] args, int ii) throws CommandValidationException {
        int index = args[ii].indexOf(61);
        if (index == -1) {
            if (args[ii].startsWith(BOOLEAN_NO_OPTION) && this.checkOptionIsBoolean(args[ii].substring(BOOLEAN_NO_OPTION.length()))) {
                this.optionsList.put(args[ii].substring(BOOLEAN_NO_OPTION.length()), FALSE);
            } else if (this.checkOptionIsBoolean(args[ii].substring(2))) {
                this.optionsList.put(args[ii].substring(2), TRUE);
            } else if (ii + 1 < args.length) {
                if (args[ii + 1].startsWith("-")) {
                    this.optionsList.put(args[ii].substring(2), null);
                } else {
                    this.optionsList.put(args[ii].substring(2), args[ii + 1]);
                    ++ii;
                }
            } else {
                this.optionsList.put(args[ii].substring(2), null);
            }
        } else {
            this.insertOptionWithEqualSign(args[ii].substring(2, index), args[ii].substring(index + 1));
        }
        return ii;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertOptionWithEqualSign(String optionName, String optionValue) throws CommandValidationException {
        if (this.checkOptionIsBoolean(optionName)) {
            if (optionValue == null || optionValue.compareToIgnoreCase(TRUE) != 0 && optionValue.compareToIgnoreCase(FALSE) != 0) throw new CommandValidationException(this.getLocalizedString("OptionIsBoolean", new Object[]{optionName}));
            this.optionsList.put(optionName, optionValue);
            return;
        } else {
            this.optionsList.put(optionName, optionValue);
        }
    }

    private void insertDefaultOptions() {
        Vector allOptions = this.validCommand.getOptions();
        if (allOptions != null) {
            for (int ii = 0; ii < allOptions.size(); ++ii) {
                ValidOption currentOption = (ValidOption)allOptions.get(ii);
                if (currentOption == null || this.optionsList.containsKey(currentOption.getName()) || this.validCommand.hasDeprecatedOption(currentOption) || currentOption.getDefaultValue() == null) continue;
                CLILogger.getInstance().printDebugMessage("**** insert Default Options " + currentOption.getName() + "  " + currentOption.getDefaultValue());
                this.optionsList.put(currentOption.getName(), currentOption.getDefaultValue());
            }
        }
    }

    private void insertEnvironmentOptions() {
        HashMap envOptions = CommandEnvironment.getInstance().getEnvironments();
        Vector allOptions = this.validCommand.getOptions();
        if (envOptions != null) {
            for (int ii = 0; ii < allOptions.size(); ++ii) {
                ValidOption currentOption = (ValidOption)allOptions.get(ii);
                String optionName = currentOption.getName();
                if (currentOption == null || this.optionsList.containsKey(currentOption.getName()) || !envOptions.containsKey(optionName)) continue;
                CLILogger.getInstance().printDebugMessage("**** insert Environment Options " + optionName + "  " + (String)envOptions.get(optionName));
                this.optionsList.put(optionName, (String)envOptions.get(optionName));
            }
        }
    }

    private void replaceAlternativeOptions() {
        Vector optionNames = new Vector(this.optionsList.keySet());
        for (int ii = 0; ii < optionNames.size(); ++ii) {
            String optionName = (String)optionNames.get(ii);
            if (!this.validCommand.hasAlternateDeprecatedOption(optionName)) continue;
            String alternateOptionName = this.validCommand.getAlternateDeprecatedOption(optionName).getName();
            this.optionsList.put(alternateOptionName, (String)this.optionsList.get(optionName));
            CLILogger.getInstance().printWarning(this.getLocalizedString("OptionDeprecatedUseNew", new Object[]{optionName, alternateOptionName}));
            this.optionsList.remove(optionName);
        }
    }

    private int insertOperands(ListIterator operandIter) throws CommandValidationException {
        try {
            if (!((String)operandIter.next()).equals("--")) {
                this.Operands.add((String)operandIter.previous());
                operandIter.next();
            }
            while (operandIter.hasNext()) {
                this.Operands.add((String)operandIter.next());
            }
        }
        catch (NoSuchElementException nsee) {
            throw new CommandValidationException(nsee);
        }
        return operandIter.nextIndex();
    }

    private String findOptionName(char shortOption) throws CommandValidationException {
        Vector allOptions = this.validCommand.getOptions();
        if (allOptions != null) {
            for (int ii = 0; ii < allOptions.size(); ++ii) {
                Vector shortOptions = ((ValidOption)allOptions.get(ii)).getShortNames();
                if (!shortOptions.contains(String.valueOf(shortOption))) continue;
                return ((ValidOption)allOptions.get(ii)).getName();
            }
        }
        throw new CommandValidationException(this.getLocalizedString("NoSuchOption", new Object[]{String.valueOf(shortOption)}));
    }

    private boolean checkOptionIsBoolean(String optionName) {
        ValidOption option = this.validCommand.getOption(optionName);
        if (option != null) {
            return option.getType().compareToIgnoreCase(BOOLEAN) == 0;
        }
        return false;
    }

    private String getDefaultBooleanValue(String optionName) {
        ValidOption option = this.validCommand.getOption(optionName);
        if (option != null && option.getDefaultValue() != null && option.getDefaultValue().compareToIgnoreCase(TRUE) == 0) {
            return FALSE;
        }
        return TRUE;
    }

    public HashMap getOptionsList() {
        return this.optionsList;
    }

    public Vector getOperands() {
        return this.Operands;
    }

    protected String getLocalizedString(String key, Object[] toInsert) {
        try {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return LocalStringsManager.DEFAULT_STRING_VALUE;
        }
    }

    public String toString() {
        return "\n**********\nname = " + this.commandName + "\nOptions = " + this.optionsList + "\nOperands = " + this.Operands + "\n**********\n";
    }
}

