/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ICommand;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Command
implements ICommand {
    private static final char REPLACE_START_CHAR = '{';
    private static final char REPLACE_END_CHAR = '}';
    private static final char VARIABLE_START_CHAR = '$';
    private static final char OPERAND_START_CHAR = '#';
    private static final String PATTERN_MATCHING = "\\{([\\$\\#])(\\w+)\\}";
    protected String name = null;
    protected HashMap options;
    protected Vector operands = new Vector();
    protected String usageStr = null;
    protected Hashtable properties;
    private List booleanOptionsList = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Command() {
        this.options = new HashMap();
    }

    public abstract void runCommand() throws CommandException, CommandValidationException;

    public abstract boolean validateOptions() throws CommandValidationException;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vector getOperands() {
        return this.operands;
    }

    public void setOperands(Vector operands) {
        this.operands = operands;
    }

    public HashMap getOptions() {
        return this.options;
    }

    public void setOptions(HashMap options) {
        this.options = options;
    }

    public String getOption(String optionName) {
        if (!this.optionNameExist(optionName)) {
            return null;
        }
        return (String)this.options.get(optionName);
    }

    public void setOption(String optionName, String optionValue) {
        this.options.put(optionName, optionValue);
    }

    public void setBooleanOptions(List booleanOptions) {
        this.booleanOptionsList = booleanOptions;
    }

    protected boolean getBooleanOption(String optionName) {
        return new Boolean(this.getOption(optionName));
    }

    protected int getIntegerOption(String optionName) {
        if (!$assertionsDisabled && this.optionNameExist(optionName)) {
            throw new AssertionError();
        }
        return new Integer((String)this.options.get(optionName));
    }

    private boolean optionNameExist(String optionName) {
        return this.options.containsKey(optionName);
    }

    public String getUsageText() {
        return this.usageStr;
    }

    public void setUsageText(String usageText) {
        this.usageStr = usageText;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected Hashtable getProperties(String key) {
        return this.properties;
    }

    protected void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    protected String getLocalizedString(String key) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
        }
        catch (CommandValidationException cve) {
            return LocalStringsManager.DEFAULT_STRING_VALUE;
        }
        return lsm.getString(key);
    }

    protected String getLocalizedString(String key, Object[] toInsert) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return LocalStringsManager.DEFAULT_STRING_VALUE;
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.getName());
        Iterator optionNames = this.options.keySet().iterator();
        while (optionNames.hasNext()) {
            String optionKey = (String)optionNames.next();
            strbuf.append(" --" + optionKey);
            if (this.booleanOptionsList.contains(optionKey)) {
                strbuf.append("=");
            } else {
                strbuf.append(" ");
            }
            strbuf.append((String)this.options.get(optionKey));
        }
        for (int ii = 0; ii < this.operands.size(); ++ii) {
            strbuf.append(" " + this.operands.get(ii).toString());
        }
        return strbuf.toString();
    }

    public String replacePattern(String replaceValue) throws CommandException {
        if (replaceValue == null) {
            return null;
        }
        Pattern patt = Pattern.compile(PATTERN_MATCHING);
        Matcher match = patt.matcher(replaceValue);
        String outstr = replaceValue;
        try {
            if (match.find()) {
                StringBuffer strbuf = new StringBuffer();
                do {
                    String value = this.findPatternStringValue(match.group(1), match.group(2));
                    value = this.prepareStringForAppend(value);
                    match.appendReplacement(strbuf, value);
                    CLILogger.getInstance().printDebugMessage("strbuf = " + strbuf);
                } while (match.find());
                match.appendTail(strbuf);
                outstr = strbuf.toString();
            }
        }
        catch (IllegalArgumentException iae) {
            try {
                LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                throw new CommandException(lsm.getString("RequireEscapeChar"), iae);
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        return outstr.length() < 1 ? null : outstr;
    }

    private String findPatternStringValue(String pattern, String key) throws CommandException {
        String value = null;
        try {
            if (pattern.equals(String.valueOf('#'))) {
                if (this.operands.size() > 0) {
                    value = (String)this.getOperands().get(Integer.parseInt(key) - 1);
                }
            } else if (pattern.equals(String.valueOf('$'))) {
                value = this.getOption(key);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        return value == null ? "" : value;
    }

    private String prepareStringForAppend(String str) {
        String strTmp = this.escapeTheEscape(str);
        return this.addEscapeToLiteral(strTmp);
    }

    private String escapeTheEscape(String strToEscape) {
        StringBuffer strbuf = new StringBuffer();
        int previousIndex = 0;
        int index = strToEscape.indexOf("\\");
        while (index > -1) {
            if (strToEscape.charAt(index + 1) == '$') {
                strbuf.append(strToEscape.substring(previousIndex, index));
            } else {
                strbuf.append(strToEscape.substring(previousIndex, index) + "\\\\");
            }
            previousIndex = index + 1;
            index = strToEscape.indexOf("\\", index + 1);
        }
        strbuf.append(strToEscape.substring(previousIndex));
        return strbuf.toString();
    }

    private String addEscapeToLiteral(String strToAdd) {
        StringBuffer strbuf = new StringBuffer();
        int previousIndex = 0;
        int index = strToAdd.indexOf(36);
        while (index > -1) {
            strbuf.append(strToAdd.substring(previousIndex, index) + "\\$");
            previousIndex = index + 1;
            index = strToAdd.indexOf(36, index + 1);
        }
        strbuf.append(strToAdd.substring(previousIndex));
        return strbuf.toString();
    }

    protected int getDelimeterIndex(String searchStr, String delimeter, int fromIndex) {
        return searchStr.indexOf(delimeter, fromIndex);
    }

    static {
        $assertionsDisabled = !Command.class.desiredAssertionStatus();
    }
}

