/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.HashMap;
import java.util.Iterator;

public class UnsetCommand
extends S1ASCommand {
    private static final String ENVIRONMENT_PREFIX = "AS_ADMIN_";
    private static final String ENVIRONMENT_DELIMITER = "=";
    private CommandEnvironment commandEnvironment = CommandEnvironment.getInstance();

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        for (int ii = 0; ii < this.operands.size(); ++ii) {
            this.updateEnvironment((String)this.operands.elementAt(ii));
        }
    }

    private String checkForPrefix(String name) throws CommandException {
        String envName = null;
        if (!name.regionMatches(true, 0, ENVIRONMENT_PREFIX, 0, ENVIRONMENT_PREFIX.length())) {
            throw new CommandException(this.getLocalizedString("CouldNotUnsetVariable", new Object[]{name}));
        }
        envName = name.substring(ENVIRONMENT_PREFIX.length());
        return envName.toLowerCase();
    }

    private void updateEnvironment(String nameStr) throws CommandException {
        String envName = this.checkForPrefix(nameStr);
        if (envName.equals("*")) {
            this.removeAllEnvironments();
        } else if (this.commandEnvironment.removeEnvironment(envName) == null) {
            throw new CommandException(this.getLocalizedString("UnableToRemoveEnv", new Object[]{nameStr}));
        }
    }

    private void removeAllEnvironments() {
        HashMap envMap = new HashMap(this.commandEnvironment.getEnvironments());
        Iterator envIter = envMap.keySet().iterator();
        while (envIter.hasNext()) {
            String envName = (String)envIter.next();
            if (this.commandEnvironment.removeEnvironment(envName) != null) continue;
            CLILogger.getInstance().printWarning(this.getLocalizedString("UnableToRemoveEnv", new Object[]{envName}));
        }
    }
}

