/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.ProcessExecutor;
import java.io.File;
import java.util.BitSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public class StartDomainCommand
extends BaseLifeCycleCommand {
    private static final String SERVER_LOG_FILE_NAME = "server.log";
    private static final String LOGS_DIR = "logs";
    private static final String VERBOSE = "verbose";
    private static final String APPLICATION_SERVER_8_0 = "Application Server 8.0";
    private static final String DTD_FILE = "sun-domain_1_0";
    private static final long UPGRADE_TIMEOUT = 1200000L;

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void startDomain(String domainName) throws CommandException, CommandValidationException {
        try {
            DomainConfig config;
            DomainsManager mgr = this.getFeatureFactory().getDomainsManager();
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("StartingDomain", new Object[]{domainName}));
            if (!this.getBooleanOption(VERBOSE)) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("LogRedirectedTo", new Object[]{this.getDomainLogFile(domainName)}));
            }
            if (!this.isNotRunning(mgr, config = this.getDomainConfig(domainName))) {
                throw new CommandException(this.getLocalizedString("CannotStartDomainAlreadyRunning", new Object[]{domainName}));
            }
            mgr.validateDomain(config, true);
            BitSet flags = mgr.getDomainFlags();
            if (flags.get(1)) {
                config.put((Object)"domain.user", (Object)this.getUser());
                config.put((Object)"domain.password", (Object)this.getPassword());
                mgr.validateAdminUserAndPassword(config);
            }
            String masterPassword = this.getMasterPassword(new RepositoryManager(), (RepositoryConfig)config);
            config.put((Object)"domain.masterPassword", (Object)masterPassword);
            mgr.validateMasterPassword(config);
            String[] extraPasswordOptions = mgr.getExtraPasswordOptions(config);
            if (extraPasswordOptions != null) {
                config.put((Object)"domain.extraPasswords", (Object)this.getExtraPasswords(extraPasswordOptions));
            }
            mgr.startDomain(config);
            if (flags.get(1)) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DomainStarted", new Object[]{domainName}));
            } else {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DomainReady", new Object[]{domainName}));
            }
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("CannotStartDomain", new Object[]{domainName}), e);
        }
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        String domainName = null;
        try {
            domainName = this.getDomainName();
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            domainName = domainName == null ? this.getLocalizedString("Undefined") : domainName;
            throw new CommandException(this.getLocalizedString("CannotStartDomain", new Object[]{domainName}), e);
        }
        this.checkAndExecuteUpgrade(domainName);
        this.startDomain(domainName);
    }

    private void checkAndExecuteUpgrade(String domainName) throws CommandException {
        String domainDir = this.getDomainsRoot();
        CLILogger.getInstance().printDebugMessage("domainDir = " + domainDir);
        String installDir = System.getProperty("com.sun.aas.installRoot");
        CLILogger.getInstance().printDebugMessage("installDir = " + installDir);
        CLILogger.getInstance().printDebugMessage("domainName = " + domainName);
        if (this.checkIfVersion80(domainName, domainDir, installDir)) {
            try {
                String[] upgradeCmd = new String[]{installDir + File.separator + "bin" + File.separator + "asupgrade", "-c", "-s", domainDir + File.separator + domainName, "-t", installDir, "-noprompt"};
                ProcessExecutor pe = new ProcessExecutor(upgradeCmd, 1200000L);
                pe.execute();
                Process process = pe.getSubProcess();
                int exitValue = process.waitFor();
                if (exitValue != 0) {
                    System.out.println("Please exeucte asupgrade manually to upgrade the configuration");
                    throw new CommandException(this.getLocalizedString("UpgradeFailed"));
                }
            }
            catch (Exception e) {
                throw new CommandException(this.getLocalizedString("UpgradeFailed"), e);
            }
        }
    }

    private boolean checkIfVersion80(String domainName, String domainDir, String installDir) throws CommandException {
        File domainFile = new File(domainDir + File.separator + domainName + File.separator + "config" + File.separator + "domain.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(domainFile);
            String publicID = adminServerDoc.getDoctype().getPublicId();
            String systemID = adminServerDoc.getDoctype().getSystemId();
            CLILogger.getInstance().printDebugMessage("publicID = " + publicID);
            CLILogger.getInstance().printDebugMessage("systemID = " + systemID);
            return publicID.indexOf(APPLICATION_SERVER_8_0) != -1 && systemID.indexOf(DTD_FILE) != -1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getDomainLogFile(String domainName) throws CommandException {
        String logFile = this.getDomainsRoot() + File.separator + domainName + File.separator + LOGS_DIR + File.separator + SERVER_LOG_FILE_NAME;
        return logFile;
    }

    private boolean isNotRunning(DomainsManager mgr, DomainConfig cfg) throws Exception {
        InstancesManager im = mgr.getInstancesManager((RepositoryConfig)cfg);
        int state = im.getInstanceStatus();
        return state == 3;
    }
}

